/*
 * Decompiled with CFR 0.152.
 */
package org.ngrinder.common.util;

import net.grinder.common.UncheckedInterruptedException;
import org.ngrinder.common.util.NoOp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ThreadUtils {
    private static final int RETRY_MILLISECOND = 2000;
    private static final int THREAD_WAITING_TIME = 2000;
    private static final Logger LOGGER = LoggerFactory.getLogger(ThreadUtils.class);

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            throw new UncheckedInterruptedException(e);
        }
    }

    public static void stopQuietly(Thread thread, String stopMessage) {
        if (thread == null) {
            return;
        }
        try {
            thread.join(2000L);
        }
        catch (Exception e) {
            NoOp.noOp();
        }
        try {
            thread.interrupt();
        }
        catch (Exception e) {
            NoOp.noOp();
        }
        try {
            thread.join(2000L);
        }
        catch (Exception e) {
            NoOp.noOp();
        }
        try {
            if (thread.isAlive()) {
                LOGGER.error(stopMessage);
                thread.stop();
            }
        }
        catch (Exception e) {
            NoOp.noOp();
        }
    }
}

