/*
 * Decompiled with CFR 0.152.
 */
package org.ngrinder.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.ArrayList;
import org.ngrinder.common.exception.NGrinderRuntimeException;
import org.ngrinder.model.StatusCategory;

@JsonFormat(shape=JsonFormat.Shape.OBJECT)
@JsonDeserialize(using=StatusDeserializer.class)
public enum Status {
    SAVED(StatusCategory.PREPARE),
    READY(StatusCategory.PREPARE),
    CHECKOUT_SCRIPT(StatusCategory.PROGRESSING),
    PREPARE_DISTRIBUTION(StatusCategory.PROGRESSING),
    START_CONSOLE(StatusCategory.PROGRESSING),
    START_CONSOLE_FINISHED(StatusCategory.PROGRESSING),
    START_AGENTS(StatusCategory.PROGRESSING),
    START_AGENTS_FINISHED(StatusCategory.PROGRESSING),
    DISTRIBUTE_FILES(StatusCategory.PROGRESSING),
    DISTRIBUTE_FILES_FINISHED(StatusCategory.PROGRESSING),
    START_TESTING(StatusCategory.TESTING),
    TESTING(StatusCategory.TESTING),
    TESTING_FINISHED(StatusCategory.TESTING),
    ABNORMAL_TESTING(StatusCategory.ABNORMAL_TESTING),
    FINISHED(StatusCategory.FINISHED),
    FINISHED_WITH_WARNING(StatusCategory.WARNED),
    STOP_BY_ERROR(StatusCategory.ERROR),
    STOP_ON_ERROR(StatusCategory.ERROR),
    CANCELED(StatusCategory.STOP),
    UNKNOWN(StatusCategory.STOP);

    private final StatusCategory category;

    private Status(StatusCategory category) {
        this.category = category;
    }

    public String getName() {
        return this.name();
    }

    public StatusCategory getCategory() {
        return this.category;
    }

    public boolean isStoppable() {
        return this.category.isStoppable();
    }

    public boolean isReportable() {
        return this.category.isReportable();
    }

    public boolean isDeletable() {
        return this.category.isDeletable();
    }

    public String getIconName() {
        return this.category.getIconName();
    }

    public static Status[] getProcessingOrTestingTestStatus() {
        ArrayList<Status> status = new ArrayList<Status>();
        for (Status each : Status.values()) {
            if (!Status.isWorkingStatus(each)) continue;
            status.add(each);
        }
        return status.toArray(new Status[0]);
    }

    private static boolean isWorkingStatus(Status status) {
        return status.getCategory() == StatusCategory.PROGRESSING || status.getCategory() == StatusCategory.TESTING || status.getCategory() == StatusCategory.ABNORMAL_TESTING;
    }

    public static Status[] getTestStatesByCategory(StatusCategory statusCategory) {
        ArrayList<Status> status = new ArrayList<Status>();
        for (Status each : Status.values()) {
            if (!each.getCategory().equals((Object)statusCategory)) continue;
            status.add(each);
        }
        return status.toArray(new Status[0]);
    }

    public String getSpringMessageKey() {
        return "perftest.status." + this.name().toLowerCase();
    }

    public static class StatusDeserializer
    extends JsonDeserializer<Status> {
        public Status deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            JsonNode node = (JsonNode)parser.getCodec().readTree(parser);
            try {
                return Status.valueOf(node.textValue());
            }
            catch (IllegalArgumentException e) {
                if (node.get("status") != null) {
                    return Status.valueOf(node.get("status").asText());
                }
                throw new NGrinderRuntimeException("Status must present. you can use 'status' for data key");
            }
        }
    }
}

