/*
 * Decompiled with CFR 0.152.
 */
package net.grinder;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.grinder.communication.CommunicationException;
import net.grinder.engine.communication.AgentUpdateGrinderMessage;
import net.grinder.util.VersionNumber;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.ngrinder.common.util.CompressionUtils;
import org.ngrinder.common.util.Preconditions;
import org.ngrinder.infra.AgentConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentUpdateHandler
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgentUpdateHandler.class);
    private final AgentConfig agentConfig;
    private final File download;
    private final FileOutputStream agentOutputStream;
    private int offset = 0;

    public AgentUpdateHandler(AgentConfig agentConfig, AgentUpdateGrinderMessage message) throws FileNotFoundException {
        if (!agentConfig.getAgentProperties().getPropertyBoolean("agent.update_always")) {
            Preconditions.checkTrue(this.isNewer(message.getVersion(), agentConfig.getInternalProperties().getProperty("ngrinder.version")), "Update request was sent. But it's the older version " + message.getVersion());
        }
        this.agentConfig = agentConfig;
        this.download = new File(agentConfig.getHome().getTempDirectory(), "ngrinder-agent.tar");
        this.agentOutputStream = new FileOutputStream(this.download);
        LOGGER.info("AgentUpdateHandler is initialized!");
    }

    boolean isNewer(String newVersion, String installedVersion) {
        if (newVersion.contains("-SNAPSHOT")) {
            return true;
        }
        installedVersion = installedVersion.replaceAll("\\(.*\\)", "").trim();
        return new VersionNumber(newVersion = newVersion.replaceAll("\\(.*\\)", "").trim()).compareTo(new VersionNumber(installedVersion)) > 0;
    }

    @Override
    public void close() {
        IOUtils.closeQuietly((OutputStream)this.agentOutputStream);
        FileUtils.deleteQuietly((File)this.download);
    }

    public void update(AgentUpdateGrinderMessage message) throws CommunicationException {
        if (message.getOffset() != this.offset) {
            throw new CommunicationException("Expected " + this.offset + " offset, but " + message.getOffset() + " was sent. " + ToStringBuilder.reflectionToString((Object)message));
        }
        try {
            IOUtils.write((byte[])message.getBinary(), (OutputStream)this.agentOutputStream);
            this.offset = message.getNext();
        }
        catch (IOException e) {
            throw new CommunicationException("Error while writing binary", (Throwable)e);
        }
        if (message.getNext() == 0) {
            IOUtils.closeQuietly((OutputStream)this.agentOutputStream);
            this.decompressDownloadPackage();
            System.exit(0);
        }
    }

    void decompressDownloadPackage() {
        File interDir = new File(this.agentConfig.getHome().getTempDirectory(), "update_package_unpacked");
        File toDir = new File(this.agentConfig.getCurrentDirectory(), "update_package");
        interDir.mkdirs();
        toDir.mkdirs();
        if (FilenameUtils.isExtension((String)this.download.getName(), (String)"tar")) {
            File outFile = new File(toDir, "ngrinder-agent.tar");
            CompressionUtils.untar(this.download, interDir);
            FileUtils.deleteQuietly((File)outFile);
        } else {
            LOGGER.error("{} is not allowed to be unpacked.", (Object)this.download.getName());
        }
        try {
            FileUtils.deleteQuietly((File)toDir);
            FileUtils.moveDirectory((File)new File(interDir, "ngrinder-agent"), (File)toDir);
        }
        catch (IOException e) {
            LOGGER.error("Error while moving a file ", (Throwable)e);
        }
        FileUtils.deleteQuietly((File)this.download);
        FileUtils.deleteQuietly((File)interDir);
    }
}

