/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.engine.agent;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Set;
import net.grinder.common.UncheckedInterruptedException;
import net.grinder.communication.CommunicationException;
import net.grinder.communication.MessageDispatchRegistry;
import net.grinder.engine.common.EngineException;
import net.grinder.messages.agent.CacheHighWaterMark;
import net.grinder.messages.agent.ClearCacheMessage;
import net.grinder.messages.agent.DistributeFileMessage;
import net.grinder.messages.agent.DistributionCacheCheckpointMessage;
import net.grinder.messages.agent.RefreshCacheMessage;
import net.grinder.util.Directory;
import net.grinder.util.FileContents;
import net.grinder.util.StreamCopier;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;

final class FileStore {
    private final Logger m_logger;
    private final File m_readmeFile;
    private final Directory m_incomingDirectory;
    private final Directory m_currentDirectory;
    private boolean m_incremental;
    private volatile CacheHighWaterMark m_cacheHighWaterMark = new OutOfDateCacheHighWaterMark();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileStore(File directory, Logger logger) throws FileStoreException {
        File rootDirectory = directory.getAbsoluteFile();
        this.m_logger = logger;
        if (rootDirectory.exists()) {
            if (!rootDirectory.isDirectory()) {
                throw new FileStoreException("Could not write to directory '" + rootDirectory + "' as file with that name already exists");
            }
            if (!rootDirectory.canWrite()) {
                throw new FileStoreException("Could not write to directory '" + rootDirectory + "'");
            }
        }
        this.m_readmeFile = new File(rootDirectory, "README.txt");
        try {
            this.m_incomingDirectory = new Directory(new File(rootDirectory, "incoming"));
            this.m_currentDirectory = new Directory(new File(rootDirectory, "current"));
            Directory directory2 = this.m_incomingDirectory;
            synchronized (directory2) {
                this.m_incomingDirectory.create();
            }
        }
        catch (Directory.DirectoryException e) {
            throw new FileStoreException(e.getMessage(), e);
        }
        this.m_incremental = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Directory getDirectory() throws FileStoreException {
        try {
            Directory directory = this.m_incomingDirectory;
            synchronized (directory) {
                if (this.m_incomingDirectory.getFile().exists()) {
                    this.m_incomingDirectory.copyTo(this.m_currentDirectory, this.m_incremental);
                }
                this.m_incremental = true;
            }
            return this.m_currentDirectory;
        }
        catch (IOException e) {
            UncheckedInterruptedException.ioException((IOException)e);
            throw new FileStoreException("Could not create file store directory", e);
        }
    }

    public CacheHighWaterMark getCacheHighWaterMark() {
        return this.m_cacheHighWaterMark;
    }

    public Directory getIncomingDirectory() {
        return this.m_incomingDirectory;
    }

    public void registerMessageHandlers(MessageDispatchRegistry messageDispatcher) {
        messageDispatcher.set(RefreshCacheMessage.class, (MessageDispatchRegistry.Handler)new MessageDispatchRegistry.AbstractHandler<RefreshCacheMessage>(){

            public void handle(RefreshCacheMessage message) {
                FileStore.this.m_logger.info("Refresh cached file store");
                Set<String> requiredFilesDigest = message.getDisFilesDigest();
                File cacheDir = FileStore.this.m_incomingDirectory.getFile();
                try {
                    List<File> cachedFiles = net.grinder.util.FileUtils.getAllFilesInDirectory(cacheDir);
                    cachedFiles.stream().filter(file -> !requiredFilesDigest.contains(net.grinder.util.FileUtils.getFileDigest(cacheDir, file))).forEach(FileUtils::deleteQuietly);
                }
                catch (IOException e) {
                    FileStore.this.m_logger.info("Failed refresh cached file store", (Throwable)e);
                }
            }
        });
        messageDispatcher.set(ClearCacheMessage.class, (MessageDispatchRegistry.Handler)new MessageDispatchRegistry.AbstractHandler<ClearCacheMessage>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(ClearCacheMessage message) throws CommunicationException {
                FileStore.this.m_logger.info("Clearing file store");
                try {
                    Directory directory = FileStore.this.m_incomingDirectory;
                    synchronized (directory) {
                        FileStore.this.m_incomingDirectory.deleteContents();
                        FileStore.this.m_incremental = false;
                    }
                }
                catch (Directory.DirectoryException e) {
                    FileStore.this.m_logger.error(e.getMessage());
                    throw new CommunicationException(e.getMessage(), (Throwable)e);
                }
            }
        });
        messageDispatcher.set(DistributeFileMessage.class, (MessageDispatchRegistry.Handler)new MessageDispatchRegistry.AbstractHandler<DistributeFileMessage>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(DistributeFileMessage message) throws CommunicationException {
                try {
                    Directory directory = FileStore.this.m_incomingDirectory;
                    synchronized (directory) {
                        FileStore.this.m_incomingDirectory.create();
                        FileStore.this.createReadmeFile();
                        FileContents fileContents = message.getFileContents();
                        FileStore.this.m_logger.info("Updating file store: {}", (Object)fileContents);
                        fileContents.create(FileStore.this.m_incomingDirectory);
                    }
                }
                catch (Directory.DirectoryException | FileContents.FileContentsException e) {
                    FileStore.this.m_logger.error(e.getMessage());
                    throw new CommunicationException(e.getMessage(), e);
                }
            }
        });
        messageDispatcher.set(DistributionCacheCheckpointMessage.class, (MessageDispatchRegistry.Handler)new MessageDispatchRegistry.AbstractHandler<DistributionCacheCheckpointMessage>(){

            public void handle(DistributionCacheCheckpointMessage message) {
                FileStore.this.m_cacheHighWaterMark = message.getCacheHighWaterMark();
            }
        });
    }

    private void createReadmeFile() throws CommunicationException {
        if (!this.m_readmeFile.exists()) {
            try {
                new StreamCopier(4096, true).copy(this.getClass().getResourceAsStream("resources/FileStoreReadme.txt"), (OutputStream)new FileOutputStream(this.m_readmeFile));
            }
            catch (IOException e) {
                UncheckedInterruptedException.ioException((IOException)e);
                this.m_logger.error(e.getMessage());
                throw new CommunicationException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private static final class OutOfDateCacheHighWaterMark
    implements CacheHighWaterMark {
        private static final long serialVersionUID = 1L;

        private OutOfDateCacheHighWaterMark() {
        }

        public long getTime() {
            return -1L;
        }

        public boolean isForSameCache(CacheHighWaterMark other) {
            return false;
        }
    }

    public static final class FileStoreException
    extends EngineException {
        FileStoreException(String message) {
            super(message);
        }

        FileStoreException(String message, Throwable e) {
            super(message, e);
        }
    }
}

