/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.engine.console;

import net.grinder.console.common.ErrorHandler;
import org.slf4j.Logger;

public final class ErrorHandlerImplementation
implements ErrorHandler {
    private final Logger m_logger;

    public ErrorHandlerImplementation(Logger logger) {
        this.m_logger = logger;
    }

    public void handleErrorMessage(String errorMessage) {
        this.m_logger.error(errorMessage);
    }

    public void handleErrorMessage(String errorMessage, String title) {
        this.m_logger.error("[" + title + "] " + errorMessage);
    }

    public void handleException(Throwable throwable) {
        this.m_logger.error(throwable.getMessage(), throwable);
    }

    public void handleException(Throwable throwable, String title) {
        this.m_logger.error(title, throwable);
    }

    public void handleInformationMessage(String informationMessage) {
        this.m_logger.info(informationMessage);
    }
}

