/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.lang;

import java.io.File;
import net.grinder.lang.AbstractLanguageHandler;
import net.grinder.lang.UnknownHandler;
import net.grinder.lang.groovy.GroovyHandler;
import net.grinder.lang.jython.JythonHandler;
import org.apache.commons.io.FilenameUtils;
import org.ngrinder.common.util.Preconditions;

public enum Lang {
    Groovy(new GroovyHandler()),
    Jython(new JythonHandler()),
    Unknown(new UnknownHandler());

    private final AbstractLanguageHandler handler;

    private Lang(AbstractLanguageHandler handler) {
        this.handler = Preconditions.checkNotNull(handler);
    }

    public static Lang getByFileName(File file) {
        return Lang.getByFileName(file.getPath());
    }

    public static Lang getByFileName(String fileName) {
        String extension = FilenameUtils.getExtension((String)fileName);
        for (Lang each : Lang.values()) {
            if (!each.getHandler().getExtension().equals(extension)) continue;
            return each;
        }
        return Unknown;
    }

    public AbstractLanguageHandler getHandler() {
        return this.handler;
    }
}

