/*
 * Decompiled with CFR 0.152.
 */
package org.ngrinder.common.util;

import org.apache.commons.io.FilenameUtils;

public abstract class PathUtils {
    public static String removePrependedSlash(String path) {
        if (path.startsWith("/")) {
            return path.substring(1);
        }
        return path;
    }

    public static String join(String path1, String path2) {
        path1 = PathUtils.trimPathSeparatorBothSides(path1);
        path2 = PathUtils.trimPathSeparatorBothSides(path2);
        return FilenameUtils.normalizeNoEndSeparator((String)(path1 + "/" + path2), (boolean)true);
    }

    public static String trimPathSeparatorBothSides(String path) {
        int st;
        int len = path.length();
        int off = 0;
        char[] val = path.toCharArray();
        for (st = 0; st < len && val[off + st] == '/'; ++st) {
        }
        while (st < len && val[off + len - 1] == '/') {
            --len;
        }
        return st > 0 || len < path.length() ? path.substring(st, len) : path;
    }

    public static String removeDuplicatedPrependedSlash(String path) {
        if (path.startsWith("//")) {
            return path.substring(1);
        }
        return path;
    }

    public static String getSubPath(String basePath, String path) {
        if (!path.contains(basePath)) {
            return path;
        }
        return path.substring(path.lastIndexOf(basePath) + basePath.length());
    }
}

