/*
 * Decompiled with CFR 0.152.
 */
package org.ngrinder.infra;

import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.grinder.util.NetworkUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.ngrinder.common.constants.AgentConstants;
import org.ngrinder.common.constants.CommonConstants;
import org.ngrinder.common.constants.MonitorConstants;
import org.ngrinder.common.util.ExceptionUtils;
import org.ngrinder.common.util.NoOp;
import org.ngrinder.common.util.Preconditions;
import org.ngrinder.common.util.PropertiesKeyMapper;
import org.ngrinder.common.util.PropertiesWrapper;
import org.ngrinder.infra.AgentHome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentConfig
implements AgentConstants,
MonitorConstants,
CommonConstants {
    private static final String NGRINDER_DEFAULT_FOLDER = ".ngrinder_agent";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"agent config");
    protected AgentHome home = null;
    private PropertiesWrapper agentProperties;
    private PropertiesWrapper monitorProperties;
    private PropertiesWrapper commonProperties;
    private PropertiesWrapper internalProperties;
    private String controllerIP;
    private final PropertiesKeyMapper internalPropertyMapper = PropertiesKeyMapper.create("internal-properties.map");
    private final PropertiesKeyMapper agentPropertyMapper = PropertiesKeyMapper.create("agent-properties.map");
    private final PropertiesKeyMapper monitorPropertyMapper = PropertiesKeyMapper.create("monitor-properties.map");
    private final PropertiesKeyMapper commonPropertyMapper = PropertiesKeyMapper.create("common-properties.map");

    public AgentConfig init() {
        this.home = this.resolveHome();
        this.copyDefaultConfigurationFiles();
        this.loadProperties();
        this.loadInternalProperties();
        this.configureLogging();
        return this;
    }

    private void copyDefaultConfigurationFiles() {
        Preconditions.checkNotNull(this.home);
        File agentConfig = this.home.getFile("agent.conf");
        File newAgentConfig = new File(this.getCurrentDirectory(), "__agent.conf");
        if (newAgentConfig.exists()) {
            LOGGER.info("Overwrite the existing agent.conf with __agent.conf");
            this.home.copyFileTo(newAgentConfig, "agent.conf");
            agentConfig.setLastModified(newAgentConfig.lastModified());
            FileUtils.deleteQuietly((File)newAgentConfig);
            return;
        }
        if (agentConfig.exists()) {
            return;
        }
        try {
            this.home.writeFileTo(this.loadResource("/agent.conf"), "agent.conf");
        }
        catch (IOException e) {
            throw ExceptionUtils.processException(e);
        }
    }

    protected void loadProperties() {
        Preconditions.checkNotNull(this.home);
        Properties properties = this.home.getProperties("agent.conf");
        properties.put("NGRINDER_AGENT_HOME", this.home.getDirectory().getAbsolutePath());
        properties.putAll((Map<?, ?>)System.getProperties());
        this.agentProperties = new PropertiesWrapper(properties, this.agentPropertyMapper);
        this.monitorProperties = new PropertiesWrapper(properties, this.monitorPropertyMapper);
        this.commonProperties = new PropertiesWrapper(properties, this.commonPropertyMapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadInternalProperties() {
        InputStream inputStream = null;
        Properties properties = new Properties();
        try {
            inputStream = AgentConfig.class.getResourceAsStream("/internal.properties");
            properties.load(inputStream);
            this.internalProperties = new PropertiesWrapper(properties, this.internalPropertyMapper);
        }
        catch (IOException e) {
            LOGGER.error("Error while load internal.properties", (Throwable)e);
            this.internalProperties = new PropertiesWrapper(properties, this.internalPropertyMapper);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String loadResource(String name) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = AgentConfig.class.getResourceAsStream(name);
            if (inputStream != null) {
                String string = IOUtils.toString((InputStream)inputStream);
                return string;
            }
            String string = "";
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    private void configureLogging() {
        File logDirectory = this.getHome().getLogDirectory();
        String level = "INFO";
        if (this.getCommonProperties().getPropertyBoolean("common.verbose")) {
            level = "TRACE";
        }
        if (this.isSilentMode()) {
            level = "ERROR";
        }
        Context context = (Context)LoggerFactory.getILoggerFactory();
        JoranConfigurator configurator = new JoranConfigurator();
        configurator.setContext(context);
        context.putProperty("LOG_LEVEL", level);
        context.putProperty("LOG_DIRECTORY", logDirectory.getAbsolutePath());
        try {
            configurator.doConfigure(this.getClass().getResource("/logback-agent.xml"));
        }
        catch (JoranException e) {
            LOGGER.error("Error while configuring logger", (Throwable)e);
        }
    }

    public void saveAgentPidProperties(String agentPid, String startMode) {
        Preconditions.checkNotNull(this.home);
        Properties properties = this.home.getProperties("pid");
        if ("agent".equalsIgnoreCase(startMode)) {
            properties.put("agent.pid", agentPid);
        } else {
            properties.put("monitor.pid", agentPid);
        }
        this.home.saveProperties("pid", properties);
    }

    public void updateAgentPidProperties(String startMode) {
        Preconditions.checkNotNull(this.home);
        Properties properties = this.home.getProperties("pid");
        Set<String> names = properties.stringPropertyNames();
        if (names.size() > 1) {
            properties.remove(startMode + ".pid");
            this.home.saveProperties("pid", properties);
        } else if (names.contains(startMode + ".pid")) {
            this.removeAgentPidProperties();
        }
    }

    public String getAgentPidProperties(String startMode) {
        Preconditions.checkNotNull(this.home);
        Properties properties = this.home.getProperties("pid");
        if ("agent".equalsIgnoreCase(startMode)) {
            return (String)properties.get("agent.pid");
        }
        return (String)properties.get("monitor.pid");
    }

    public void removeAgentPidProperties() {
        Preconditions.checkNotNull(this.home);
        File file = this.home.getFile("pid");
        FileUtils.deleteQuietly((File)file);
    }

    protected AgentHome resolveHome() {
        String userHome;
        String userHomeFromEnv = StringUtils.trimToEmpty((String)System.getenv("NGRINDER_AGENT_HOME"));
        String userHomeFromProperty = StringUtils.trimToEmpty((String)System.getProperty("ngrinder.agent.home"));
        if (StringUtils.isNotEmpty((String)userHomeFromEnv) && !StringUtils.equals((String)userHomeFromEnv, (String)userHomeFromProperty)) {
            this.printLog("The path to ngrinder agent home is ambiguous:", new Object[0]);
            this.printLog("    '{}' is accepted.", userHomeFromProperty);
        }
        if (StringUtils.isEmpty((String)(userHome = StringUtils.defaultIfEmpty((String)userHomeFromProperty, (String)userHomeFromEnv)))) {
            userHome = System.getProperty("user.home") + File.separator + NGRINDER_DEFAULT_FOLDER;
        } else if (StringUtils.startsWith((String)userHome, (String)("~" + File.separator))) {
            userHome = System.getProperty("user.home") + File.separator + userHome.substring(2);
        } else if (StringUtils.startsWith((String)userHome, (String)("." + File.separator))) {
            userHome = System.getProperty("user.dir") + File.separator + userHome.substring(2);
        }
        userHome = FilenameUtils.normalize((String)userHome);
        this.printLog("NGRINDER_AGENT_HOME : {}", userHome);
        File homeDirectory = new File(userHome);
        try {
            if (homeDirectory.mkdirs()) {
                NoOp.noOp();
            }
            if (!homeDirectory.canWrite()) {
                throw ExceptionUtils.processException("home directory " + userHome + " is not writable.");
            }
        }
        catch (Exception e) {
            throw ExceptionUtils.processException("Error while resolve the home directory.", e);
        }
        return new AgentHome(homeDirectory);
    }

    private void printLog(String template, Object ... var) {
        if (!this.isSilentMode()) {
            LOGGER.info(template, var);
        }
    }

    public boolean isDevMode() {
        return this.getCommonProperties().getPropertyBoolean("common.dev_mode");
    }

    public AgentHome getHome() {
        return this.home;
    }

    public PropertiesWrapper getAgentProperties() {
        return Preconditions.checkNotNull(this.agentProperties);
    }

    public PropertiesWrapper getMonitorProperties() {
        return Preconditions.checkNotNull(this.monitorProperties);
    }

    public PropertiesWrapper getInternalProperties() {
        return this.internalProperties;
    }

    public File getCurrentDirectory() {
        return new File(System.getProperty("user.dir"));
    }

    public String getMonitorBindingIP() {
        return this.getMonitorProperties().getProperty("monitor.binding_ip");
    }

    public String getControllerHost() {
        return this.getAgentProperties().getProperty("agent.controller_host", NetworkUtils.getLocalHostAddress());
    }

    public void setControllerIP(String ip) {
        this.controllerIP = ip;
    }

    public String getControllerIP() {
        return StringUtils.defaultIfEmpty((String)this.controllerIP, (String)NetworkUtils.getLocalHostAddress());
    }

    public int getControllerPort() {
        return this.getAgentProperties().getPropertyInt("agent.controller_port");
    }

    public int getConnectionAgentPort() {
        return this.getAgentProperties().getPropertyInt("agent.connection_port");
    }

    public String getRegion() {
        return StringUtils.defaultIfEmpty((String)this.getAgentProperties().getProperty("agent.region"), (String)"");
    }

    public String getSubregion() {
        return StringUtils.defaultIfEmpty((String)this.getAgentProperties().getProperty("agent.subregion"), (String)"");
    }

    public String getOwner() {
        return StringUtils.defaultIfEmpty((String)this.getAgentProperties().getProperty("agent.owner"), (String)"");
    }

    public String getAgentHostID() {
        return this.getAgentProperties().getProperty("agent.host_id", NetworkUtils.getLocalHostName());
    }

    public boolean isSecurityEnabled() {
        return this.getAgentProperties().getPropertyBoolean("agent.enable_security");
    }

    public boolean isServerMode() {
        return this.getAgentProperties().getPropertyBoolean("agent.server_mode");
    }

    public boolean isConnectionMode() {
        String connectionMode = this.getAgentProperties().getProperty("agent.connection_mode", "agent_to_controller");
        return "controller_to_agent".equals(connectionMode);
    }

    public String getBroadcastIP() {
        return this.getAgentProperties().getProperty("agent.broadcast_ip", NetworkUtils.getLocalHostAddress());
    }

    public boolean isSilentMode() {
        PropertiesWrapper properties = this.getCommonProperties();
        if (properties == null) {
            return Boolean.getBoolean(System.getProperty("common.silent_mode", "false"));
        }
        return properties.getPropertyBoolean("common.silent_mode");
    }

    public PropertiesWrapper getCommonProperties() {
        return this.commonProperties;
    }

    public static class NullAgentConfig
    extends AgentConfig {
        public int counter;
        private int controllerPort = 0;

        public NullAgentConfig(int i) {
            this.counter = i;
            this.home = this.resolveHome();
            this.loadProperties();
            this.loadInternalProperties();
        }

        @Override
        public int getControllerPort() {
            return this.controllerPort == 0 ? super.getControllerPort() : this.controllerPort;
        }

        public void setControllerPort(int controllerPort) {
            this.controllerPort = controllerPort;
        }

        @Override
        public boolean isSilentMode() {
            return true;
        }

        @Override
        protected AgentHome resolveHome() {
            AgentHome resolveHome = super.resolveHome();
            File directory = new File(resolveHome.getDirectory(), "tmp_" + this.counter);
            resolveHome = new AgentHome(directory);
            try {
                FileUtils.forceDeleteOnExit((File)directory);
            }
            catch (IOException e) {
                NoOp.noOp();
            }
            return resolveHome;
        }
    }
}

