/*
 * Decompiled with CFR 0.152.
 */
package org.ngrinder.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import org.ngrinder.model.Permission;

@JsonFormat(shape=JsonFormat.Shape.OBJECT)
public enum Role {
    USER("U", "General User"){}
    ,
    ADMIN("A", "Administrator"){

        @Override
        public boolean hasPermission(Permission type) {
            switch (type) {
                case GET_ALL_TESTS: 
                case DELETE_TEST_OF_OTHER: 
                case CHECK_SCRIPT_OF_OTHER: 
                case VALIDATE_SCRIPT_OF_OTHER: 
                case STOP_TEST_OF_OTHER: 
                case SWITCH_TO_ANYONE: {
                    return true;
                }
            }
            return false;
        }
    }
    ,
    SUPER_USER("S", "Super User"){

        @Override
        public boolean hasPermission(Permission type) {
            switch (type) {
                case GET_ALL_TESTS: 
                case CHECK_SCRIPT_OF_OTHER: 
                case VALIDATE_SCRIPT_OF_OTHER: 
                case SWITCH_TO_ANYONE: {
                    return true;
                }
            }
            return false;
        }
    }
    ,
    SYSTEM_USER("SYSTEM", "System User"){};

    private final String shortName;
    private final String fullName;

    private Role(String shortName, String fullName) {
        this.shortName = shortName;
        this.fullName = fullName;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public boolean hasPermission(Permission type) {
        return false;
    }

    public String getName() {
        return this.name();
    }
}

