/*
 * Decompiled with CFR 0.152.
 */
package org.ngrinder.monitor.collector;

import java.util.Collection;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.ngrinder.common.constants.MonitorConstants;
import org.ngrinder.infra.AgentConfig;
import org.ngrinder.monitor.agent.MXBeanStorage;
import org.ngrinder.monitor.collector.DataCollector;
import org.ngrinder.monitor.mxbean.core.MXBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataCollectManager
implements MonitorConstants {
    private static final Logger LOG = LoggerFactory.getLogger(DataCollectManager.class);
    private boolean isRunning = false;
    private ScheduledExecutorService scheduler;
    private static final DataCollectManager INSTANCE = new DataCollectManager();
    private AgentConfig agentConfig;

    private DataCollectManager() {
    }

    public static DataCollectManager getInstance() {
        return INSTANCE;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public int getInterval() {
        return 1;
    }

    public void init(AgentConfig agentConfig) {
        this.agentConfig = agentConfig;
    }

    public void start() {
        int collectorCount = MXBeanStorage.getInstance().getSize();
        this.scheduler = Executors.newScheduledThreadPool(collectorCount);
        if (!this.isRunning()) {
            Collection<MXBean> mxBeans = MXBeanStorage.getInstance().getMXBeans();
            for (MXBean mxBean : mxBeans) {
                DataCollector collector = mxBean.gainDataCollector(this.agentConfig.getHome().getDirectory());
                this.scheduler.scheduleWithFixedDelay(collector, 0L, this.getInterval(), TimeUnit.SECONDS);
                LOG.info("{} started.", (Object)collector.getClass().getSimpleName());
            }
            LOG.info("Collection interval : {}s).", (Object)this.getInterval());
            this.isRunning = true;
        }
    }

    public void stop() {
        if (this.isRunning()) {
            this.scheduler.shutdown();
            this.isRunning = false;
            LOG.info("Collector shutdown");
        }
    }
}

