/*
 * Decompiled with CFR 0.152.
 */
package org.ngrinder.monitor.controller.model;

import org.ngrinder.model.BaseEntity;
import org.ngrinder.monitor.share.domain.BandWidth;
import org.ngrinder.monitor.share.domain.SystemInfo;

public class SystemDataModel
extends BaseEntity<SystemDataModel> {
    private static final long serialVersionUID = 790334226137464982L;
    private String key;
    private String ip;
    private int port;
    private String system;
    private long collectTime;
    private long freeMemory;
    private long totalMemory;
    private float cpuUsedPercentage;
    private long receivedPerSec;
    private long sentPerSec;
    private String version;
    private String customValues;

    public SystemDataModel() {
    }

    public SystemDataModel(SystemInfo systemInfo) {
        this(systemInfo, null);
    }

    public SystemDataModel(SystemInfo systemInfo, String version) {
        this.system = String.valueOf((Object)systemInfo.getSystem());
        this.collectTime = systemInfo.getCollectTime();
        this.freeMemory = systemInfo.getFreeMemory();
        this.totalMemory = systemInfo.getTotalMemory();
        this.cpuUsedPercentage = systemInfo.getCpuUsedPercentage();
        BandWidth bandWidth = systemInfo.getBandWidth();
        if (bandWidth != null) {
            this.receivedPerSec = bandWidth.getReceivedPerSec();
            this.sentPerSec = bandWidth.getSentPerSec();
        }
        this.customValues = systemInfo.getCustomValues();
        this.version = version;
    }

    public String getKey() {
        return this.key;
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public String getSystem() {
        return this.system;
    }

    public long getCollectTime() {
        return this.collectTime;
    }

    public long getFreeMemory() {
        return this.freeMemory;
    }

    public long getTotalMemory() {
        return this.totalMemory;
    }

    public float getCpuUsedPercentage() {
        return this.cpuUsedPercentage;
    }

    public long getReceivedPerSec() {
        return this.receivedPerSec;
    }

    public long getSentPerSec() {
        return this.sentPerSec;
    }

    public String getVersion() {
        return this.version;
    }

    public String getCustomValues() {
        return this.customValues;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setSystem(String system) {
        this.system = system;
    }

    public void setCollectTime(long collectTime) {
        this.collectTime = collectTime;
    }

    public void setFreeMemory(long freeMemory) {
        this.freeMemory = freeMemory;
    }

    public void setTotalMemory(long totalMemory) {
        this.totalMemory = totalMemory;
    }

    public void setCpuUsedPercentage(float cpuUsedPercentage) {
        this.cpuUsedPercentage = cpuUsedPercentage;
    }

    public void setReceivedPerSec(long receivedPerSec) {
        this.receivedPerSec = receivedPerSec;
    }

    public void setSentPerSec(long sentPerSec) {
        this.sentPerSec = sentPerSec;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setCustomValues(String customValues) {
        this.customValues = customValues;
    }
}

