/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.shade.com.joestelmach.natty;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ocpsoft.prettytime.shade.com.joestelmach.natty.ANTLRNoCaseInputStream;
import org.ocpsoft.prettytime.shade.com.joestelmach.natty.DateGroup;
import org.ocpsoft.prettytime.shade.com.joestelmach.natty.NattyTokenSource;
import org.ocpsoft.prettytime.shade.com.joestelmach.natty.ParseListener;
import org.ocpsoft.prettytime.shade.com.joestelmach.natty.ParseLocation;
import org.ocpsoft.prettytime.shade.com.joestelmach.natty.generated.DateLexer;
import org.ocpsoft.prettytime.shade.com.joestelmach.natty.generated.DateParser;
import org.ocpsoft.prettytime.shade.com.joestelmach.natty.generated.DateWalker;
import org.ocpsoft.prettytime.shade.com.joestelmach.natty.generated.TreeRewrite;
import org.ocpsoft.prettytime.shade.org.antlr.runtime.CommonTokenStream;
import org.ocpsoft.prettytime.shade.org.antlr.runtime.Token;
import org.ocpsoft.prettytime.shade.org.antlr.runtime.TokenStream;
import org.ocpsoft.prettytime.shade.org.antlr.runtime.tree.CommonTree;
import org.ocpsoft.prettytime.shade.org.antlr.runtime.tree.CommonTreeNodeStream;
import org.ocpsoft.prettytime.shade.org.antlr.runtime.tree.Tree;

public class Parser {
    private TimeZone _defaultTimeZone;
    private static final Logger _logger = Logger.getLogger("org.ocpsoft.prettytime.shade.com.joestelmach.natty");

    public Parser(TimeZone defaultTimeZone) {
        this._defaultTimeZone = defaultTimeZone;
    }

    public Parser() {
        this._defaultTimeZone = TimeZone.getDefault();
    }

    public List<DateGroup> parse(String value) {
        ANTLRNoCaseInputStream input = null;
        try {
            input = new ANTLRNoCaseInputStream(new ByteArrayInputStream(value.trim().getBytes()));
        }
        catch (IOException e) {
            _logger.log(Level.SEVERE, "could not lex input", e);
        }
        DateLexer lexer = new DateLexer(input);
        List<TokenStream> streams = this.collectTokenStreams(new CommonTokenStream(lexer));
        ArrayList<DateGroup> groups = new ArrayList<DateGroup>();
        for (TokenStream stream : streams) {
            List<Token> tokens = ((NattyTokenSource)stream.getTokenSource()).getTokens();
            DateGroup group = this.singleParse(stream);
            while ((group == null || group.getDates().size() == 0) && tokens.size() > 0) {
                Token token;
                if (group != null && group.getDates().size() != 0) continue;
                if (tokens.size() <= 2) {
                    tokens.clear();
                    continue;
                }
                List<Token> endRemovedTokens = new ArrayList<Token>(tokens);
                while ((group == null || group.getDates().isEmpty()) && endRemovedTokens.size() > 2) {
                    endRemovedTokens = endRemovedTokens.subList(0, endRemovedTokens.size() - 1);
                    this.cleanupGroup(endRemovedTokens);
                    CommonTokenStream newStream = new CommonTokenStream(new NattyTokenSource(endRemovedTokens));
                    group = this.singleParse(newStream);
                }
                if (group != null && !group.getDates().isEmpty()) continue;
                tokens = tokens.subList(1, tokens.size());
                Iterator<Token> iter = tokens.iterator();
                while (iter.hasNext() && !DateParser.FOLLOW_empty_in_parse186.member((token = iter.next()).getType())) {
                    iter.remove();
                }
                this.cleanupGroup(tokens);
                CommonTokenStream newStream = new CommonTokenStream(new NattyTokenSource(tokens));
                group = this.singleParse(newStream);
            }
            if (group == null || group.getDates().size() <= 0) continue;
            groups.add(group);
        }
        return groups;
    }

    private DateGroup singleParse(TokenStream stream) {
        DateGroup group = null;
        List<Token> tokens = ((NattyTokenSource)stream.getTokenSource()).getTokens();
        if (tokens.isEmpty()) {
            return group;
        }
        StringBuilder tokenString = new StringBuilder();
        for (Token token : tokens) {
            tokenString.append(DateParser.tokenNames[token.getType()]);
            tokenString.append(" ");
        }
        _logger.fine("sub-token stream: " + tokenString.toString());
        try {
            ParseListener listener = new ParseListener();
            DateParser parser = new DateParser(stream, listener);
            DateParser.parse_return parseReturn = parser.parse();
            Tree tree = (Tree)parseReturn.getTree();
            _logger.fine("AST: " + tree.toStringTree());
            if (tree.getChildCount() > 0) {
                CommonTreeNodeStream nodes = new CommonTreeNodeStream(tree);
                TreeRewrite s = new TreeRewrite(nodes);
                tree = (CommonTree)s.downup(tree);
                nodes = new CommonTreeNodeStream(tree);
                nodes.setTokenStream(stream);
                DateWalker walker = new DateWalker(nodes);
                walker.getState().setDefaultTimeZone(this._defaultTimeZone);
                walker.parse();
                group = walker.getState().getDateGroup();
                ParseLocation location = listener.getDateGroupLocation();
                group.setLine(location.getLine());
                group.setText(location.getText());
                group.setPosition(location.getStart());
                group.setSyntaxTree(tree);
                group.setParseLocations(listener.getLocations());
            }
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "Could not parse input", e);
        }
        return group;
    }

    private List<TokenStream> collectTokenStreams(TokenStream stream) {
        Token currentToken;
        ArrayList<Token> currentGroup = null;
        ArrayList<TokenStream> groups = new ArrayList<TokenStream>();
        StringBuilder tokenString = new StringBuilder();
        while ((currentToken = stream.getTokenSource().nextToken()).getType() != -1) {
            if (_logger.getLevel() != null && _logger.getLevel().intValue() <= Level.FINE.intValue()) {
                tokenString.append(DateParser.tokenNames[currentToken.getType()]);
                tokenString.append(" ");
            }
            if (currentGroup == null) {
                if (currentToken.getType() == 278 || !DateParser.FOLLOW_empty_in_parse186.member(currentToken.getType()) && currentToken.getType() != 269) continue;
                currentGroup = new ArrayList<Token>();
                currentGroup.add(currentToken);
                continue;
            }
            if (currentToken.getType() == 278) {
                currentGroup.add(currentToken);
                continue;
            }
            if (currentToken.getType() == 269) {
                if (currentGroup.size() > 0) {
                    currentGroup.add(currentToken);
                    this.cleanupGroup(currentGroup);
                    groups.add(new CommonTokenStream(new NattyTokenSource(currentGroup)));
                }
                currentGroup = null;
                continue;
            }
            if (currentToken.getType() == 28) continue;
            currentGroup.add(currentToken);
        }
        if (currentGroup != null) {
            this.cleanupGroup(currentGroup);
            groups.add(new CommonTokenStream(new NattyTokenSource((List<Token>)currentGroup)));
        }
        _logger.fine("global token stream: " + tokenString.toString());
        return groups;
    }

    private void cleanupGroup(List<Token> group) {
        Iterator<Token> iter = group.iterator();
        Token previousToken = null;
        while (iter.hasNext()) {
            Token token = iter.next();
            if (previousToken != null && previousToken.getType() == 278 && token.getType() == 278) {
                iter.remove();
            }
            previousToken = token;
        }
        if (group.size() > 0) {
            boolean skip = false;
            Iterator<Token> it1 = group.iterator();
            while (it1.hasNext()) {
                Token tk = it1.next();
                if (tk.getType() == 278) {
                    it1.remove();
                    skip = false;
                    continue;
                }
                if (tk.getType() == 269) {
                    it1.remove();
                    skip = true;
                    continue;
                }
                if (skip) {
                    it1.remove();
                    continue;
                }
                if (DateParser.FOLLOW_empty_in_parse186.member(tk.getType())) break;
                it1.remove();
            }
        }
        if (group.size() > 0) {
            boolean skip = false;
            while (group.size() > 0) {
                Token lastToken = group.get(group.size() - 1);
                if (lastToken.getType() == 278) {
                    group.remove(lastToken);
                    skip = false;
                    continue;
                }
                if (lastToken.getType() == 269) {
                    group.remove(lastToken);
                    skip = true;
                    continue;
                }
                if (!skip) break;
                group.remove(lastToken);
            }
        }
    }
}

