/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.elasticsearch;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.Dashboard;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.service.Entity;
import org.openmetadata.service.elasticsearch.ElasticSearchIndex;
import org.openmetadata.service.elasticsearch.ElasticSearchIndexUtils;
import org.openmetadata.service.elasticsearch.ElasticSearchSuggest;
import org.openmetadata.service.elasticsearch.ParseTags;
import org.openmetadata.service.util.JsonUtils;

public class DashboardIndex
implements ElasticSearchIndex {
    final Dashboard dashboard;
    final List<String> excludeFields = List.of("changeDescription");

    public DashboardIndex(Dashboard dashboard) {
        this.dashboard = dashboard;
    }

    @Override
    public Map<String, Object> buildESDoc() {
        Map<String, Object> doc = JsonUtils.getMap(this.dashboard);
        ElasticSearchIndexUtils.removeNonIndexableFields(doc, this.excludeFields);
        ArrayList<ElasticSearchSuggest> suggest = new ArrayList<ElasticSearchSuggest>();
        ArrayList<ElasticSearchSuggest> serviceSuggest = new ArrayList<ElasticSearchSuggest>();
        ArrayList<ElasticSearchSuggest> chartSuggest = new ArrayList<ElasticSearchSuggest>();
        ArrayList<ElasticSearchSuggest> dataModelSuggest = new ArrayList<ElasticSearchSuggest>();
        suggest.add(ElasticSearchSuggest.builder().input(this.dashboard.getFullyQualifiedName()).weight(5).build());
        suggest.add(ElasticSearchSuggest.builder().input(this.dashboard.getDisplayName()).weight(10).build());
        serviceSuggest.add(ElasticSearchSuggest.builder().input(this.dashboard.getService().getName()).weight(5).build());
        ParseTags parseTags = new ParseTags(Entity.getEntityTags("dashboard", (EntityInterface)this.dashboard));
        for (EntityReference chart : CommonUtil.listOrEmpty((List)this.dashboard.getCharts())) {
            chartSuggest.add(ElasticSearchSuggest.builder().input(chart.getDisplayName()).weight(5).build());
        }
        for (EntityReference chart : CommonUtil.listOrEmpty((List)this.dashboard.getDataModels())) {
            dataModelSuggest.add(ElasticSearchSuggest.builder().input(chart.getDisplayName()).weight(5).build());
        }
        doc.put("name", this.dashboard.getDisplayName());
        doc.put("displayName", this.dashboard.getDisplayName() != null ? this.dashboard.getDisplayName() : this.dashboard.getName());
        doc.put("tags", parseTags.tags);
        doc.put("followers", ElasticSearchIndexUtils.parseFollowers(this.dashboard.getFollowers()));
        doc.put("tier", parseTags.tierTag);
        doc.put("suggest", suggest);
        doc.put("chart_suggest", chartSuggest);
        doc.put("data_model_suggest", dataModelSuggest);
        doc.put("service_suggest", serviceSuggest);
        doc.put("entityType", "dashboard");
        doc.put("serviceType", this.dashboard.getServiceType());
        return doc;
    }
}

