/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.events.subscription.emailAlert;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.alert.type.EmailAlertConfig;
import org.openmetadata.schema.api.events.CreateEventSubscription;
import org.openmetadata.schema.entity.events.EventSubscription;
import org.openmetadata.schema.entity.teams.Team;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.service.Entity;
import org.openmetadata.service.events.errors.EventPublisherException;
import org.openmetadata.service.events.subscription.SubscriptionPublisher;
import org.openmetadata.service.events.subscription.emailAlert.EmailMessage;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.jdbi3.UserRepository;
import org.openmetadata.service.resources.events.EventResource;
import org.openmetadata.service.security.policyevaluator.SubjectCache;
import org.openmetadata.service.util.ChangeEventParser;
import org.openmetadata.service.util.EmailUtil;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.ResultList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailPublisher
extends SubscriptionPublisher {
    private static final Logger LOG = LoggerFactory.getLogger(EmailPublisher.class);
    private final EmailAlertConfig emailAlertConfig;
    private final CollectionDAO daoCollection;

    public EmailPublisher(EventSubscription eventSub, CollectionDAO dao) {
        super(eventSub, dao);
        if (eventSub.getSubscriptionType() != CreateEventSubscription.SubscriptionType.EMAIL) {
            throw new IllegalArgumentException("Email Alert Invoked with Illegal Type and Settings.");
        }
        this.emailAlertConfig = JsonUtils.convertValue(eventSub.getSubscriptionConfig(), EmailAlertConfig.class);
        this.daoCollection = dao;
    }

    @Override
    public void onStartDelegate() {
        LOG.info("Email Publisher Started");
    }

    @Override
    public void onShutdownDelegate() {
        LOG.info("Email Publisher Stopped");
    }

    @Override
    public void sendAlert(EventResource.EventList list) throws InterruptedException {
        for (ChangeEvent event : list.getData()) {
            try {
                Set<String> receivers = this.buildReceiversList(event);
                EmailMessage emailMessage = ChangeEventParser.buildEmailMessage(event);
                for (String email : receivers) {
                    EmailUtil.sendChangeEventMail(email, emailMessage);
                }
                this.setSuccessStatus(System.currentTimeMillis());
            }
            catch (Exception e) {
                this.setErrorStatus(System.currentTimeMillis(), 500, e.getMessage());
                throw new EventPublisherException(String.format("Failed to publish event %s to email due to %s ", event, e.getMessage()));
            }
        }
    }

    private Set<String> sendToAdmins() {
        HashSet<String> emailList = new HashSet<String>();
        UserRepository userEntityRepository = (UserRepository)Entity.getEntityRepository("user");
        ListFilter listFilter = new ListFilter(Include.ALL);
        listFilter.addQueryParam("isAdmin", "true");
        String after = null;
        try {
            ResultList result;
            do {
                result = userEntityRepository.listAfter(null, userEntityRepository.getFields("email"), listFilter, 50, after);
                result.getData().forEach(user -> emailList.add(user.getEmail()));
            } while ((after = result.getPaging().getAfter()) != null);
        }
        catch (Exception ex) {
            LOG.error("Failed in listing all Users , Reason", (Throwable)ex);
        }
        return emailList;
    }

    private Set<String> sendToOwners(ChangeEvent changeEvent) {
        return this.findOwnerOrFollowers(changeEvent, Relationship.OWNS);
    }

    private Set<String> sendToFollowers(ChangeEvent changeEvent) {
        return this.findOwnerOrFollowers(changeEvent, Relationship.FOLLOWS);
    }

    private Set<String> findOwnerOrFollowers(ChangeEvent changeEvent, Relationship relationship) {
        HashSet<String> emailList = new HashSet<String>();
        try {
            EntityInterface entityInterface = (EntityInterface)changeEvent.getEntity();
            List<CollectionDAO.EntityRelationshipRecord> ownerOrFollowers = this.daoCollection.relationshipDAO().findFrom(entityInterface.getId().toString(), changeEvent.getEntityType(), relationship.ordinal());
            ownerOrFollowers.forEach(owner -> {
                if ("user".equals(owner.getType())) {
                    User user = SubjectCache.getInstance().getSubjectContext(owner.getId()).getUser();
                    emailList.add(user.getEmail());
                } else if ("team".equals(owner.getType())) {
                    Team team = SubjectCache.getInstance().getTeam(owner.getId());
                    List<CollectionDAO.EntityRelationshipRecord> records = this.daoCollection.relationshipDAO().findTo(team.getId().toString(), "team", Relationship.HAS.ordinal(), "user");
                    records.forEach(userRecord -> {
                        User user = SubjectCache.getInstance().getSubjectContext(userRecord.getId()).getUser();
                        emailList.add(user.getEmail());
                    });
                }
            });
        }
        catch (Exception ex) {
            LOG.error("Failed in listing all Admin User, Reason : ", (Throwable)ex);
        }
        return emailList;
    }

    private Set<String> buildReceiversList(ChangeEvent changeEvent) {
        Set<String> receiverList;
        Set set = receiverList = this.emailAlertConfig.getReceivers() == null ? new HashSet() : this.emailAlertConfig.getReceivers();
        if (this.emailAlertConfig.getSendToAdmins().booleanValue()) {
            receiverList.addAll(this.sendToAdmins());
        }
        if (this.emailAlertConfig.getSendToOwners().booleanValue()) {
            receiverList.addAll(this.sendToOwners(changeEvent));
        }
        if (this.emailAlertConfig.getSendToFollowers().booleanValue()) {
            receiverList.addAll(this.sendToFollowers(changeEvent));
        }
        return receiverList;
    }
}

