/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.Pipeline;
import org.openmetadata.schema.entity.data.PipelineStatus;
import org.openmetadata.schema.entity.services.PipelineService;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.schema.type.Status;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.schema.type.Task;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.ResultList;

public class PipelineRepository
extends EntityRepository<Pipeline> {
    private static final String PIPELINE_UPDATE_FIELDS = "owner,tags,tasks,extension,followers";
    private static final String PIPELINE_PATCH_FIELDS = "owner,tags,tasks,extension,followers";
    public static final String PIPELINE_STATUS_EXTENSION = "pipeline.pipelineStatus";

    public PipelineRepository(CollectionDAO dao) {
        super("v1/pipelines/", "pipeline", Pipeline.class, dao.pipelineDAO(), dao, "owner,tags,tasks,extension,followers", "owner,tags,tasks,extension,followers");
    }

    @Override
    public void setFullyQualifiedName(Pipeline pipeline) {
        pipeline.setFullyQualifiedName(FullyQualifiedName.add(pipeline.getService().getName(), pipeline.getName()));
        this.setTaskFQN(pipeline.getFullyQualifiedName(), pipeline.getTasks());
    }

    @Override
    public Pipeline setFields(Pipeline pipeline, EntityUtil.Fields fields) throws IOException {
        pipeline.setService(this.getContainer(pipeline.getId()));
        pipeline.setFollowers(fields.contains("followers") ? this.getFollowers(pipeline) : null);
        this.getTaskTags(fields.contains("tags"), pipeline.getTasks());
        if (!fields.contains("tasks")) {
            pipeline.withTasks(null);
        }
        return pipeline.withPipelineStatus(fields.contains("pipelineStatus") ? this.getPipelineStatus(pipeline) : null);
    }

    private PipelineStatus getPipelineStatus(Pipeline pipeline) throws IOException {
        return JsonUtils.readValue(this.daoCollection.entityExtensionTimeSeriesDao().getLatestExtension(pipeline.getFullyQualifiedName(), PIPELINE_STATUS_EXTENSION), PipelineStatus.class);
    }

    @Transaction
    public Pipeline addPipelineStatus(String fqn, PipelineStatus pipelineStatus) throws IOException {
        Pipeline pipeline = (Pipeline)this.daoCollection.pipelineDAO().findEntityByName(fqn);
        pipeline.setService(this.getContainer(pipeline.getId()));
        for (Status taskStatus : pipelineStatus.getTaskStatus()) {
            this.validateTask(pipeline, taskStatus.getName());
        }
        PipelineStatus storedPipelineStatus = JsonUtils.readValue(this.daoCollection.entityExtensionTimeSeriesDao().getExtensionAtTimestamp(fqn, PIPELINE_STATUS_EXTENSION, pipelineStatus.getTimestamp()), PipelineStatus.class);
        if (storedPipelineStatus != null) {
            this.daoCollection.entityExtensionTimeSeriesDao().update(pipeline.getFullyQualifiedName(), PIPELINE_STATUS_EXTENSION, JsonUtils.pojoToJson(pipelineStatus), pipelineStatus.getTimestamp());
        } else {
            this.daoCollection.entityExtensionTimeSeriesDao().insert(pipeline.getFullyQualifiedName(), PIPELINE_STATUS_EXTENSION, "pipelineStatus", JsonUtils.pojoToJson(pipelineStatus));
        }
        return pipeline.withPipelineStatus(pipelineStatus);
    }

    @Transaction
    public Pipeline deletePipelineStatus(String fqn, Long timestamp) throws IOException {
        Pipeline pipeline = (Pipeline)this.dao.findEntityByName(fqn);
        pipeline.setService(this.getContainer(pipeline.getId()));
        PipelineStatus storedPipelineStatus = JsonUtils.readValue(this.daoCollection.entityExtensionTimeSeriesDao().getExtensionAtTimestamp(fqn, PIPELINE_STATUS_EXTENSION, timestamp), PipelineStatus.class);
        if (storedPipelineStatus != null) {
            this.daoCollection.entityExtensionTimeSeriesDao().deleteAtTimestamp(fqn, PIPELINE_STATUS_EXTENSION, timestamp);
            pipeline.setPipelineStatus(storedPipelineStatus);
            return pipeline;
        }
        throw new EntityNotFoundException(String.format("Failed to find pipeline status for %s at %s", pipeline.getName(), timestamp));
    }

    public ResultList<PipelineStatus> getPipelineStatuses(String fqn, Long starTs, Long endTs) throws IOException {
        List<PipelineStatus> pipelineStatuses = JsonUtils.readObjects(this.daoCollection.entityExtensionTimeSeriesDao().listBetweenTimestamps(fqn, PIPELINE_STATUS_EXTENSION, starTs, endTs), PipelineStatus.class);
        return new ResultList<PipelineStatus>(pipelineStatuses, starTs.toString(), endTs.toString(), pipelineStatuses.size());
    }

    private void validateTask(Pipeline pipeline, String taskName) {
        boolean validTask = pipeline.getTasks().stream().anyMatch(task -> task.getName().equals(taskName));
        if (!validTask) {
            throw new IllegalArgumentException("Invalid task name " + taskName);
        }
    }

    @Override
    public void restorePatchAttributes(Pipeline original, Pipeline updated) {
        updated.withFullyQualifiedName(original.getFullyQualifiedName()).withName(original.getName()).withService(original.getService()).withId(original.getId());
    }

    @Override
    public void prepare(Pipeline pipeline) throws IOException {
        this.populateService(pipeline);
    }

    @Override
    public void storeEntity(Pipeline pipeline, boolean update) throws IOException {
        EntityReference service = pipeline.getService();
        pipeline.withService(null);
        List taskWithTags = pipeline.getTasks();
        pipeline.setTasks(PipelineRepository.cloneWithoutTags(taskWithTags));
        this.store(pipeline, update);
        pipeline.withService(service).withTasks(taskWithTags);
    }

    @Override
    public void storeRelationships(Pipeline pipeline) {
        EntityReference service = pipeline.getService();
        this.addRelationship(service.getId(), pipeline.getId(), service.getType(), "pipeline", Relationship.CONTAINS);
        this.storeOwner(pipeline, pipeline.getOwner());
        this.applyTags(pipeline);
    }

    @Override
    public void applyTags(Pipeline pipeline) {
        super.applyTags(pipeline);
        this.applyTags(pipeline.getTasks());
    }

    @Override
    private void applyTags(List<Task> tasks) {
        if (tasks != null) {
            for (Task task : tasks) {
                this.applyTags(task.getTags(), task.getFullyQualifiedName());
            }
        }
    }

    private void getTaskTags(boolean setTags, List<Task> tasks) {
        for (Task t : CommonUtil.listOrEmpty(tasks)) {
            t.setTags(setTags ? this.getTags(t.getFullyQualifiedName()) : null);
        }
    }

    private void setTaskFQN(String parentFQN, List<Task> tasks) {
        if (tasks != null) {
            tasks.forEach(t -> {
                String taskFqn = FullyQualifiedName.add(parentFQN, t.getName());
                t.setFullyQualifiedName(taskFqn);
            });
        }
    }

    @Override
    public EntityRepository.EntityUpdater getUpdater(Pipeline original, Pipeline updated, EntityRepository.Operation operation) {
        return new PipelineUpdater(original, updated, operation);
    }

    @Override
    public List<TagLabel> getAllTags(EntityInterface entity) {
        ArrayList<TagLabel> allTags = new ArrayList<TagLabel>();
        Pipeline pipeline = (Pipeline)entity;
        EntityUtil.mergeTags(allTags, pipeline.getTags());
        for (Task task : CommonUtil.listOrEmpty((List)pipeline.getTasks())) {
            EntityUtil.mergeTags(allTags, task.getTags());
        }
        return allTags;
    }

    private void populateService(Pipeline pipeline) throws IOException {
        PipelineService service = (PipelineService)Entity.getEntity(pipeline.getService(), "", Include.NON_DELETED);
        pipeline.setService(service.getEntityReference());
        pipeline.setServiceType(service.getServiceType());
    }

    private static List<Task> cloneWithoutTags(List<Task> tasks) {
        if (CommonUtil.nullOrEmpty(tasks)) {
            return tasks;
        }
        ArrayList<Task> copy = new ArrayList<Task>();
        tasks.forEach(t -> copy.add(t.withTags(null)));
        return copy;
    }

    public class PipelineUpdater
    extends EntityRepository.EntityUpdater {
        public PipelineUpdater(Pipeline original, Pipeline updated, EntityRepository.Operation operation) {
            super((EntityRepository)PipelineRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        public void entitySpecificUpdate() throws IOException {
            this.updateTasks((Pipeline)this.original, (Pipeline)this.updated);
            this.recordChange("pipelineUrl", ((Pipeline)this.original).getPipelineUrl(), ((Pipeline)this.updated).getPipelineUrl());
            this.recordChange("concurrency", ((Pipeline)this.original).getConcurrency(), ((Pipeline)this.updated).getConcurrency());
            this.recordChange("pipelineLocation", ((Pipeline)this.original).getPipelineLocation(), ((Pipeline)this.updated).getPipelineLocation());
        }

        private void updateTasks(Pipeline original, Pipeline updated) throws JsonProcessingException {
            boolean removedTasks;
            List updatedTasks = CommonUtil.listOrEmpty((List)updated.getTasks());
            List origTasks = CommonUtil.listOrEmpty((List)original.getTasks());
            boolean newTasks = false;
            for (Task updatedTask : updatedTasks) {
                Task stored = origTasks.stream().filter(c -> EntityUtil.taskMatch.test((Task)c, updatedTask)).findAny().orElse(null);
                if (stored == null || updatedTask == null) {
                    newTasks = true;
                    continue;
                }
                this.updateTaskDescription(stored, updatedTask);
            }
            PipelineRepository.this.applyTags(updatedTasks);
            boolean bl = removedTasks = updatedTasks.size() < origTasks.size();
            if (newTasks || removedTasks) {
                ArrayList added = new ArrayList();
                ArrayList deleted = new ArrayList();
                this.recordListChange("tasks", origTasks, updatedTasks, added, deleted, EntityUtil.taskMatch);
            }
        }

        private void updateTaskDescription(Task origTask, Task updatedTask) throws JsonProcessingException {
            if (this.operation.isPut() && !CommonUtil.nullOrEmpty((String)origTask.getDescription()) && this.updatedByBot()) {
                updatedTask.setDescription(origTask.getDescription());
                return;
            }
            if (origTask != null && (origTask.getDescription() != null && !origTask.getDescription().equals(updatedTask.getDescription()) || updatedTask.getDescription() != null)) {
                this.recordChange("tasks." + origTask.getName() + ".description", origTask.getDescription(), updatedTask.getDescription());
            }
        }
    }
}

