/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.Streams;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.api.data.CreateTableProfile;
import org.openmetadata.schema.entity.data.DatabaseSchema;
import org.openmetadata.schema.entity.data.Table;
import org.openmetadata.schema.tests.CustomMetric;
import org.openmetadata.schema.type.Column;
import org.openmetadata.schema.type.ColumnJoin;
import org.openmetadata.schema.type.ColumnProfile;
import org.openmetadata.schema.type.ColumnProfilerConfig;
import org.openmetadata.schema.type.DailyCount;
import org.openmetadata.schema.type.DataModel;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.JoinedWith;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.schema.type.SystemProfile;
import org.openmetadata.schema.type.TableConstraint;
import org.openmetadata.schema.type.TableData;
import org.openmetadata.schema.type.TableJoins;
import org.openmetadata.schema.type.TableProfile;
import org.openmetadata.schema.type.TableProfilerConfig;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.ColumnUtil;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.resources.databases.DatabaseUtil;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.LambdaExceptionUtil;
import org.openmetadata.service.util.RestUtil;
import org.openmetadata.service.util.ResultList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableRepository
extends EntityRepository<Table> {
    private static final Logger LOG = LoggerFactory.getLogger(TableRepository.class);
    static final String TABLE_PATCH_FIELDS = "owner,tags,tableConstraints,tablePartition,extension,followers";
    static final String TABLE_UPDATE_FIELDS = "owner,tags,tableConstraints,tablePartition,dataModel,extension,followers";
    public static final String FIELD_RELATION_COLUMN_TYPE = "table.columns.column";
    public static final String FIELD_RELATION_TABLE_TYPE = "table";
    public static final String TABLE_PROFILE_EXTENSION = "table.tableProfile";
    public static final String SYSTEM_PROFILE_EXTENSION = "table.systemProfile";
    public static final String TABLE_COLUMN_PROFILE_EXTENSION = "table.columnProfile";
    public static final String TABLE_SAMPLE_DATA_EXTENSION = "table.sampleData";
    public static final String TABLE_PROFILER_CONFIG_EXTENSION = "table.tableProfilerConfig";
    public static final String TABLE_COLUMN_EXTENSION = "table.column.";
    public static final String CUSTOM_METRICS_EXTENSION = ".customMetrics";

    public TableRepository(CollectionDAO daoCollection) {
        super("v1/tables/", FIELD_RELATION_TABLE_TYPE, Table.class, daoCollection.tableDAO(), daoCollection, TABLE_PATCH_FIELDS, TABLE_UPDATE_FIELDS);
    }

    @Override
    public Table setFields(Table table, EntityUtil.Fields fields) throws IOException {
        this.setDefaultFields(table);
        table.setTableConstraints(fields.contains("tableConstraints") ? table.getTableConstraints() : null);
        table.setFollowers(fields.contains("followers") ? this.getFollowers(table) : null);
        table.setUsageSummary(fields.contains("usageSummary") ? EntityUtil.getLatestUsage(this.daoCollection.usageDAO(), table.getId()) : null);
        this.getColumnTags(fields.contains("tags"), table.getColumns());
        table.setJoins(fields.contains("joins") ? this.getJoins(table) : null);
        table.setViewDefinition(fields.contains("viewDefinition") ? table.getViewDefinition() : null);
        table.setTableProfilerConfig(fields.contains("tableProfilerConfig") ? this.getTableProfilerConfig(table) : null);
        this.getCustomMetrics(fields.contains("customMetrics"), table);
        return table;
    }

    private void setDefaultFields(Table table) throws IOException {
        EntityReference schemaRef = this.getContainer(table.getId());
        DatabaseSchema schema = (DatabaseSchema)Entity.getEntity(schemaRef, "", Include.ALL);
        table.withDatabaseSchema(schemaRef).withDatabase(schema.getDatabase()).withService(schema.getService());
    }

    @Override
    public void restorePatchAttributes(Table original, Table updated) {
        updated.withFullyQualifiedName(original.getFullyQualifiedName()).withName(original.getName()).withDatabase(original.getDatabase()).withService(original.getService()).withId(original.getId());
    }

    @Override
    public void setFullyQualifiedName(Table table) {
        table.setFullyQualifiedName(FullyQualifiedName.add(table.getDatabaseSchema().getFullyQualifiedName(), table.getName()));
        ColumnUtil.setColumnFQN(table.getFullyQualifiedName(), table.getColumns());
    }

    @Transaction
    public Table addJoins(UUID tableId, TableJoins joins) throws IOException {
        Table table = (Table)this.dao.findEntityById(tableId);
        if (!CommonUtil.dateInRange((DateFormat)RestUtil.DATE_FORMAT, (String)joins.getStartDate(), (int)0, (int)30)) {
            throw new IllegalArgumentException("Date range can only include past 30 days starting today");
        }
        for (ColumnJoin join : joins.getColumnJoins()) {
            TableRepository.validateColumn(table, join.getColumnName());
            this.validateColumnFQNs(join.getJoinedWith());
        }
        for (ColumnJoin join : joins.getDirectTableJoins()) {
            this.validateTableFQN(join.getFullyQualifiedName());
        }
        for (ColumnJoin join : joins.getColumnJoins()) {
            String columnFQN = FullyQualifiedName.add(table.getFullyQualifiedName(), join.getColumnName());
            this.addJoinedWith(joins.getStartDate(), columnFQN, FIELD_RELATION_COLUMN_TYPE, join.getJoinedWith());
        }
        this.addJoinedWith(joins.getStartDate(), table.getFullyQualifiedName(), FIELD_RELATION_TABLE_TYPE, joins.getDirectTableJoins());
        return table.withJoins(this.getJoins(table));
    }

    @Transaction
    public Table addSampleData(UUID tableId, TableData tableData) throws IOException {
        Table table = (Table)this.dao.findEntityById(tableId);
        for (String columnName : tableData.getColumns()) {
            TableRepository.validateColumn(table, columnName);
        }
        for (List row : tableData.getRows()) {
            if (row.size() == tableData.getColumns().size()) continue;
            throw new IllegalArgumentException(String.format("Number of columns is %d but row has %d sample values", tableData.getColumns().size(), row.size()));
        }
        this.daoCollection.entityExtensionDAO().insert(tableId.toString(), TABLE_SAMPLE_DATA_EXTENSION, "tableData", JsonUtils.pojoToJson(tableData));
        this.setFieldsInternal(table, EntityUtil.Fields.EMPTY_FIELDS);
        return table.withSampleData(tableData);
    }

    @Transaction
    public Table getSampleData(UUID tableId) throws IOException {
        Table table = (Table)this.dao.findEntityById(tableId);
        TableData sampleData = JsonUtils.readValue(this.daoCollection.entityExtensionDAO().getExtension(table.getId().toString(), TABLE_SAMPLE_DATA_EXTENSION), TableData.class);
        table.setSampleData(sampleData);
        this.setFieldsInternal(table, EntityUtil.Fields.EMPTY_FIELDS);
        return table;
    }

    @Transaction
    public Table deleteSampleData(UUID tableId) throws IOException {
        Table table = (Table)this.dao.findEntityById(tableId);
        this.daoCollection.entityExtensionDAO().delete(tableId.toString(), TABLE_SAMPLE_DATA_EXTENSION);
        this.setFieldsInternal(table, EntityUtil.Fields.EMPTY_FIELDS);
        return table;
    }

    @Transaction
    public TableProfilerConfig getTableProfilerConfig(Table table) throws IOException {
        return JsonUtils.readValue(this.daoCollection.entityExtensionDAO().getExtension(table.getId().toString(), TABLE_PROFILER_CONFIG_EXTENSION), TableProfilerConfig.class);
    }

    @Transaction
    public Table addTableProfilerConfig(UUID tableId, TableProfilerConfig tableProfilerConfig) throws IOException {
        Table table = (Table)this.dao.findEntityById(tableId);
        if (tableProfilerConfig.getExcludeColumns() != null) {
            for (String columnName : tableProfilerConfig.getExcludeColumns()) {
                TableRepository.validateColumn(table, columnName);
            }
        }
        if (tableProfilerConfig.getIncludeColumns() != null) {
            for (ColumnProfilerConfig columnProfilerConfig : tableProfilerConfig.getIncludeColumns()) {
                TableRepository.validateColumn(table, columnProfilerConfig.getColumnName());
            }
        }
        if (tableProfilerConfig.getProfileSampleType() != null && tableProfilerConfig.getProfileSample() != null) {
            EntityUtil.validateProfileSample(tableProfilerConfig.getProfileSampleType().toString(), tableProfilerConfig.getProfileSample());
        }
        this.daoCollection.entityExtensionDAO().insert(tableId.toString(), TABLE_PROFILER_CONFIG_EXTENSION, "tableProfilerConfig", JsonUtils.pojoToJson(tableProfilerConfig));
        this.setFieldsInternal(table, EntityUtil.Fields.EMPTY_FIELDS);
        return table.withTableProfilerConfig(tableProfilerConfig);
    }

    @Transaction
    public Table deleteTableProfilerConfig(UUID tableId) throws IOException {
        Table table = (Table)this.dao.findEntityById(tableId);
        this.daoCollection.entityExtensionDAO().delete(tableId.toString(), TABLE_PROFILER_CONFIG_EXTENSION);
        this.setFieldsInternal(table, EntityUtil.Fields.EMPTY_FIELDS);
        return table;
    }

    private Column getColumnNameForProfiler(List<Column> columnList, ColumnProfile columnProfile, String parentName) {
        for (Column col : columnList) {
            Column childColumn;
            String columnName = parentName != null ? String.format("%s.%s", parentName, col.getName()) : col.getName();
            if (columnName.equals(columnProfile.getName())) {
                return col;
            }
            if (col.getChildren() == null || (childColumn = this.getColumnNameForProfiler(col.getChildren(), columnProfile, columnName)) == null) continue;
            return childColumn;
        }
        return null;
    }

    @Transaction
    public Table addTableProfileData(UUID tableId, CreateTableProfile createTableProfile) throws IOException {
        Table table = (Table)this.dao.findEntityById(tableId);
        TableProfile storedTableProfile = JsonUtils.readValue(this.daoCollection.entityExtensionTimeSeriesDao().getExtensionAtTimestamp(table.getFullyQualifiedName(), TABLE_PROFILE_EXTENSION, createTableProfile.getTableProfile().getTimestamp()), TableProfile.class);
        if (storedTableProfile != null) {
            this.daoCollection.entityExtensionTimeSeriesDao().update(table.getFullyQualifiedName(), TABLE_PROFILE_EXTENSION, JsonUtils.pojoToJson(createTableProfile.getTableProfile()), createTableProfile.getTableProfile().getTimestamp());
        } else {
            this.daoCollection.entityExtensionTimeSeriesDao().insert(table.getFullyQualifiedName(), TABLE_PROFILE_EXTENSION, "tableProfile", JsonUtils.pojoToJson(createTableProfile.getTableProfile()));
        }
        for (ColumnProfile columnProfile : createTableProfile.getColumnProfile()) {
            Column column = this.getColumnNameForProfiler(table.getColumns(), columnProfile, null);
            if (column == null) {
                throw new IllegalArgumentException("Invalid column name " + columnProfile.getName());
            }
            ColumnProfile storedColumnProfile = JsonUtils.readValue(this.daoCollection.entityExtensionTimeSeriesDao().getExtensionAtTimestamp(column.getFullyQualifiedName(), TABLE_COLUMN_PROFILE_EXTENSION, columnProfile.getTimestamp()), ColumnProfile.class);
            if (storedColumnProfile != null) {
                this.daoCollection.entityExtensionTimeSeriesDao().update(column.getFullyQualifiedName(), TABLE_COLUMN_PROFILE_EXTENSION, JsonUtils.pojoToJson(columnProfile), storedColumnProfile.getTimestamp());
                continue;
            }
            this.daoCollection.entityExtensionTimeSeriesDao().insert(column.getFullyQualifiedName(), TABLE_COLUMN_PROFILE_EXTENSION, "columnProfile", JsonUtils.pojoToJson(columnProfile));
        }
        List systemProfiles = createTableProfile.getSystemProfile();
        if (systemProfiles != null && !systemProfiles.isEmpty()) {
            for (SystemProfile systemProfile : createTableProfile.getSystemProfile()) {
                SystemProfile storedSystemProfile = JsonUtils.readValue(this.daoCollection.entityExtensionTimeSeriesDao().getExtensionAtTimestamp(table.getFullyQualifiedName(), SYSTEM_PROFILE_EXTENSION, systemProfile.getTimestamp()), SystemProfile.class);
                if (storedSystemProfile != null) {
                    this.daoCollection.entityExtensionTimeSeriesDao().update(table.getFullyQualifiedName(), SYSTEM_PROFILE_EXTENSION, JsonUtils.pojoToJson(systemProfile), storedSystemProfile.getTimestamp());
                    continue;
                }
                this.daoCollection.entityExtensionTimeSeriesDao().insert(table.getFullyQualifiedName(), SYSTEM_PROFILE_EXTENSION, "systemProfile", JsonUtils.pojoToJson(systemProfile));
            }
        }
        this.setFieldsInternal(table, EntityUtil.Fields.EMPTY_FIELDS);
        return table.withProfile(createTableProfile.getTableProfile());
    }

    @Transaction
    public void deleteTableProfile(String fqn, String entityType, Long timestamp) throws IOException {
        String extension;
        if (entityType.equalsIgnoreCase(FIELD_RELATION_TABLE_TYPE)) {
            extension = TABLE_PROFILE_EXTENSION;
        } else if (entityType.equalsIgnoreCase("column")) {
            extension = TABLE_COLUMN_PROFILE_EXTENSION;
        } else {
            throw new IllegalArgumentException("entityType must be table or column");
        }
        TableProfile storedTableProfile = JsonUtils.readValue(this.daoCollection.entityExtensionTimeSeriesDao().getExtensionAtTimestamp(fqn, extension, timestamp), TableProfile.class);
        if (storedTableProfile == null) {
            throw new EntityNotFoundException(String.format("Failed to find table profile for %s at %s", fqn, timestamp));
        }
        this.daoCollection.entityExtensionTimeSeriesDao().deleteAtTimestamp(fqn, extension, timestamp);
    }

    @Transaction
    public ResultList<TableProfile> getTableProfiles(String fqn, Long startTs, Long endTs) throws IOException {
        List<TableProfile> tableProfiles = JsonUtils.readObjects(this.daoCollection.entityExtensionTimeSeriesDao().listBetweenTimestamps(fqn, TABLE_PROFILE_EXTENSION, startTs, endTs), TableProfile.class);
        return new ResultList<TableProfile>(tableProfiles, startTs.toString(), endTs.toString(), tableProfiles.size());
    }

    @Transaction
    public ResultList<ColumnProfile> getColumnProfiles(String fqn, Long startTs, Long endTs) throws IOException {
        List<ColumnProfile> columnProfiles = JsonUtils.readObjects(this.daoCollection.entityExtensionTimeSeriesDao().listBetweenTimestamps(fqn, TABLE_COLUMN_PROFILE_EXTENSION, startTs, endTs), ColumnProfile.class);
        return new ResultList<ColumnProfile>(columnProfiles, startTs.toString(), endTs.toString(), columnProfiles.size());
    }

    @Transaction
    public ResultList<SystemProfile> getSystemProfiles(String fqn, Long startTs, Long endTs) throws IOException {
        List<SystemProfile> systemProfiles = JsonUtils.readObjects(this.daoCollection.entityExtensionTimeSeriesDao().listBetweenTimestamps(fqn, SYSTEM_PROFILE_EXTENSION, startTs, endTs), SystemProfile.class);
        return new ResultList<SystemProfile>(systemProfiles, startTs.toString(), endTs.toString(), systemProfiles.size());
    }

    private void setColumnProfile(List<Column> columnList) throws IOException {
        for (Column column : columnList) {
            ColumnProfile columnProfile = JsonUtils.readValue(this.daoCollection.entityExtensionTimeSeriesDao().getLatestExtension(column.getFullyQualifiedName(), TABLE_COLUMN_PROFILE_EXTENSION), ColumnProfile.class);
            column.setProfile(columnProfile);
            if (column.getChildren() == null) continue;
            this.setColumnProfile(column.getChildren());
        }
    }

    @Transaction
    public Table getLatestTableProfile(String fqn) throws IOException {
        Table table = (Table)this.dao.findEntityByName(fqn);
        TableProfile tableProfile = JsonUtils.readValue(this.daoCollection.entityExtensionTimeSeriesDao().getLatestExtension(table.getFullyQualifiedName(), TABLE_PROFILE_EXTENSION), TableProfile.class);
        table.setProfile(tableProfile);
        this.setColumnProfile(table.getColumns());
        return table;
    }

    @Transaction
    public Table addCustomMetric(UUID tableId, CustomMetric customMetric) throws IOException {
        Table table = (Table)this.dao.findEntityById(tableId);
        String columnName = customMetric.getColumnName();
        TableRepository.validateColumn(table, columnName);
        List<CustomMetric> storedCustomMetrics = this.getCustomMetrics(table, columnName);
        HashMap<String, CustomMetric> storedMapCustomMetrics = new HashMap<String, CustomMetric>();
        if (storedCustomMetrics != null) {
            for (CustomMetric cm : storedCustomMetrics) {
                storedMapCustomMetrics.put(cm.getName(), cm);
            }
        }
        if (storedMapCustomMetrics.containsKey(customMetric.getName())) {
            CustomMetric prevMetric = (CustomMetric)storedMapCustomMetrics.get(customMetric.getName());
            customMetric.setId(prevMetric.getId());
        }
        storedMapCustomMetrics.put(customMetric.getName(), customMetric);
        ArrayList updatedMetrics = new ArrayList(storedMapCustomMetrics.values());
        String extension = TABLE_COLUMN_EXTENSION + columnName + CUSTOM_METRICS_EXTENSION;
        this.daoCollection.entityExtensionDAO().insert(table.getId().toString(), extension, "customMetric", JsonUtils.pojoToJson(updatedMetrics));
        this.setFieldsInternal(table, EntityUtil.Fields.EMPTY_FIELDS);
        for (Column column : table.getColumns()) {
            if (!column.getName().equals(columnName)) continue;
            column.setCustomMetrics(List.of(customMetric));
        }
        return table;
    }

    @Transaction
    public Table deleteCustomMetric(UUID tableId, String columnName, String metricName) throws IOException {
        Table table = (Table)this.dao.findEntityById(tableId);
        TableRepository.validateColumn(table, columnName);
        List<CustomMetric> storedCustomMetrics = this.getCustomMetrics(table, columnName);
        HashMap<String, CustomMetric> storedMapCustomMetrics = new HashMap<String, CustomMetric>();
        if (storedCustomMetrics != null) {
            for (CustomMetric cm : storedCustomMetrics) {
                storedMapCustomMetrics.put(cm.getName(), cm);
            }
        }
        if (!storedMapCustomMetrics.containsKey(metricName)) {
            throw new EntityNotFoundException(String.format("Failed to find %s for %s", metricName, table.getName()));
        }
        CustomMetric deleteCustomMetric = (CustomMetric)storedMapCustomMetrics.get(metricName);
        storedMapCustomMetrics.remove(metricName);
        ArrayList updatedMetrics = new ArrayList(storedMapCustomMetrics.values());
        String extension = TABLE_COLUMN_EXTENSION + columnName + CUSTOM_METRICS_EXTENSION;
        this.daoCollection.entityExtensionDAO().insert(table.getId().toString(), extension, "customMetric", JsonUtils.pojoToJson(updatedMetrics));
        for (Column column : table.getColumns()) {
            if (!column.getName().equals(columnName)) continue;
            column.setCustomMetrics(List.of(deleteCustomMetric));
        }
        return table;
    }

    @Transaction
    public Table addDataModel(UUID tableId, DataModel dataModel) throws IOException {
        Table table = (Table)this.dao.findEntityById(tableId);
        table.withDataModel(dataModel);
        if (table.getOwner() == null) {
            this.storeOwner(table, dataModel.getOwner());
        }
        table.setTags(dataModel.getTags());
        this.applyTags(table);
        for (Column modelColumn : CommonUtil.listOrEmpty((List)dataModel.getColumns())) {
            Column stored = table.getColumns().stream().filter(c -> EntityUtil.columnNameMatch.test((Column)c, modelColumn)).findAny().orElse(null);
            if (stored == null) continue;
            stored.setTags(modelColumn.getTags());
        }
        this.applyTags(table.getColumns());
        this.dao.update(table.getId(), JsonUtils.pojoToJson(table));
        this.setFieldsInternal(table, new EntityUtil.Fields(List.of("owner"), "owner"));
        this.setFieldsInternal(table, new EntityUtil.Fields(List.of("tags"), "tags"));
        return table;
    }

    private void addDerivedColumnTags(List<Column> columns) {
        if (CommonUtil.nullOrEmpty(columns)) {
            return;
        }
        for (Column column : columns) {
            column.setTags(this.addDerivedTags(column.getTags()));
            if (column.getChildren() == null) continue;
            this.addDerivedColumnTags(column.getChildren());
        }
    }

    @Override
    public void prepare(Table table) throws IOException {
        DatabaseSchema schema = (DatabaseSchema)Entity.getEntity(table.getDatabaseSchema(), "owner", Include.ALL);
        table.withDatabaseSchema(schema.getEntityReference()).withDatabase(schema.getDatabase()).withService(schema.getService()).withServiceType(schema.getServiceType());
        if (table.getOwner() == null && schema.getOwner() != null) {
            table.setOwner(schema.getOwner().withDescription("inherited"));
        }
        this.addDerivedColumnTags(table.getColumns());
        table.getColumns().forEach(column -> this.checkMutuallyExclusive(column.getTags()));
    }

    @Override
    public void storeEntity(Table table, boolean update) throws IOException {
        EntityReference service = table.getService();
        table.withService(null);
        List columnWithTags = table.getColumns();
        table.setColumns(ColumnUtil.cloneWithoutTags(columnWithTags));
        table.getColumns().forEach(column -> column.setTags(null));
        this.store(table, update);
        table.withColumns(columnWithTags).withService(service);
    }

    @Override
    public void storeRelationships(Table table) {
        this.addRelationship(table.getDatabaseSchema().getId(), table.getId(), "databaseSchema", FIELD_RELATION_TABLE_TYPE, Relationship.CONTAINS);
        this.storeOwner(table, table.getOwner());
        this.applyTags(table);
    }

    @Override
    public EntityRepository.EntityUpdater getUpdater(Table original, Table updated, EntityRepository.Operation operation) {
        return new TableUpdater(original, updated, operation);
    }

    @Override
    private void applyTags(List<Column> columns) {
        for (Column column : columns) {
            this.applyTags(column.getTags(), column.getFullyQualifiedName());
            if (column.getChildren() == null) continue;
            this.applyTags(column.getChildren());
        }
    }

    @Override
    public void applyTags(Table table) {
        super.applyTags(table);
        this.applyTags(table.getColumns());
    }

    @Override
    public List<TagLabel> getAllTags(EntityInterface entity) {
        ArrayList<TagLabel> allTags = new ArrayList<TagLabel>();
        Table table = (Table)entity;
        EntityUtil.mergeTags(allTags, table.getTags());
        table.getColumns().forEach(column -> EntityUtil.mergeTags(allTags, column.getTags()));
        if (table.getDataModel() != null) {
            EntityUtil.mergeTags(allTags, table.getDataModel().getTags());
            for (Column column2 : CommonUtil.listOrEmpty((List)table.getDataModel().getColumns())) {
                EntityUtil.mergeTags(allTags, column2.getTags());
            }
        }
        return allTags;
    }

    private void getColumnTags(boolean setTags, List<Column> columns) {
        for (Column c : CommonUtil.listOrEmpty(columns)) {
            c.setTags(setTags ? this.getTags(c.getFullyQualifiedName()) : null);
            this.getColumnTags(setTags, c.getChildren());
        }
    }

    private void validateTableFQN(String fqn) {
        try {
            this.dao.existsByName(fqn);
        }
        catch (EntityNotFoundException e) {
            throw new IllegalArgumentException("Invalid table name " + fqn, (Throwable)((Object)e));
        }
    }

    public static void validateColumn(Table table, String columnName) {
        boolean validColumn = table.getColumns().stream().anyMatch(col -> col.getName().equals(columnName));
        if (!validColumn) {
            throw new IllegalArgumentException("Invalid column name " + columnName);
        }
    }

    private void validateColumnFQNs(List<JoinedWith> joinedWithList) {
        for (JoinedWith joinedWith : joinedWithList) {
            String tableFQN = FullyQualifiedName.getTableFQN(joinedWith.getFullyQualifiedName());
            Table joinedWithTable = (Table)this.dao.findEntityByName(tableFQN);
            ColumnUtil.validateColumnFQN(joinedWithTable.getColumns(), joinedWith.getFullyQualifiedName());
        }
    }

    private void addJoinedWith(String date, String entityFQN, String entityRelationType, List<JoinedWith> joinedWithList) throws IOException {
        for (JoinedWith joinedWith : joinedWithList) {
            String toEntityFQN;
            String fromEntityFQN;
            if (entityFQN.compareTo(joinedWith.getFullyQualifiedName()) < 0) {
                fromEntityFQN = entityFQN;
                toEntityFQN = joinedWith.getFullyQualifiedName();
            } else {
                fromEntityFQN = joinedWith.getFullyQualifiedName();
                toEntityFQN = entityFQN;
            }
            List<DailyCount> currentDailyCounts = Optional.ofNullable(this.daoCollection.fieldRelationshipDAO().find(fromEntityFQN, toEntityFQN, entityRelationType, entityRelationType, Relationship.JOINED_WITH.ordinal())).map(LambdaExceptionUtil.rethrowFunction(j -> JsonUtils.readObjects(j, DailyCount.class))).orElse(List.of());
            DailyCount receivedDailyCount = new DailyCount().withCount(joinedWith.getJoinCount()).withDate(date);
            List<DailyCount> newDailyCounts = this.aggregateAndFilterDailyCounts(currentDailyCounts, receivedDailyCount);
            this.daoCollection.fieldRelationshipDAO().upsert(fromEntityFQN, toEntityFQN, entityRelationType, entityRelationType, Relationship.JOINED_WITH.ordinal(), "dailyCount", JsonUtils.pojoToJson(newDailyCounts));
        }
    }

    private List<DailyCount> aggregateAndFilterDailyCounts(List<DailyCount> currentDailyCounts, DailyCount newDailyCount) {
        Map<String, List<DailyCount>> joinCountByDay = Streams.concat((Stream[])new Stream[]{currentDailyCounts.stream(), Stream.of(newDailyCount)}).collect(Collectors.groupingBy(DailyCount::getDate));
        return joinCountByDay.entrySet().stream().map(e -> {
            if (((String)e.getKey()).equals(newDailyCount.getDate())) {
                return newDailyCount;
            }
            return new DailyCount().withDate((String)e.getKey()).withCount(((DailyCount)((List)e.getValue()).stream().findFirst().orElseThrow(() -> new IllegalStateException("Collector.groupingBy created an empty grouping"))).getCount());
        }).filter(this.inLast30Days()).sorted(LambdaExceptionUtil.ignoringComparator((dc1, dc2) -> RestUtil.compareDates(dc1.getDate(), dc2.getDate()))).collect(Collectors.toList());
    }

    private TableJoins getJoins(Table table) {
        String today = RestUtil.DATE_FORMAT.format(new Date());
        String todayMinus30Days = CommonUtil.getDateStringByOffset((DateFormat)RestUtil.DATE_FORMAT, (String)today, (int)-30);
        return new TableJoins().withStartDate(todayMinus30Days).withDayCount(Integer.valueOf(30)).withColumnJoins(this.getColumnJoins(table)).withDirectTableJoins(this.getDirectTableJoins(table));
    }

    private List<JoinedWith> getDirectTableJoins(Table table) {
        List entityRelations = this.daoCollection.fieldRelationshipDAO().listBidirectional(table.getFullyQualifiedName(), FIELD_RELATION_TABLE_TYPE, FIELD_RELATION_TABLE_TYPE, Relationship.JOINED_WITH.ordinal()).stream().map(LambdaExceptionUtil.rethrowFunction(er -> Pair.of((Object)((String)er.getMiddle()), JsonUtils.readObjects((String)er.getRight(), DailyCount.class)))).collect(Collectors.toUnmodifiableList());
        return entityRelations.stream().map(er -> new JoinedWith().withFullyQualifiedName((String)er.getLeft()).withJoinCount(Integer.valueOf(((List)er.getRight()).stream().filter(this.inLast30Days()).mapToInt(DailyCount::getCount).sum()))).collect(Collectors.toList());
    }

    private List<ColumnJoin> getColumnJoins(Table table) {
        List entityRelations = this.daoCollection.fieldRelationshipDAO().listBidirectionalByPrefix(table.getFullyQualifiedName(), FIELD_RELATION_COLUMN_TYPE, FIELD_RELATION_COLUMN_TYPE, Relationship.JOINED_WITH.ordinal()).stream().map(LambdaExceptionUtil.rethrowFunction(er -> Triple.of((Object)FullyQualifiedName.getColumnName((String)er.getLeft()), (Object)((String)er.getMiddle()), JsonUtils.readObjects((String)er.getRight(), DailyCount.class)))).collect(Collectors.toUnmodifiableList());
        return entityRelations.stream().collect(Collectors.groupingBy(Triple::getLeft)).entrySet().stream().map(e -> new ColumnJoin().withColumnName((String)e.getKey()).withJoinedWith(((List)e.getValue()).stream().map(er -> new JoinedWith().withFullyQualifiedName((String)er.getMiddle()).withJoinCount(Integer.valueOf(((List)er.getRight()).stream().filter(this.inLast30Days()).mapToInt(DailyCount::getCount).sum()))).collect(Collectors.toUnmodifiableList()))).collect(Collectors.toUnmodifiableList());
    }

    private Predicate<DailyCount> inLast30Days() {
        return dc -> CommonUtil.dateInRange((DateFormat)RestUtil.DATE_FORMAT, (String)dc.getDate(), (int)0, (int)30);
    }

    private List<CustomMetric> getCustomMetrics(Table table, String columnName) throws IOException {
        String extension = TABLE_COLUMN_EXTENSION + columnName + CUSTOM_METRICS_EXTENSION;
        return JsonUtils.readObjects(this.daoCollection.entityExtensionDAO().getExtension(table.getId().toString(), extension), CustomMetric.class);
    }

    private void getCustomMetrics(boolean setMetrics, Table table) throws IOException {
        List columns = table.getColumns();
        for (Column c : CommonUtil.listOrEmpty((List)columns)) {
            c.setCustomMetrics(setMetrics ? this.getCustomMetrics(table, c.getName()) : null);
        }
    }

    public class TableUpdater
    extends EntityRepository.ColumnEntityUpdater {
        public TableUpdater(Table original, Table updated, EntityRepository.Operation operation) {
            super((EntityRepository)TableRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        public void entitySpecificUpdate() throws IOException {
            Table origTable = (Table)this.original;
            Table updatedTable = (Table)this.updated;
            DatabaseUtil.validateColumns(updatedTable.getColumns());
            this.recordChange("tableType", origTable.getTableType(), updatedTable.getTableType());
            this.updateConstraints(origTable, updatedTable);
            this.updateColumns("columns", origTable.getColumns(), ((Table)this.updated).getColumns(), (BiPredicate)EntityUtil.columnMatch);
        }

        private void updateConstraints(Table origTable, Table updatedTable) throws JsonProcessingException {
            List origConstraints = CommonUtil.listOrEmpty((List)origTable.getTableConstraints());
            List updatedConstraints = CommonUtil.listOrEmpty((List)updatedTable.getTableConstraints());
            origConstraints.sort(EntityUtil.compareTableConstraint);
            origConstraints.stream().map(TableConstraint::getColumns).forEach(Collections::sort);
            updatedConstraints.sort(EntityUtil.compareTableConstraint);
            updatedConstraints.stream().map(TableConstraint::getColumns).forEach(Collections::sort);
            ArrayList added = new ArrayList();
            ArrayList deleted = new ArrayList();
            this.recordListChange("tableConstraints", origConstraints, updatedConstraints, added, deleted, EntityUtil.tableConstraintMatch);
        }
    }
}

