/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.Topic;
import org.openmetadata.schema.entity.services.MessagingService;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Field;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.schema.type.topic.TopicSampleData;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;
import org.openmetadata.service.util.JsonUtils;

public class TopicRepository
extends EntityRepository<Topic> {
    private static final String TOPIC_UPDATE_FIELDS = "owner,tags,extension,followers";
    private static final String TOPIC_PATCH_FIELDS = "owner,tags,extension,followers";

    @Override
    public void setFullyQualifiedName(Topic topic) {
        topic.setFullyQualifiedName(FullyQualifiedName.add(topic.getService().getName(), topic.getName()));
        if (topic.getMessageSchema() != null) {
            this.setFieldFQN(topic.getFullyQualifiedName(), topic.getMessageSchema().getSchemaFields());
        }
    }

    public TopicRepository(CollectionDAO dao) {
        super("v1/topics/", "topic", Topic.class, dao.topicDAO(), dao, "owner,tags,extension,followers", "owner,tags,extension,followers");
    }

    @Override
    public void prepare(Topic topic) throws IOException {
        MessagingService messagingService = (MessagingService)Entity.getEntity(topic.getService(), "", Include.ALL);
        topic.setService(messagingService.getEntityReference());
        topic.setServiceType(messagingService.getServiceType());
        if (topic.getMessageSchema() != null) {
            this.addDerivedFieldTags(topic.getMessageSchema().getSchemaFields());
            topic.getMessageSchema().getSchemaFields().forEach(field -> this.checkMutuallyExclusive(field.getTags()));
        }
    }

    @Override
    public void storeEntity(Topic topic, boolean update) throws IOException {
        EntityReference service = topic.getService();
        topic.withService(null);
        List fieldsWithTags = null;
        if (topic.getMessageSchema() != null) {
            fieldsWithTags = topic.getMessageSchema().getSchemaFields();
            topic.getMessageSchema().setSchemaFields(this.cloneWithoutTags(fieldsWithTags));
            topic.getMessageSchema().getSchemaFields().forEach(field -> field.setTags(null));
        }
        this.store(topic, update);
        if (fieldsWithTags != null) {
            topic.getMessageSchema().withSchemaFields(fieldsWithTags);
        }
        topic.withService(service);
    }

    @Override
    public void storeRelationships(Topic topic) {
        this.setService(topic, topic.getService());
        this.storeOwner(topic, topic.getOwner());
        this.applyTags(topic);
    }

    @Override
    public Topic setFields(Topic topic, EntityUtil.Fields fields) throws IOException {
        topic.setService(this.getContainer(topic.getId()));
        topic.setFollowers(fields.contains("followers") ? this.getFollowers(topic) : null);
        topic.setSampleData(fields.contains("sampleData") ? this.getSampleData(topic) : null);
        if (topic.getMessageSchema() != null) {
            this.getFieldTags(fields.contains("tags"), topic.getMessageSchema().getSchemaFields());
        }
        return topic;
    }

    public TopicUpdater getUpdater(Topic original, Topic updated, EntityRepository.Operation operation) {
        return new TopicUpdater(original, updated, operation);
    }

    public void setService(Topic topic, EntityReference service) {
        if (service != null && topic != null) {
            this.addRelationship(service.getId(), topic.getId(), service.getType(), "topic", Relationship.CONTAINS);
            topic.setService(service);
        }
    }

    private TopicSampleData getSampleData(Topic topic) throws IOException {
        return JsonUtils.readValue(this.daoCollection.entityExtensionDAO().getExtension(topic.getId().toString(), "topic.sampleData"), TopicSampleData.class);
    }

    @Transaction
    public Topic addSampleData(UUID topicId, TopicSampleData sampleData) throws IOException {
        Topic topic = (Topic)this.daoCollection.topicDAO().findEntityById(topicId);
        this.daoCollection.entityExtensionDAO().insert(topicId.toString(), "topic.sampleData", "topicSampleData", JsonUtils.pojoToJson(sampleData));
        this.setFieldsInternal(topic, EntityUtil.Fields.EMPTY_FIELDS);
        return topic.withSampleData(sampleData);
    }

    private void setFieldFQN(String parentFQN, List<Field> fields) {
        fields.forEach(c -> {
            String fieldFqn = FullyQualifiedName.add(parentFQN, c.getName());
            c.setFullyQualifiedName(fieldFqn);
            if (c.getChildren() != null) {
                this.setFieldFQN(fieldFqn, c.getChildren());
            }
        });
    }

    private void getFieldTags(boolean setTags, List<Field> fields) {
        for (Field f : CommonUtil.listOrEmpty(fields)) {
            f.setTags(setTags ? this.getTags(f.getFullyQualifiedName()) : null);
            this.getFieldTags(setTags, f.getChildren());
        }
    }

    private void addDerivedFieldTags(List<Field> fields) {
        if (CommonUtil.nullOrEmpty(fields)) {
            return;
        }
        for (Field field : fields) {
            field.setTags(this.addDerivedTags(field.getTags()));
            if (field.getChildren() == null) continue;
            this.addDerivedFieldTags(field.getChildren());
        }
    }

    List<Field> cloneWithoutTags(List<Field> fields) {
        if (CommonUtil.nullOrEmpty(fields)) {
            return fields;
        }
        ArrayList<Field> copy = new ArrayList<Field>();
        fields.forEach(f -> copy.add(this.cloneWithoutTags((Field)f)));
        return copy;
    }

    private Field cloneWithoutTags(Field field) {
        List<Field> children = this.cloneWithoutTags(field.getChildren());
        return new Field().withDescription(field.getDescription()).withName(field.getName()).withDisplayName(field.getDisplayName()).withFullyQualifiedName(field.getFullyQualifiedName()).withDataType(field.getDataType()).withDataTypeDisplay(field.getDataTypeDisplay()).withChildren(children);
    }

    @Override
    private void applyTags(List<Field> fields) {
        for (Field field : fields) {
            this.applyTags(field.getTags(), field.getFullyQualifiedName());
            if (field.getChildren() == null) continue;
            this.applyTags(field.getChildren());
        }
    }

    @Override
    public void applyTags(Topic topic) {
        super.applyTags(topic);
        if (topic.getMessageSchema() != null) {
            this.applyTags(topic.getMessageSchema().getSchemaFields());
        }
    }

    @Override
    public List<TagLabel> getAllTags(EntityInterface entity) {
        ArrayList<TagLabel> allTags = new ArrayList<TagLabel>();
        Topic topic = (Topic)entity;
        EntityUtil.mergeTags(allTags, topic.getTags());
        List schemaFields = topic.getMessageSchema() != null ? topic.getMessageSchema().getSchemaFields() : null;
        for (Field schemaField : CommonUtil.listOrEmpty((List)schemaFields)) {
            EntityUtil.mergeTags(allTags, schemaField.getTags());
        }
        return allTags;
    }

    public class TopicUpdater
    extends EntityRepository.EntityUpdater {
        public static final String FIELD_DATA_TYPE_DISPLAY = "dataTypeDisplay";

        public TopicUpdater(Topic original, Topic updated, EntityRepository.Operation operation) {
            super((EntityRepository)TopicRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        public void entitySpecificUpdate() throws IOException {
            this.recordChange("maximumMessageSize", ((Topic)this.original).getMaximumMessageSize(), ((Topic)this.updated).getMaximumMessageSize());
            this.recordChange("minimumInSyncReplicas", ((Topic)this.original).getMinimumInSyncReplicas(), ((Topic)this.updated).getMinimumInSyncReplicas());
            this.recordChange("partitions", ((Topic)this.original).getPartitions(), ((Topic)this.updated).getPartitions());
            this.recordChange("replicationFactor", ((Topic)this.original).getReplicationFactor(), ((Topic)this.updated).getReplicationFactor());
            this.recordChange("retentionTime", ((Topic)this.original).getRetentionTime(), ((Topic)this.updated).getRetentionTime());
            this.recordChange("retentionSize", ((Topic)this.original).getRetentionSize(), ((Topic)this.updated).getRetentionSize());
            if (((Topic)this.updated).getMessageSchema() != null) {
                this.recordChange("messageSchema.schemaText", ((Topic)this.original).getMessageSchema() == null ? null : ((Topic)this.original).getMessageSchema().getSchemaText(), ((Topic)this.updated).getMessageSchema().getSchemaText());
                this.recordChange("messageSchema.schemaType", ((Topic)this.original).getMessageSchema() == null ? null : ((Topic)this.original).getMessageSchema().getSchemaType(), ((Topic)this.updated).getMessageSchema().getSchemaType());
                this.updateSchemaFields("messageSchema.schemaFields", ((Topic)this.original).getMessageSchema() == null ? null : ((Topic)this.original).getMessageSchema().getSchemaFields(), ((Topic)this.updated).getMessageSchema().getSchemaFields(), EntityUtil.schemaFieldMatch);
            }
            this.recordChange("topicConfig", ((Topic)this.original).getTopicConfig(), ((Topic)this.updated).getTopicConfig());
            this.updateCleanupPolicies((Topic)this.original, (Topic)this.updated);
        }

        private void updateCleanupPolicies(Topic original, Topic updated) throws JsonProcessingException {
            ArrayList added = new ArrayList();
            ArrayList deleted = new ArrayList();
            this.recordListChange("cleanupPolicies", original.getCleanupPolicies(), updated.getCleanupPolicies(), added, deleted, Enum::equals);
        }

        private void updateSchemaFields(String fieldName, List<Field> origFields, List<Field> updatedFields, BiPredicate<Field, Field> fieldMatch) throws IOException {
            ArrayList deletedFields = new ArrayList();
            ArrayList addedFields = new ArrayList();
            this.recordListChange(fieldName, origFields, updatedFields, addedFields, deletedFields, fieldMatch);
            Map addedFieldMap = addedFields.stream().collect(Collectors.toMap(Field::getName, Function.identity()));
            for (Field deleted2 : deletedFields) {
                if (!addedFieldMap.containsKey(deleted2.getName())) continue;
                Field addedField = (Field)addedFieldMap.get(deleted2.getName());
                if (CommonUtil.nullOrEmpty((String)addedField.getDescription()) && CommonUtil.nullOrEmpty((String)deleted2.getDescription())) {
                    addedField.setDescription(deleted2.getDescription());
                }
                if (!CommonUtil.nullOrEmpty((List)addedField.getTags()) || !CommonUtil.nullOrEmpty((List)deleted2.getTags())) continue;
                addedField.setTags(deleted2.getTags());
            }
            deletedFields.forEach(deleted -> TopicRepository.this.daoCollection.tagUsageDAO().deleteTagsByTarget(deleted.getFullyQualifiedName()));
            for (Field added : addedFields) {
                TopicRepository.this.applyTags(added.getTags(), added.getFullyQualifiedName());
            }
            for (Field updated : updatedFields) {
                Field stored = origFields.stream().filter(c -> fieldMatch.test((Field)c, updated)).findAny().orElse(null);
                if (stored == null) continue;
                this.updateFieldDescription(stored, updated);
                this.updateFieldDataTypeDisplay(stored, updated);
                this.updateFieldDisplayName(stored, updated);
                this.updateTags(stored.getFullyQualifiedName(), EntityUtil.getFieldName(fieldName, updated.getName(), "tags"), stored.getTags(), updated.getTags());
                if (updated.getChildren() == null || stored.getChildren() == null) continue;
                String childrenFieldName = EntityUtil.getFieldName(fieldName, updated.getName());
                this.updateSchemaFields(childrenFieldName, stored.getChildren(), updated.getChildren(), fieldMatch);
            }
            this.majorVersionChange = this.majorVersionChange || !deletedFields.isEmpty();
        }

        private void updateFieldDescription(Field origField, Field updatedField) throws JsonProcessingException {
            if (this.operation.isPut() && !CommonUtil.nullOrEmpty((String)origField.getDescription()) && this.updatedByBot()) {
                updatedField.setDescription(origField.getDescription());
                return;
            }
            String field = EntityUtil.getSchemaField((Topic)this.original, origField, "description");
            this.recordChange(field, origField.getDescription(), updatedField.getDescription());
        }

        private void updateFieldDisplayName(Field origField, Field updatedField) throws JsonProcessingException {
            if (this.operation.isPut() && !CommonUtil.nullOrEmpty((String)origField.getDescription()) && this.updatedByBot()) {
                updatedField.setDisplayName(origField.getDisplayName());
                return;
            }
            String field = EntityUtil.getSchemaField((Topic)this.original, origField, "displayName");
            this.recordChange(field, origField.getDisplayName(), updatedField.getDisplayName());
        }

        private void updateFieldDataTypeDisplay(Field origField, Field updatedField) throws JsonProcessingException {
            if (this.operation.isPut() && !CommonUtil.nullOrEmpty((String)origField.getDataTypeDisplay()) && this.updatedByBot()) {
                updatedField.setDataTypeDisplay(origField.getDataTypeDisplay());
                return;
            }
            String field = EntityUtil.getSchemaField((Topic)this.original, origField, FIELD_DATA_TYPE_DISPLAY);
            this.recordChange(field, origField.getDataTypeDisplay(), updatedField.getDataTypeDisplay());
        }
    }
}

