/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.csv.CsvUtil;
import org.openmetadata.csv.EntityCsv;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.api.teams.CreateTeam;
import org.openmetadata.schema.auth.SSOAuthMechanism;
import org.openmetadata.schema.entity.teams.AuthenticationMechanism;
import org.openmetadata.schema.entity.teams.Team;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.schema.type.csv.CsvDocumentation;
import org.openmetadata.schema.type.csv.CsvErrorType;
import org.openmetadata.schema.type.csv.CsvHeader;
import org.openmetadata.schema.type.csv.CsvImportResult;
import org.openmetadata.service.Entity;
import org.openmetadata.service.OpenMetadataApplicationConfig;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.jdbi3.TeamRepository;
import org.openmetadata.service.secrets.SecretsManager;
import org.openmetadata.service.secrets.SecretsManagerFactory;
import org.openmetadata.service.security.SecurityUtil;
import org.openmetadata.service.security.policyevaluator.SubjectCache;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.UserUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserRepository
extends EntityRepository<User> {
    private static final Logger LOG = LoggerFactory.getLogger(UserRepository.class);
    static final String USER_PATCH_FIELDS = "profile,roles,teams,authenticationMechanism,isEmailVerified";
    static final String USER_UPDATE_FIELDS = "profile,roles,teams,authenticationMechanism,isEmailVerified";
    private final EntityReference organization;

    public UserRepository(CollectionDAO dao) {
        super("v1/users/", "user", User.class, dao.userDAO(), dao, "profile,roles,teams,authenticationMechanism,isEmailVerified", "profile,roles,teams,authenticationMechanism,isEmailVerified");
        this.organization = dao.teamDAO().findEntityReferenceByName("Organization", Include.ALL);
    }

    public final EntityUtil.Fields getFieldsWithUserAuth(String fields) {
        List<String> tempFields = this.getAllowedFieldsCopy();
        if (fields != null && fields.equals("*")) {
            tempFields.add("authenticationMechanism");
            return new EntityUtil.Fields(tempFields, String.join((CharSequence)",", tempFields));
        }
        return new EntityUtil.Fields(tempFields, fields);
    }

    @Override
    public void prepare(User user) throws IOException {
        this.validateTeams(user);
        this.validateRoles(user.getRoles());
    }

    @Override
    public void restorePatchAttributes(User original, User updated) {
        updated.withId(original.getId()).withName(original.getName()).withInheritedRoles(original.getInheritedRoles()).withAuthenticationMechanism(original.getAuthenticationMechanism());
    }

    private List<EntityReference> getInheritedRoles(User user) throws IOException {
        if (Boolean.TRUE.equals(user.getIsBot())) {
            return null;
        }
        this.getTeams(user);
        return SubjectCache.getInstance() != null ? SubjectCache.getInstance().getRolesForTeams(this.getTeams(user)) : null;
    }

    @Override
    public void storeEntity(User user, boolean update) throws IOException {
        List roles = user.getRoles();
        List teams = user.getTeams();
        user.withRoles(null).withTeams(null).withInheritedRoles(null);
        SecretsManager secretsManager = SecretsManagerFactory.getSecretsManager();
        if (secretsManager != null && Boolean.TRUE.equals(user.getIsBot())) {
            secretsManager.encryptOrDecryptAuthenticationMechanism(user.getName(), user.getAuthenticationMechanism(), true);
        }
        this.store(user, update);
        if (update) {
            SubjectCache.getInstance().invalidateUser(user.getName());
        }
        user.withRoles(roles).withTeams(teams);
    }

    @Override
    public void storeRelationships(User user) throws IOException {
        this.assignRoles(user, user.getRoles());
        this.assignTeams(user, user.getTeams());
        user.setInheritedRoles(this.getInheritedRoles(user));
    }

    public UserUpdater getUpdater(User original, User updated, EntityRepository.Operation operation) {
        return new UserUpdater(original, updated, operation);
    }

    @Override
    protected void postDelete(User entity) {
        SubjectCache.getInstance().invalidateUser(entity.getName());
    }

    @Override
    protected void cleanup(User user) throws IOException {
        super.cleanup(user);
        SubjectCache.getInstance().invalidateUser(user.getName());
    }

    @Override
    public User setFields(User user, EntityUtil.Fields fields) throws IOException {
        user.setProfile(fields.contains("profile") ? user.getProfile() : null);
        user.setTeams(fields.contains("teams") ? this.getTeams(user) : null);
        user.setOwns(fields.contains("owns") ? this.getOwns(user) : null);
        user.setFollows(fields.contains("follows") ? this.getFollows(user) : null);
        user.setRoles(fields.contains("roles") ? this.getRoles(user) : null);
        user.setAuthenticationMechanism(fields.contains("authenticationMechanism") ? user.getAuthenticationMechanism() : null);
        user.setIsEmailVerified(fields.contains("isEmailVerified") ? user.getIsEmailVerified() : null);
        return user.withInheritedRoles(fields.contains("roles") ? this.getInheritedRoles(user) : null);
    }

    @Override
    public String exportToCsv(String importingTeam, String user) throws IOException {
        Team team = (Team)this.daoCollection.teamDAO().findEntityByName(importingTeam);
        return new UserCsv(team, user).exportCsv();
    }

    @Override
    public CsvImportResult importFromCsv(String importingTeam, String csv, boolean dryRun, String user) throws IOException {
        Team team = (Team)this.daoCollection.teamDAO().findEntityByName(importingTeam);
        UserCsv userCsv = new UserCsv(team, user);
        return userCsv.importCsv(csv, dryRun);
    }

    public boolean isTeamJoinable(String teamId) throws IOException {
        Team team = (Team)this.daoCollection.teamDAO().findEntityById(UUID.fromString(teamId), Include.NON_DELETED);
        return team.getIsJoinable();
    }

    public void validateTeams(User user) throws IOException {
        List teams = user.getTeams();
        if (teams != null) {
            for (EntityReference entityReference : teams) {
                EntityReference ref = this.daoCollection.teamDAO().findEntityReferenceById(entityReference.getId());
                EntityUtil.copy(ref, entityReference);
            }
            teams.sort(EntityUtil.compareEntityReference);
        } else {
            user.setTeams(new ArrayList<EntityReference>(List.of(this.organization)));
        }
    }

    public void validateTeamAddition(UUID userId, UUID teamId) throws IOException {
        User user = (User)this.dao.findEntityById(userId);
        List<EntityReference> teams = this.getTeams(user);
        Optional<EntityReference> team = teams.stream().filter(t -> t.getId().equals(teamId)).findFirst();
        if (team.isPresent()) {
            throw new IllegalArgumentException(CatalogExceptionMessage.userAlreadyPartOfTeam(user.getName(), team.get().getDisplayName()));
        }
    }

    public boolean checkEmailAlreadyExists(String emailId) {
        return this.daoCollection.userDAO().checkEmailExists(emailId) > 0;
    }

    public void initializeUsers(OpenMetadataApplicationConfig config) {
        HashSet<String> adminUsers = new HashSet<String>(config.getAuthorizerConfiguration().getAdminPrincipals());
        LOG.debug("Checking user entries for admin users {}", adminUsers);
        String domain = SecurityUtil.getDomain(config);
        String providerType = config.getAuthenticationConfiguration().getProvider();
        if (providerType.equals(SSOAuthMechanism.SsoServiceType.BASIC.value())) {
            UserUtil.handleBasicAuth(adminUsers, domain);
        } else {
            UserUtil.addUsers(adminUsers, domain, true);
        }
        LOG.debug("Checking user entries for test users");
        HashSet<String> testUsers = new HashSet<String>(config.getAuthorizerConfiguration().getTestPrincipals());
        UserUtil.addUsers(testUsers, domain, null);
    }

    private List<EntityReference> getOwns(User user) throws IOException {
        List<CollectionDAO.EntityRelationshipRecord> ownedEntities = this.daoCollection.relationshipDAO().findTo(user.getId().toString(), "user", Relationship.OWNS.ordinal());
        List<EntityReference> teams = user.getTeams() == null ? this.getTeams(user) : user.getTeams();
        for (EntityReference team : teams) {
            ownedEntities.addAll(this.daoCollection.relationshipDAO().findTo(team.getId().toString(), "team", Relationship.OWNS.ordinal()));
        }
        return EntityUtil.getEntityReferences(ownedEntities);
    }

    private List<EntityReference> getFollows(User user) throws IOException {
        return EntityUtil.getEntityReferences(this.daoCollection.relationshipDAO().findTo(user.getId().toString(), "user", Relationship.FOLLOWS.ordinal()));
    }

    private List<EntityReference> getTeamChildren(UUID teamId) throws IOException {
        if (teamId.equals(this.organization.getId())) {
            List<String> children = this.daoCollection.teamDAO().listTeamsUnderOrganization(teamId.toString());
            return EntityUtil.populateEntityReferencesById(EntityUtil.toIDs(children), "team");
        }
        List<CollectionDAO.EntityRelationshipRecord> children = this.findTo(teamId, "team", Relationship.PARENT_OF, "team");
        return EntityUtil.populateEntityReferences(children, "team");
    }

    public List<EntityReference> getGroupTeams(UriInfo uriInfo, String userName) throws IOException {
        User user = (User)this.getByName(uriInfo, userName, EntityUtil.Fields.EMPTY_FIELDS, Include.ALL);
        List<EntityReference> teams = this.getTeams(user);
        return this.getGroupTeams(teams);
    }

    private List<EntityReference> getGroupTeams(List<EntityReference> teams) throws IOException {
        HashSet<EntityReference> result = new HashSet<EntityReference>();
        for (EntityReference t : teams) {
            Team team = (Team)Entity.getEntity(t, "", Include.ALL);
            if (CreateTeam.TeamType.GROUP.equals((Object)team.getTeamType())) {
                result.add(t);
                continue;
            }
            List<EntityReference> children = this.getTeamChildren(team.getId());
            result.addAll(this.getGroupTeams(children));
        }
        return new ArrayList<EntityReference>(result);
    }

    private List<EntityReference> getRoles(User user) throws IOException {
        List<CollectionDAO.EntityRelationshipRecord> roleIds = this.findTo(user.getId(), "user", Relationship.HAS, "role");
        return EntityUtil.populateEntityReferences(roleIds, "role");
    }

    private List<EntityReference> getTeams(User user) throws IOException {
        List<CollectionDAO.EntityRelationshipRecord> records = this.findFrom(user.getId(), "user", Relationship.HAS, "team");
        List<Object> teams = EntityUtil.populateEntityReferences(records, "team");
        if (CommonUtil.listOrEmpty(teams = teams.stream().filter(team -> team.getDeleted() == false).collect(Collectors.toList())).isEmpty()) {
            return new ArrayList<EntityReference>(List.of(this.organization));
        }
        return teams;
    }

    private void assignRoles(User user, List<EntityReference> roles) {
        roles = CommonUtil.listOrEmpty(roles);
        for (EntityReference role : roles) {
            this.addRelationship(user.getId(), role.getId(), "user", "role", Relationship.HAS);
        }
    }

    private void assignTeams(User user, List<EntityReference> teams) {
        teams = CommonUtil.listOrEmpty(teams);
        for (EntityReference team : teams) {
            if (team.getId().equals(this.organization.getId())) continue;
            this.addRelationship(team.getId(), user.getId(), "team", "user", Relationship.HAS);
        }
        if (teams.size() > 1) {
            teams = teams.stream().filter(t -> !t.getId().equals(this.organization.getId())).collect(Collectors.toList());
            user.setTeams(teams);
        }
    }

    public class UserUpdater
    extends EntityRepository.EntityUpdater {
        public UserUpdater(User original, User updated, EntityRepository.Operation operation) {
            super((EntityRepository)UserRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        public void entitySpecificUpdate() throws IOException {
            this.updateRoles((User)this.original, (User)this.updated);
            this.updateTeams((User)this.original, (User)this.updated);
            this.recordChange("profile", ((User)this.original).getProfile(), ((User)this.updated).getProfile(), true);
            this.recordChange("timezone", ((User)this.original).getTimezone(), ((User)this.updated).getTimezone());
            this.recordChange("isBot", ((User)this.original).getIsBot(), ((User)this.updated).getIsBot());
            this.recordChange("isAdmin", ((User)this.original).getIsAdmin(), ((User)this.updated).getIsAdmin());
            this.recordChange("email", ((User)this.original).getEmail(), ((User)this.updated).getEmail());
            this.recordChange("isEmailVerified", ((User)this.original).getIsEmailVerified(), ((User)this.updated).getIsEmailVerified());
            this.updateAuthenticationMechanism((User)this.original, (User)this.updated);
        }

        private void updateRoles(User original, User updated) throws IOException {
            UserRepository.this.deleteFrom(original.getId(), "user", Relationship.HAS, "role");
            UserRepository.this.assignRoles(updated, updated.getRoles());
            List origRoles = CommonUtil.listOrEmpty((List)original.getRoles());
            List updatedRoles = CommonUtil.listOrEmpty((List)updated.getRoles());
            origRoles.sort(EntityUtil.compareEntityReference);
            updatedRoles.sort(EntityUtil.compareEntityReference);
            ArrayList added = new ArrayList();
            ArrayList deleted = new ArrayList();
            this.recordListChange("roles", origRoles, updatedRoles, added, deleted, EntityUtil.entityReferenceMatch);
        }

        private void updateTeams(User original, User updated) throws IOException {
            UserRepository.this.deleteTo(original.getId(), "user", Relationship.HAS, "team");
            UserRepository.this.assignTeams(updated, updated.getTeams());
            List origTeams = CommonUtil.listOrEmpty((List)original.getTeams());
            List updatedTeams = CommonUtil.listOrEmpty((List)updated.getTeams());
            origTeams.sort(EntityUtil.compareEntityReference);
            updatedTeams.sort(EntityUtil.compareEntityReference);
            ArrayList added = new ArrayList();
            ArrayList deleted = new ArrayList();
            this.recordListChange("teams", origTeams, updatedTeams, added, deleted, EntityUtil.entityReferenceMatch);
        }

        private void updateAuthenticationMechanism(User original, User updated) throws IOException {
            AuthenticationMechanism origAuthMechanism = original.getAuthenticationMechanism();
            AuthenticationMechanism updatedAuthMechanism = updated.getAuthenticationMechanism();
            if (origAuthMechanism == null && updatedAuthMechanism != null) {
                this.recordChange("authenticationMechanism", original.getAuthenticationMechanism(), "new-encrypted-value");
            } else if (origAuthMechanism != null && updatedAuthMechanism != null && !JsonUtils.areEquals(origAuthMechanism, updatedAuthMechanism)) {
                this.recordChange("authenticationMechanism", "old-encrypted-value", "new-encrypted-value");
            }
        }
    }

    public static class UserCsv
    extends EntityCsv<User> {
        public static final CsvDocumentation DOCUMENTATION = UserCsv.getCsvDocumentation("user");
        public static final List<CsvHeader> HEADERS = DOCUMENTATION.getHeaders();
        public final Team team;

        UserCsv(Team importingTeam, String updatedBy) {
            super("user", HEADERS, updatedBy);
            this.team = importingTeam;
        }

        @Override
        protected User toEntity(CSVPrinter printer, CSVRecord record) throws IOException {
            User user = new User().withName(record.get(0)).withDisplayName(record.get(1)).withDescription(record.get(2)).withEmail(record.get(3)).withTimezone(record.get(4)).withIsAdmin(this.getBoolean(printer, record, 5));
            user.setTeams(this.getTeams(printer, record, user.getName()));
            if (!this.processRecord) {
                return null;
            }
            user.setRoles(this.getEntityReferences(printer, record, 7, "role"));
            if (!this.processRecord) {
                return null;
            }
            return user;
        }

        @Override
        protected List<String> toRecord(User entity) {
            ArrayList<String> record = new ArrayList<String>();
            CsvUtil.addField(record, entity.getName());
            CsvUtil.addField(record, entity.getDisplayName());
            CsvUtil.addField(record, entity.getDescription());
            CsvUtil.addField(record, entity.getEmail());
            CsvUtil.addField(record, entity.getTimezone());
            CsvUtil.addField(record, entity.getIsAdmin());
            CsvUtil.addField(record, ((EntityReference)entity.getTeams().get(0)).getFullyQualifiedName());
            CsvUtil.addEntityReferences(record, entity.getRoles());
            return record;
        }

        private List<User> listUsers(TeamRepository teamRepository, UserRepository userRepository, String parentTeam, List<User> users, EntityUtil.Fields fields) throws IOException {
            ListFilter filter = new ListFilter(Include.NON_DELETED).addQueryParam("team", parentTeam);
            List userList = userRepository.listAll(fields, filter);
            if (!CommonUtil.nullOrEmpty(userList)) {
                users.addAll(userList);
            }
            filter = new ListFilter(Include.NON_DELETED).addQueryParam("parentTeam", parentTeam);
            List teamList = teamRepository.listAll(EntityUtil.Fields.EMPTY_FIELDS, filter);
            for (Team team : teamList) {
                this.listUsers(teamRepository, userRepository, team.getName(), users, fields);
            }
            return users;
        }

        public String exportCsv() throws IOException {
            UserRepository userRepository = (UserRepository)Entity.getEntityRepository("user");
            TeamRepository teamRepository = (TeamRepository)Entity.getEntityRepository("team");
            EntityUtil.Fields fields = userRepository.getFields("roles,teams");
            return this.exportCsv(this.listUsers(teamRepository, userRepository, this.team.getName(), new ArrayList<User>(), fields));
        }

        private List<EntityReference> getTeams(CSVPrinter printer, CSVRecord record, String user) throws IOException {
            List<EntityReference> teams = this.getEntityReferences(printer, record, 6, "team");
            for (EntityReference teamRef : CommonUtil.listOrEmpty(teams)) {
                if (teamRef.getName().equals(this.team.getName()) || SubjectCache.getInstance().isInTeam(this.team.getName(), teamRef)) continue;
                this.importFailure(printer, UserCsv.invalidTeam(6, this.team.getName(), user, teamRef.getName()), record);
                this.processRecord = false;
            }
            return teams;
        }

        public static String invalidTeam(int field, String team, String user, String userTeam) {
            String error = String.format("Team %s of user %s is not under %s team hierarchy", userTeam, user, team);
            return String.format("#%s: Field %d error - %s", CsvErrorType.INVALID_FIELD, field + 1, error);
        }
    }
}

