/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3.locator;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.internal.JdbiOptionals;
import org.jdbi.v3.sqlobject.internal.SqlAnnotations;
import org.jdbi.v3.sqlobject.locator.SqlLocator;
import org.openmetadata.service.jdbi3.locator.ConnectionAwareSqlQuery;
import org.openmetadata.service.jdbi3.locator.ConnectionAwareSqlQueryContainer;
import org.openmetadata.service.jdbi3.locator.ConnectionAwareSqlUpdate;
import org.openmetadata.service.jdbi3.locator.ConnectionAwareSqlUpdateContainer;
import org.openmetadata.service.jdbi3.locator.ConnectionType;

public class ConnectionAwareAnnotationSqlLocator
implements SqlLocator {
    private final ConnectionType connectionType;
    private final ConcurrentMap<Method, String> located = new ConcurrentHashMap<Method, String>();

    public ConnectionAwareAnnotationSqlLocator(String jdbcDriverClass) {
        this.connectionType = ConnectionType.from(Objects.requireNonNull(jdbcDriverClass, "Connection type is null"));
    }

    public String locate(Class<?> sqlObjectType, Method method, ConfigRegistry config) {
        return this.located.computeIfAbsent(method, m -> this.getAnnotationValue((Method)m).orElseThrow(() -> new IllegalStateException(String.format("Method %s is missing SQL annotation for connection type %s", new Object[]{method, this.connectionType}))));
    }

    private Optional<String> getAnnotationValue(Method method) {
        return JdbiOptionals.findFirstPresent((Supplier[])new Supplier[]{() -> Optional.ofNullable(method.getAnnotation(ConnectionAwareSqlUpdateContainer.class)).map(ConnectionAwareSqlUpdateContainer::value).map(Arrays::asList).map(l -> l.stream().filter(a -> a.connectionType().equals((Object)this.connectionType)).findFirst()).flatMap(Function.identity()).map(ConnectionAwareSqlUpdate::value), () -> Optional.ofNullable(method.getAnnotation(ConnectionAwareSqlQueryContainer.class)).map(ConnectionAwareSqlQueryContainer::value).map(Arrays::asList).map(l -> l.stream().filter(a -> a.connectionType().equals((Object)this.connectionType)).findFirst()).flatMap(Function.identity()).map(ConnectionAwareSqlQuery::value), () -> SqlAnnotations.getAnnotationValue((Method)method)});
    }
}

