/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.usage;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.util.Date;
import java.util.Objects;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.openmetadata.schema.type.DailyCount;
import org.openmetadata.schema.type.EntityUsage;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.UsageRepository;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.util.RestUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/usage")
@Tag(name="Usage", description="APIs related usage of data assets.")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Collection(name="usage")
public class UsageResource {
    private static final Logger LOG = LoggerFactory.getLogger(UsageResource.class);
    private final UsageRepository dao;

    public UsageResource(CollectionDAO dao, Authorizer authorizer) {
        Objects.requireNonNull(dao, "UsageRepository must not be null");
        this.dao = new UsageRepository(dao);
    }

    @GET
    @Valid
    @Path(value="/{entity}/{id}")
    @Operation(operationId="getEntityUsageByID", summary="Get usage by id", description="Get usage details for an entity identified by `id`.", responses={@ApiResponse(responseCode="200", description="Entity usage", content={@Content(mediaType="application/json", schema=@Schema(implementation=EntityUsage.class))}), @ApiResponse(responseCode="404", description="Entity for instance {id} is not found")})
    public EntityUsage get(@Context UriInfo uriInfo, @Parameter(description="Entity type for which usage is requested", required=true, schema=@Schema(type="string", example="table, report, metrics, or dashboard")) @PathParam(value="entity") String entity, @Parameter(description="Entity id", required=true, schema=@Schema(type="string")) @PathParam(value="id") String id, @Parameter(description="Usage for number of days going back from the given date (default=1, min=1, max=30)") @QueryParam(value="days") int days, @Parameter(description="Usage for number of days going back from this date in ISO 8601 format. (default = currentDate)") @QueryParam(value="date") String date) throws IOException {
        int actualDays = Math.min(Math.max(days, 1), 30);
        String actualDate = date == null ? RestUtil.DATE_FORMAT.format(new Date()) : date;
        return UsageResource.addHref(uriInfo, this.dao.get(entity, id, actualDate, actualDays));
    }

    @GET
    @Valid
    @Path(value="/{entity}/name/{fqn}")
    @Operation(operationId="getEntityUsageByFQN", summary="Get usage by fully qualified name", description="Get usage details for an entity identified by fully qualified name.", responses={@ApiResponse(responseCode="200", description="Entity usage", content={@Content(mediaType="application/json", schema=@Schema(implementation=EntityUsage.class))}), @ApiResponse(responseCode="404", description="Entity for instance {fqn} is not found")})
    public EntityUsage getByName(@Context UriInfo uriInfo, @Parameter(description="Entity type for which usage is requested", required=true, schema=@Schema(type="string", example="table, report, metrics, or dashboard")) @PathParam(value="entity") String entity, @Parameter(description="Fully qualified name of the entity that uniquely identifies an entity", required=true, schema=@Schema(type="string")) @PathParam(value="fqn") String fqn, @Parameter(description="Usage for number of days going back from the given date (default=1, min=1, max=30)") @QueryParam(value="days") int days, @Parameter(description="Usage for number of days going back from this date in ISO 8601 format (default = currentDate)") @QueryParam(value="date") String date) {
        int actualDays = Math.min(Math.max(days, 1), 30);
        String actualDate = date == null ? RestUtil.DATE_FORMAT.format(new Date()) : date;
        return UsageResource.addHref(uriInfo, this.dao.getByName(entity, fqn, actualDate, actualDays));
    }

    @POST
    @Path(value="/{entity}/{id}")
    @Operation(operationId="reportEntityUsageWithID", summary="Report usage", description="Report usage information for an entity on a given date. System stores last 30 days of usage information. Usage information older than 30 days is deleted.", responses={@ApiResponse(responseCode="200", description="Usage information", content={@Content(mediaType="application/json", schema=@Schema(implementation=EntityUsage.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response create(@Context UriInfo uriInfo, @Parameter(description="Entity type for which usage is reported", required=true, schema=@Schema(type="string", example="table, report, metrics, or dashboard")) @PathParam(value="entity") String entity, @Parameter(description="Entity id", required=true, schema=@Schema(type="string")) @PathParam(value="id") String id, @Parameter(description="Usage information a given date") @Valid DailyCount usage) throws IOException {
        return this.dao.create(entity, id, usage).toResponse();
    }

    @PUT
    @Path(value="/{entity}/{id}")
    @Operation(operationId="reportEntityUsageWithID", summary="Report usage", description="Report usage information for an entity on a given date. System stores last 30 days of usage information. Usage information older than 30 days is deleted.", responses={@ApiResponse(responseCode="200", description="Usage information", content={@Content(mediaType="application/json", schema=@Schema(implementation=EntityUsage.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response createOrUpdate(@Context UriInfo uriInfo, @Parameter(description="Entity type for which usage is reported", required=true, schema=@Schema(type="string", example="table, report, metrics, or dashboard")) @PathParam(value="entity") String entity, @Parameter(description="Entity id", required=true, schema=@Schema(type="string")) @PathParam(value="id") String id, @Parameter(description="Usage information a given date") @Valid DailyCount usage) throws IOException {
        return this.dao.createOrUpdate(entity, id, usage).toResponse();
    }

    @POST
    @Path(value="/{entity}/name/{fqn}")
    @Operation(operationId="reportEntityUsageWithFQN", summary="Report usage by fully qualified name", description="Report usage information for an entity by name on a given date. System stores last 30 days of usage information. Usage information older than 30 days is deleted.", responses={@ApiResponse(responseCode="200", description="Usage information", content={@Content(mediaType="application/json", schema=@Schema(implementation=EntityUsage.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response createByName(@Context UriInfo uriInfo, @Parameter(description="Entity type for which usage is reported", required=true, schema=@Schema(type="string", example="table, report, metrics, or dashboard")) @PathParam(value="entity") String entity, @Parameter(description="Fully qualified name of the entity that uniquely identifies an entity", required=true, schema=@Schema(type="string")) @PathParam(value="fqn") String fullyQualifiedName, @Parameter(description="Usage information a given date") @Valid DailyCount usage) throws IOException {
        return this.dao.createByName(entity, fullyQualifiedName, usage).toResponse();
    }

    @PUT
    @Path(value="/{entity}/name/{fqn}")
    @Operation(operationId="reportEntityUsageWithFQN", summary="Report usage by fully qualified name", description="Report usage information for an entity by name on a given date. System stores last 30 days of usage information. Usage information older than 30 days is deleted.", responses={@ApiResponse(responseCode="200", description="Usage information", content={@Content(mediaType="application/json", schema=@Schema(implementation=EntityUsage.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response createOrUpdateByName(@Context UriInfo uriInfo, @Parameter(description="Entity type for which usage is reported", required=true, schema=@Schema(type="string", example="table, report, metrics, or dashboard")) @PathParam(value="entity") String entity, @Parameter(description="Fully qualified name of the entity that uniquely identifies an entity", required=true, schema=@Schema(type="string")) @PathParam(value="fqn") String fullyQualifiedName, @Parameter(description="Usage information a given date") @Valid DailyCount usage) throws IOException {
        return this.dao.createOrUpdateByName(entity, fullyQualifiedName, usage).toResponse();
    }

    @POST
    @Path(value="/compute.percentile/{entity}/{date}")
    @Operation(operationId="computeEntityUsagePercentile", summary="Compute percentiles", description="Compute percentile ranking for an entity based on last 30 days of usage.", hidden=true, responses={@ApiResponse(responseCode="201", description="Percentiles computed"), @ApiResponse(responseCode="400", description="Bad request")})
    public Response computePercentile(@Context UriInfo uriInfo, @Parameter(description="Entity name for which usage is requested", schema=@Schema(type="string", example="table, report, metrics, or dashboard")) @PathParam(value="entity") String entity, @Parameter(description="ISO 8601 format date to compute percentile on", schema=@Schema(type="string", example="2021-01-28")) @PathParam(value="date") String date) {
        this.dao.computePercentile(entity, date);
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    public static EntityUsage addHref(UriInfo uriInfo, EntityUsage entityUsage) {
        Entity.withHref(uriInfo, entityUsage.getEntity());
        return entityUsage;
    }
}

