/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.secrets;

import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.openmetadata.annotations.PasswordField;
import org.openmetadata.schema.auth.BasicAuthMechanism;
import org.openmetadata.schema.entity.automations.Workflow;
import org.openmetadata.schema.entity.services.ServiceType;
import org.openmetadata.schema.entity.services.ingestionPipelines.IngestionPipeline;
import org.openmetadata.schema.entity.teams.AuthenticationMechanism;
import org.openmetadata.schema.security.client.OpenMetadataJWTClientConfig;
import org.openmetadata.schema.security.secrets.SecretsManagerProvider;
import org.openmetadata.schema.services.connections.metadata.OpenMetadataConnection;
import org.openmetadata.service.exception.CustomExceptionMessage;
import org.openmetadata.service.exception.InvalidServiceConnectionException;
import org.openmetadata.service.exception.SecretsManagerException;
import org.openmetadata.service.fernet.Fernet;
import org.openmetadata.service.secrets.converter.ClassConverterFactory;
import org.openmetadata.service.util.AuthenticationMechanismBuilder;
import org.openmetadata.service.util.IngestionPipelineBuilder;
import org.openmetadata.service.util.ReflectionUtil;

public abstract class SecretsManager {
    private final String clusterPrefix;
    private final SecretsManagerProvider secretsManagerProvider;
    private Fernet fernet;
    private static final Set<Class<?>> DO_NOT_ENCRYPT_CLASSES = Set.of(OpenMetadataJWTClientConfig.class, BasicAuthMechanism.class);

    protected SecretsManager(SecretsManagerProvider secretsManagerProvider, String clusterPrefix) {
        this.secretsManagerProvider = secretsManagerProvider;
        this.clusterPrefix = clusterPrefix;
        this.fernet = Fernet.getInstance();
    }

    public Object encryptOrDecryptServiceConnectionConfig(Object connectionConfig, String connectionType, String connectionName, ServiceType serviceType, boolean encrypt) {
        try {
            Class<?> clazz = ReflectionUtil.createConnectionConfigClass(connectionType, serviceType);
            Object newConnectionConfig = ClassConverterFactory.getConverter(clazz).convert(connectionConfig);
            return this.encryptOrDecryptPasswordFields(newConnectionConfig, this.buildSecretId(true, serviceType.value(), connectionName), encrypt, true);
        }
        catch (Exception e) {
            throw InvalidServiceConnectionException.byMessage(connectionType, String.format("Failed to encrypt connection instance of %s", connectionType));
        }
    }

    public void encryptOrDecryptAuthenticationMechanism(String name, AuthenticationMechanism authenticationMechanism, boolean encrypt) {
        if (authenticationMechanism != null) {
            AuthenticationMechanismBuilder.addDefinedConfig(authenticationMechanism);
            try {
                this.encryptOrDecryptPasswordFields(authenticationMechanism, this.buildSecretId(true, "bot", name), encrypt, true);
            }
            catch (Exception e) {
                throw new CustomExceptionMessage(Response.Status.BAD_REQUEST, String.format("Failed to encrypt user bot instance [%s]", name));
            }
        }
    }

    public void encryptOrDecryptIngestionPipeline(IngestionPipeline ingestionPipeline, boolean encrypt) {
        OpenMetadataConnection openMetadataConnection = this.encryptOrDecryptOpenMetadataConnection(ingestionPipeline.getOpenMetadataServerConnection(), encrypt, true);
        ingestionPipeline.setOpenMetadataServerConnection(null);
        IngestionPipelineBuilder.addDefinedConfig(ingestionPipeline);
        try {
            this.encryptOrDecryptPasswordFields(ingestionPipeline, this.buildSecretId(true, "pipeline", ingestionPipeline.getName()), encrypt, true);
        }
        catch (Exception e) {
            throw new CustomExceptionMessage(Response.Status.BAD_REQUEST, String.format("Failed to encrypt ingestion pipeline instance [%s]", ingestionPipeline.getName()));
        }
        ingestionPipeline.setOpenMetadataServerConnection(openMetadataConnection);
    }

    public Workflow encryptOrDecryptWorkflow(Workflow workflow, boolean encrypt) {
        OpenMetadataConnection openMetadataConnection = this.encryptOrDecryptOpenMetadataConnection(workflow.getOpenMetadataServerConnection(), encrypt, true);
        Workflow workflowConverted = (Workflow)ClassConverterFactory.getConverter(Workflow.class).convert(workflow);
        workflowConverted.setOpenMetadataServerConnection(null);
        try {
            this.encryptOrDecryptPasswordFields(workflowConverted, this.buildSecretId(true, "workflow", workflow.getName()), encrypt, true);
        }
        catch (Exception e) {
            throw new CustomExceptionMessage(Response.Status.BAD_REQUEST, String.format("Failed to encrypt workflow instance [%s]", workflow.getName()));
        }
        workflowConverted.setOpenMetadataServerConnection(openMetadataConnection);
        return workflowConverted;
    }

    public OpenMetadataConnection encryptOrDecryptOpenMetadataConnection(OpenMetadataConnection openMetadataConnection, boolean encrypt, boolean store) {
        if (openMetadataConnection != null) {
            OpenMetadataConnection openMetadataConnectionConverted = (OpenMetadataConnection)ClassConverterFactory.getConverter(OpenMetadataConnection.class).convert(openMetadataConnection);
            try {
                this.encryptOrDecryptPasswordFields(openMetadataConnectionConverted, this.buildSecretId(true, "serverconnection"), encrypt, store);
            }
            catch (Exception e) {
                throw new CustomExceptionMessage(Response.Status.BAD_REQUEST, "Failed to encrypt OpenMetadataConnection instance.");
            }
            return openMetadataConnectionConverted;
        }
        return null;
    }

    private Object encryptOrDecryptPasswordFields(Object targetObject, String name, boolean encrypt, boolean store) {
        if (encrypt) {
            this.encryptPasswordFields(targetObject, name, store);
        } else {
            this.decryptPasswordFields(targetObject);
        }
        return targetObject;
    }

    private void encryptPasswordFields(Object toEncryptObject, String secretId, boolean store) {
        if (!DO_NOT_ENCRYPT_CLASSES.contains(toEncryptObject.getClass())) {
            Arrays.stream(toEncryptObject.getClass().getMethods()).filter(ReflectionUtil::isGetMethodOfObject).forEach(method -> {
                Object obj = ReflectionUtil.getObjectFromMethod(method, toEncryptObject);
                String fieldName = method.getName().replaceFirst("get", "");
                if (obj != null && obj.getClass().getPackageName().startsWith("org.openmetadata")) {
                    this.encryptPasswordFields(obj, this.buildSecretId(false, secretId, fieldName.toLowerCase(Locale.ROOT)), store);
                } else if (obj != null && method.getAnnotation(PasswordField.class) != null) {
                    String newFieldValue = this.storeValue(fieldName, this.fernet.decryptIfApplies((String)obj), secretId, store);
                    Method toSet = ReflectionUtil.getToSetMethod(toEncryptObject, obj, fieldName);
                    ReflectionUtil.setValueInMethod(toEncryptObject, Fernet.isTokenized(newFieldValue) ? newFieldValue : (store ? this.fernet.encrypt(newFieldValue) : newFieldValue), toSet);
                }
            });
        }
    }

    private void decryptPasswordFields(Object toDecryptObject) {
        Arrays.stream(toDecryptObject.getClass().getMethods()).filter(ReflectionUtil::isGetMethodOfObject).forEach(method -> {
            Object obj = ReflectionUtil.getObjectFromMethod(method, toDecryptObject);
            String fieldName = method.getName().replaceFirst("get", "");
            if (obj != null && obj.getClass().getPackageName().startsWith("org.openmetadata")) {
                this.decryptPasswordFields(obj);
            } else if (obj != null && method.getAnnotation(PasswordField.class) != null) {
                String fieldValue = (String)obj;
                Method toSet = ReflectionUtil.getToSetMethod(toDecryptObject, obj, fieldName);
                ReflectionUtil.setValueInMethod(toDecryptObject, Fernet.isTokenized(fieldValue) ? this.fernet.decrypt(fieldValue) : fieldValue, toSet);
            }
        });
    }

    protected abstract String storeValue(String var1, String var2, String var3, boolean var4);

    protected String getSecretSeparator() {
        return "/";
    }

    protected boolean startsWithSeparator() {
        return true;
    }

    protected String buildSecretId(boolean addClusterPrefix, String ... secretIdValues) {
        StringBuilder format = new StringBuilder();
        if (addClusterPrefix) {
            format.append(this.startsWithSeparator() ? this.getSecretSeparator() : "");
            format.append(this.clusterPrefix);
        } else {
            format.append("%s");
        }
        Arrays.stream(secretIdValues).skip(addClusterPrefix ? 0L : 1L).forEach(secretIdValue -> {
            if (Objects.isNull(secretIdValue)) {
                throw new SecretsManagerException("Cannot build a secret id with null values.");
            }
            format.append(this.getSecretSeparator());
            format.append("%s");
        });
        return String.format(format.toString(), secretIdValues).toLowerCase();
    }

    @VisibleForTesting
    void setFernet(Fernet fernet) {
        this.fernet = fernet;
    }

    public String getClusterPrefix() {
        return this.clusterPrefix;
    }

    public SecretsManagerProvider getSecretsManagerProvider() {
        return this.secretsManagerProvider;
    }
}

