/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.secrets;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.ServiceConnectionEntityInterface;
import org.openmetadata.schema.ServiceEntityInterface;
import org.openmetadata.schema.entity.services.ingestionPipelines.IngestionPipeline;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.SecretsManagerUpdateException;
import org.openmetadata.service.jdbi3.IngestionPipelineRepository;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.jdbi3.ServiceEntityRepository;
import org.openmetadata.service.jdbi3.UserRepository;
import org.openmetadata.service.resources.CollectionRegistry;
import org.openmetadata.service.resources.services.ServiceEntityResource;
import org.openmetadata.service.secrets.SecretsManager;
import org.openmetadata.service.secrets.SecretsManagerFactory;
import org.openmetadata.service.util.EntityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecretsManagerUpdateService {
    private static final Logger LOG = LoggerFactory.getLogger(SecretsManagerUpdateService.class);
    private final SecretsManager secretManager;
    private final SecretsManager oldSecretManager;
    private final UserRepository userRepository;
    private final IngestionPipelineRepository ingestionPipelineRepository;
    private final Map<Class<? extends ServiceConnectionEntityInterface>, ServiceEntityRepository<?, ?>> connectionTypeRepositoriesMap;

    public SecretsManagerUpdateService(SecretsManager secretsManager, String clusterName) {
        this.secretManager = secretsManager;
        this.connectionTypeRepositoriesMap = this.retrieveConnectionTypeRepositoriesMap();
        this.userRepository = (UserRepository)Entity.getEntityRepository("user");
        this.ingestionPipelineRepository = (IngestionPipelineRepository)Entity.getEntityRepository("ingestionPipeline");
        this.oldSecretManager = SecretsManagerFactory.createSecretsManager(null, clusterName);
    }

    public void updateEntities() {
        this.updateServices();
        this.updateBotUsers();
        this.updateIngestionPipelines();
    }

    private void updateServices() {
        LOG.info(String.format("Updating services in case of an update on the JSON schema: [%s]", this.secretManager.getSecretsManagerProvider().value()));
        this.retrieveServices().forEach(this::updateService);
    }

    private void updateBotUsers() {
        LOG.info(String.format("Updating bot users in case of an update on the JSON schema: [%s]", this.secretManager.getSecretsManagerProvider().value()));
        this.retrieveBotUsers().forEach(this::updateBotUser);
    }

    private void updateIngestionPipelines() {
        LOG.info(String.format("Updating bot users in case of an update on the JSON schema: [%s]", this.secretManager.getSecretsManagerProvider().value()));
        this.retrieveIngestionPipelines().forEach(this::updateIngestionPipelines);
    }

    private void updateService(ServiceEntityInterface serviceEntityInterface) {
        ServiceEntityRepository<?, ?> repository = this.connectionTypeRepositoriesMap.get(serviceEntityInterface.getConnection().getClass());
        try {
            ServiceEntityInterface service = (ServiceEntityInterface)repository.dao.findEntityById(serviceEntityInterface.getId());
            service.getConnection().setConfig(this.oldSecretManager.encryptOrDecryptServiceConnectionConfig(service.getConnection().getConfig(), service.getServiceType().value(), service.getName(), repository.getServiceType(), false));
            service.getConnection().setConfig(this.secretManager.encryptOrDecryptServiceConnectionConfig(service.getConnection().getConfig(), service.getServiceType().value(), service.getName(), repository.getServiceType(), true));
            repository.dao.update((EntityInterface)service);
        }
        catch (IOException e) {
            throw new SecretsManagerUpdateException(e.getMessage(), e.getCause());
        }
    }

    private List<ServiceEntityInterface> retrieveServices() {
        return this.connectionTypeRepositoriesMap.values().stream().map(this::retrieveServices).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<ServiceEntityInterface> retrieveServices(ServiceEntityRepository<?, ?> serviceEntityRepository) {
        try {
            return serviceEntityRepository.listAfter(null, EntityUtil.Fields.EMPTY_FIELDS, new ListFilter(), serviceEntityRepository.dao.listCount(new ListFilter()), null).getData().stream().map(ServiceEntityInterface.class::cast).filter(service -> !Objects.isNull(service.getConnection()) && !Objects.isNull(service.getConnection().getConfig())).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new SecretsManagerUpdateException(e.getMessage(), e.getCause());
        }
    }

    private Map<Class<? extends ServiceConnectionEntityInterface>, ServiceEntityRepository<?, ?>> retrieveConnectionTypeRepositoriesMap() {
        Map<Class<ServiceConnectionEntityInterface>, ServiceEntityRepository<?, ?>> connectionTypeRepositoriesMap = CollectionRegistry.getInstance().getCollectionMap().values().stream().map(this::retrieveServiceRepository).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toMap(ServiceEntityRepository::getServiceConnectionClass, Function.identity()));
        if (connectionTypeRepositoriesMap.isEmpty()) {
            throw new SecretsManagerUpdateException("Unexpected error: ServiceRepository not found.");
        }
        return connectionTypeRepositoriesMap;
    }

    private Optional<ServiceEntityRepository<?, ?>> retrieveServiceRepository(CollectionRegistry.CollectionDetails collectionDetails) {
        Class<?> collectionDetailsClass = this.extractCollectionDetailsClass(collectionDetails);
        if (ServiceEntityResource.class.isAssignableFrom(collectionDetailsClass)) {
            return Optional.of(((ServiceEntityResource)collectionDetails.getResource()).getServiceEntityRepository());
        }
        return Optional.empty();
    }

    private Class<?> extractCollectionDetailsClass(CollectionRegistry.CollectionDetails collectionDetails) {
        Class<?> collectionDetailsClass;
        try {
            collectionDetailsClass = Class.forName(collectionDetails.getResourceClass());
        }
        catch (ClassNotFoundException e) {
            throw new SecretsManagerUpdateException(e.getMessage(), e.getCause());
        }
        return collectionDetailsClass;
    }

    private List<User> retrieveBotUsers() {
        try {
            return this.userRepository.listAfter(null, new EntityUtil.Fields(List.of("authenticationMechanism")), new ListFilter(), this.userRepository.dao.listCount(new ListFilter()), null).getData().stream().filter(user -> Boolean.TRUE.equals(user.getIsBot())).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new SecretsManagerUpdateException(e.getMessage(), e.getCause());
        }
    }

    private void updateBotUser(User botUser) {
        try {
            User user = (User)this.userRepository.dao.findEntityById(botUser.getId());
            this.oldSecretManager.encryptOrDecryptAuthenticationMechanism(botUser.getName(), user.getAuthenticationMechanism(), false);
            this.secretManager.encryptOrDecryptAuthenticationMechanism(botUser.getName(), user.getAuthenticationMechanism(), true);
            this.userRepository.dao.update((EntityInterface)user);
        }
        catch (IOException e) {
            throw new SecretsManagerUpdateException(e.getMessage(), e.getCause());
        }
    }

    private List<IngestionPipeline> retrieveIngestionPipelines() {
        try {
            return this.ingestionPipelineRepository.listAfter(null, EntityUtil.Fields.EMPTY_FIELDS, new ListFilter(), this.ingestionPipelineRepository.dao.listCount(new ListFilter()), null).getData();
        }
        catch (IOException e) {
            throw new SecretsManagerUpdateException(e.getMessage(), e.getCause());
        }
    }

    private void updateIngestionPipelines(IngestionPipeline ingestionPipeline) {
        try {
            IngestionPipeline ingestion = (IngestionPipeline)this.ingestionPipelineRepository.dao.findEntityById(ingestionPipeline.getId());
            this.oldSecretManager.encryptOrDecryptIngestionPipeline(ingestionPipeline, false);
            this.secretManager.encryptOrDecryptIngestionPipeline(ingestionPipeline, true);
            this.ingestionPipelineRepository.dao.update((EntityInterface)ingestion);
        }
        catch (IOException e) {
            throw new SecretsManagerUpdateException(e.getMessage(), e.getCause());
        }
    }
}

