/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.security.auth;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckForNull;
import org.openmetadata.schema.TokenInterface;
import org.openmetadata.schema.auth.PersonalAccessToken;
import org.openmetadata.schema.auth.TokenType;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.type.Include;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.TokenRepository;
import org.openmetadata.service.jdbi3.UserRepository;
import org.openmetadata.service.util.EntityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserTokenCache {
    private static final Logger LOG = LoggerFactory.getLogger(UserTokenCache.class);
    private static UserTokenCache INSTANCE;
    private static LoadingCache<String, HashSet<String>> USER_TOKEN_CACHE;
    private static volatile boolean INITIALIZED;
    private static TokenRepository tokenRepository;

    public static void initialize(CollectionDAO dao) {
        if (!INITIALIZED) {
            USER_TOKEN_CACHE = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(2L, TimeUnit.MINUTES).build((CacheLoader)new UserTokenLoader());
            tokenRepository = new TokenRepository(dao);
            INSTANCE = new UserTokenCache();
            INITIALIZED = true;
            LOG.info("User Token cache is initialized");
        } else {
            LOG.info("User Token cache is already initialized");
        }
    }

    public HashSet<String> getToken(String userName) {
        try {
            return (HashSet)USER_TOKEN_CACHE.get((Object)userName);
        }
        catch (UncheckedExecutionException | ExecutionException ex) {
            return null;
        }
    }

    public void invalidateToken(String userName) {
        try {
            USER_TOKEN_CACHE.invalidate((Object)userName);
        }
        catch (Exception ex) {
            LOG.error("Failed to invalidate User token cache for User {}", (Object)userName, (Object)ex);
        }
    }

    public static UserTokenCache getInstance() {
        return INSTANCE;
    }

    static {
        INITIALIZED = false;
    }

    static class UserTokenLoader
    extends CacheLoader<String, HashSet<String>> {
        UserTokenLoader() {
        }

        public HashSet<String> load(@CheckForNull String userName) throws IOException {
            HashSet<String> result = new HashSet<String>();
            UserRepository userRepository = (UserRepository)Entity.getEntityRepository("user");
            User user = (User)userRepository.getByName(null, userName, new EntityUtil.Fields(List.of("authenticationMechanism")), Include.NON_DELETED);
            List<TokenInterface> tokens = tokenRepository.findByUserIdAndType(user.getId().toString(), TokenType.PERSONAL_ACCESS_TOKEN.value());
            tokens.forEach(t -> result.add(((PersonalAccessToken)t).getJwtToken()));
            return result;
        }
    }
}

