/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.security.policyevaluator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import lombok.NonNull;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.MetadataOperation;
import org.openmetadata.schema.type.Permission;
import org.openmetadata.schema.type.ResourceDescriptor;
import org.openmetadata.schema.type.ResourcePermission;
import org.openmetadata.service.ResourceRegistry;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.security.AuthorizationException;
import org.openmetadata.service.security.policyevaluator.CompiledRule;
import org.openmetadata.service.security.policyevaluator.OperationContext;
import org.openmetadata.service.security.policyevaluator.ResourceContextInterface;
import org.openmetadata.service.security.policyevaluator.SubjectContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyEvaluator {
    private static final Logger LOG = LoggerFactory.getLogger(PolicyEvaluator.class);

    private PolicyEvaluator() {
    }

    public static void hasPermission(@NonNull SubjectContext subjectContext, @NonNull ResourceContextInterface resourceContext, @NonNull OperationContext operationContext) throws IOException {
        if (subjectContext == null) {
            throw new NullPointerException("subjectContext is marked non-null but is null");
        }
        if (resourceContext == null) {
            throw new NullPointerException("resourceContext is marked non-null but is null");
        }
        if (operationContext == null) {
            throw new NullPointerException("operationContext is marked non-null but is null");
        }
        PolicyEvaluator.evaluateDenySubjectPolicies(subjectContext, resourceContext, operationContext);
        PolicyEvaluator.evaluateAllowSubjectPolicies(subjectContext, resourceContext, operationContext);
        if (!operationContext.getOperations().isEmpty()) {
            throw new AuthorizationException(CatalogExceptionMessage.permissionNotAllowed(subjectContext.getUser().getName(), operationContext.getOperations()));
        }
    }

    private static void evaluateDenySubjectPolicies(SubjectContext subjectContext, ResourceContextInterface resourceContext, OperationContext operationContext) throws IOException {
        Iterator<SubjectContext.PolicyContext> policyIterator = subjectContext.getPolicies(resourceContext.getOwner());
        PolicyEvaluator.evaluatePolicies(policyIterator, subjectContext, resourceContext, operationContext, true);
    }

    private static void evaluateAllowSubjectPolicies(SubjectContext subjectContext, ResourceContextInterface resourceContext, OperationContext operationContext) throws IOException {
        Iterator<SubjectContext.PolicyContext> policyIterator = subjectContext.getPolicies(resourceContext.getOwner());
        PolicyEvaluator.evaluatePolicies(policyIterator, subjectContext, resourceContext, operationContext, false);
    }

    private static void evaluatePolicies(Iterator<SubjectContext.PolicyContext> policies, SubjectContext subjectContext, ResourceContextInterface resourceContext, OperationContext operationContext, boolean evaluateDeny) {
        while (policies.hasNext() && !operationContext.getOperations().isEmpty()) {
            SubjectContext.PolicyContext context = policies.next();
            for (CompiledRule rule : context.getRules()) {
                LOG.debug("evaluating policy for {} {}:{}:{}", new Object[]{evaluateDeny ? "deny" : "allow", context.getRoleName(), context.getPolicyName(), rule.getName()});
                if (evaluateDeny) {
                    rule.evaluateDenyRule(operationContext, subjectContext, resourceContext, context);
                    continue;
                }
                rule.evaluateAllowRule(operationContext, subjectContext, resourceContext, context);
            }
        }
    }

    public static List<ResourcePermission> listPermission(@NonNull SubjectContext subjectContext) {
        if (subjectContext == null) {
            throw new NullPointerException("subjectContext is marked non-null but is null");
        }
        Map<String, ResourcePermission> resourcePermissionMap = PolicyEvaluator.initResourcePermissions();
        Iterator<SubjectContext.PolicyContext> policies = subjectContext.getPolicies(null);
        while (policies.hasNext()) {
            SubjectContext.PolicyContext policyContext = policies.next();
            for (CompiledRule rule : policyContext.getRules()) {
                LOG.debug("evaluating {}:{}:{}\n", new Object[]{policyContext.getRoleName(), policyContext.getPolicyName(), rule.getName()});
                rule.evaluatePermission(resourcePermissionMap, policyContext);
            }
        }
        return PolicyEvaluator.trimResourcePermissions(new ArrayList<ResourcePermission>(resourcePermissionMap.values()));
    }

    public static List<ResourcePermission> listPermission(@NonNull List<EntityReference> policies) {
        if (policies == null) {
            throw new NullPointerException("policies is marked non-null but is null");
        }
        Map<String, ResourcePermission> resourcePermissionMap = PolicyEvaluator.initResourcePermissions();
        SubjectContext.PolicyIterator policyIterator = new SubjectContext.PolicyIterator("", "", null, policies);
        while (policyIterator.hasNext()) {
            SubjectContext.PolicyContext policyContext = policyIterator.next();
            for (CompiledRule rule : policyContext.getRules()) {
                LOG.debug("Evaluating {}:{}:{}\n", new Object[]{policyContext.getRoleName(), policyContext.getPolicyName(), rule.getName()});
                rule.evaluatePermission(resourcePermissionMap, policyContext);
            }
        }
        return PolicyEvaluator.trimResourcePermissions(new ArrayList<ResourcePermission>(resourcePermissionMap.values()));
    }

    public static ResourcePermission getPermission(@NonNull SubjectContext subjectContext, String resourceType) {
        if (subjectContext == null) {
            throw new NullPointerException("subjectContext is marked non-null but is null");
        }
        ResourcePermission resourcePermission = PolicyEvaluator.getResourcePermission(resourceType, Permission.Access.NOT_ALLOW);
        Iterator<SubjectContext.PolicyContext> policies = subjectContext.getPolicies(null);
        while (policies.hasNext()) {
            SubjectContext.PolicyContext policyContext = policies.next();
            for (CompiledRule rule : policyContext.getRules()) {
                LOG.debug("evaluating {}:{}:{}\n", new Object[]{policyContext.getRoleName(), policyContext.getPolicyName(), rule.getName()});
                rule.evaluatePermission(resourceType, resourcePermission, policyContext);
            }
        }
        return PolicyEvaluator.trimResourcePermission(resourcePermission);
    }

    public static ResourcePermission getPermission(@NonNull SubjectContext subjectContext, ResourceContextInterface resourceContext) throws IOException {
        if (subjectContext == null) {
            throw new NullPointerException("subjectContext is marked non-null but is null");
        }
        ResourcePermission resourcePermission = PolicyEvaluator.getResourcePermission(resourceContext.getResource(), Permission.Access.NOT_ALLOW);
        Iterator<SubjectContext.PolicyContext> policies = subjectContext.getPolicies(resourceContext.getOwner());
        while (policies.hasNext()) {
            SubjectContext.PolicyContext policyContext = policies.next();
            for (CompiledRule rule : policyContext.getRules()) {
                LOG.debug("evaluating {}:{}:{}\n", new Object[]{policyContext.getRoleName(), policyContext.getPolicyName(), rule.getName()});
                rule.evaluatePermission(subjectContext, resourceContext, resourcePermission, policyContext);
            }
        }
        return PolicyEvaluator.trimResourcePermission(resourcePermission);
    }

    public static List<ResourcePermission> getResourcePermissions(Permission.Access access) {
        ArrayList<ResourcePermission> resourcePermissions = new ArrayList<ResourcePermission>();
        for (ResourceDescriptor rd : ResourceRegistry.listResourceDescriptors()) {
            ArrayList<Permission> permissions = new ArrayList<Permission>();
            for (MetadataOperation operation : rd.getOperations()) {
                permissions.add(new Permission().withOperation(operation).withAccess(access));
            }
            ResourcePermission resourcePermission = new ResourcePermission().withResource(rd.getName()).withPermissions(permissions);
            resourcePermissions.add(resourcePermission);
        }
        return PolicyEvaluator.trimResourcePermissions(resourcePermissions);
    }

    public static ResourcePermission getResourcePermission(String resource, Permission.Access access) {
        ResourceDescriptor rd = ResourceRegistry.getResourceDescriptor(resource);
        ArrayList<Permission> permissions = new ArrayList<Permission>();
        for (MetadataOperation operation : rd.getOperations()) {
            permissions.add(new Permission().withOperation(operation).withAccess(access));
        }
        return PolicyEvaluator.trimResourcePermission(new ResourcePermission().withResource(rd.getName()).withPermissions(permissions));
    }

    public static Map<String, ResourcePermission> initResourcePermissions() {
        List<ResourcePermission> resourcePermissions = PolicyEvaluator.getResourcePermissions(Permission.Access.NOT_ALLOW);
        HashMap<String, ResourcePermission> resourcePermissionMap = new HashMap<String, ResourcePermission>();
        resourcePermissions.forEach(rp -> resourcePermissionMap.put(rp.getResource(), (ResourcePermission)rp));
        return resourcePermissionMap;
    }

    public static List<Permission> trimPermissions(List<Permission> permissions) {
        boolean viewAllPermission = false;
        boolean editAllPermission = false;
        for (Permission p : permissions) {
            if (p.getOperation().equals((Object)MetadataOperation.VIEW_ALL) && (p.getAccess().equals((Object)Permission.Access.ALLOW) || p.getAccess().equals((Object)Permission.Access.DENY))) {
                viewAllPermission = true;
            }
            if (!p.getOperation().equals((Object)MetadataOperation.EDIT_ALL) || !p.getAccess().equals((Object)Permission.Access.ALLOW) && !p.getAccess().equals((Object)Permission.Access.DENY)) continue;
            editAllPermission = true;
        }
        ListIterator<Permission> permissionIterator = permissions.listIterator();
        while (permissionIterator.hasNext()) {
            Permission permission = (Permission)permissionIterator.next();
            if (viewAllPermission && permission.getOperation() != MetadataOperation.VIEW_ALL && permission.getOperation().value().startsWith("View")) {
                permissionIterator.remove();
                continue;
            }
            if (!editAllPermission || permission.getOperation() == MetadataOperation.EDIT_ALL || !permission.getOperation().value().startsWith("Edit")) continue;
            permissionIterator.remove();
        }
        return permissions;
    }

    public static ResourcePermission trimResourcePermission(ResourcePermission resourcePermission) {
        return resourcePermission.withPermissions(PolicyEvaluator.trimPermissions(resourcePermission.getPermissions()));
    }

    public static List<ResourcePermission> trimResourcePermissions(List<ResourcePermission> resourcePermissions) {
        for (ResourcePermission resourcePermission : resourcePermissions) {
            PolicyEvaluator.trimResourcePermission(resourcePermission);
        }
        return resourcePermissions;
    }
}

