/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.security.policyevaluator;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import lombok.NonNull;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.entity.teams.Team;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.jdbi3.TeamRepository;
import org.openmetadata.service.jdbi3.UserRepository;
import org.openmetadata.service.security.policyevaluator.SubjectContext;
import org.openmetadata.service.util.EntityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectCache {
    private static final Logger LOG = LoggerFactory.getLogger(SubjectCache.class);
    private static SubjectCache INSTANCE;
    private static volatile boolean INITIALIZED;
    protected static LoadingCache<String, SubjectContext> USER_CACHE;
    protected static LoadingCache<UUID, SubjectContext> USER_CACHE_WIH_ID;
    protected static LoadingCache<UUID, Team> TEAM_CACHE;
    protected static UserRepository USER_REPOSITORY;
    protected static EntityUtil.Fields USER_FIELDS;
    protected static TeamRepository TEAM_REPOSITORY;
    protected static EntityUtil.Fields TEAM_FIELDS;

    public static void initialize() {
        if (!INITIALIZED) {
            USER_CACHE = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(3L, TimeUnit.MINUTES).build((CacheLoader)new UserLoader());
            USER_CACHE_WIH_ID = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(3L, TimeUnit.MINUTES).build((CacheLoader)new UserLoaderWithId());
            TEAM_CACHE = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(3L, TimeUnit.MINUTES).build((CacheLoader)new TeamLoader());
            USER_REPOSITORY = (UserRepository)Entity.getEntityRepository("user");
            USER_FIELDS = USER_REPOSITORY.getFields("roles, teams, isAdmin");
            TEAM_REPOSITORY = (TeamRepository)Entity.getEntityRepository("team");
            TEAM_FIELDS = TEAM_REPOSITORY.getFields("defaultRoles, policies, parents");
            INSTANCE = new SubjectCache();
            INITIALIZED = true;
            LOG.info("Subject cache is initialized");
        } else {
            LOG.info("Subject cache is already initialized");
        }
    }

    public static SubjectCache getInstance() {
        return INSTANCE;
    }

    public SubjectContext getSubjectContext(String userName) throws EntityNotFoundException {
        try {
            return (SubjectContext)USER_CACHE.get((Object)userName);
        }
        catch (UncheckedExecutionException | ExecutionException ex) {
            throw new EntityNotFoundException(ex.getMessage());
        }
    }

    public SubjectContext getSubjectContext(UUID userId) throws EntityNotFoundException {
        try {
            return (SubjectContext)USER_CACHE_WIH_ID.get((Object)userId);
        }
        catch (UncheckedExecutionException | ExecutionException ex) {
            throw new EntityNotFoundException(ex.getMessage());
        }
    }

    public User getUser(String userName) throws EntityNotFoundException {
        try {
            return ((SubjectContext)USER_CACHE.get((Object)userName)).getUser();
        }
        catch (UncheckedExecutionException | ExecutionException ex) {
            return null;
        }
    }

    public Team getTeam(UUID teamId) throws EntityNotFoundException {
        try {
            return (Team)TEAM_CACHE.get((Object)teamId);
        }
        catch (UncheckedExecutionException | ExecutionException ex) {
            return null;
        }
    }

    public boolean isInTeam(String parentTeam, EntityReference team) {
        Stack<EntityReference> stack = new Stack<EntityReference>();
        stack.push(team);
        while (!stack.empty()) {
            Team parent = this.getTeam(((EntityReference)stack.pop()).getId());
            if (parent.getName().equals(parentTeam)) {
                return true;
            }
            CommonUtil.listOrEmpty((List)parent.getParents()).forEach(stack::push);
        }
        return false;
    }

    public boolean hasRole(User user, String role) {
        Stack stack = new Stack();
        if (SubjectCache.hasRole(user.getRoles(), role)) {
            return true;
        }
        CommonUtil.listOrEmpty((List)user.getTeams()).forEach(stack::push);
        while (!stack.empty()) {
            Team parent = this.getTeam(((EntityReference)stack.pop()).getId());
            if (SubjectCache.hasRole(parent.getDefaultRoles(), role)) {
                return true;
            }
            CommonUtil.listOrEmpty((List)parent.getParents()).forEach(stack::push);
        }
        return false;
    }

    private static boolean hasRole(List<EntityReference> userRoles, String expectedRole) {
        return CommonUtil.listOrEmpty(userRoles).stream().anyMatch(userRole -> userRole.getName().equals(expectedRole));
    }

    public static void cleanUp() {
        LOG.info("Subject cache is cleaned up");
        USER_CACHE.invalidateAll();
        TEAM_CACHE.invalidateAll();
        INITIALIZED = false;
    }

    public void invalidateUser(String userName) {
        try {
            USER_CACHE.invalidate((Object)userName);
        }
        catch (Exception ex) {
            LOG.error("Failed to invalidate cache for user {}", (Object)userName, (Object)ex);
        }
    }

    public void invalidateTeam(UUID teamId) {
        try {
            TEAM_CACHE.invalidate((Object)teamId);
        }
        catch (Exception ex) {
            LOG.error("Failed to invalidate cache for team {}", (Object)teamId, (Object)ex);
        }
    }

    public List<EntityReference> getRolesForTeams(List<EntityReference> teams) {
        ArrayList<EntityReference> roles = new ArrayList<EntityReference>();
        for (EntityReference teamRef : CommonUtil.listOrEmpty(teams)) {
            Team team = this.getTeam(teamRef.getId());
            if (team == null) continue;
            roles.addAll(team.getDefaultRoles());
            roles.addAll(this.getRolesForTeams(team.getParents()));
        }
        return roles.stream().distinct().collect(Collectors.toList());
    }

    static {
        INITIALIZED = false;
    }

    static class TeamLoader
    extends CacheLoader<UUID, Team> {
        TeamLoader() {
        }

        public Team load(@NonNull UUID teamId) throws IOException {
            if (teamId == null) {
                throw new NullPointerException("teamId is marked non-null but is null");
            }
            Team team = (Team)TEAM_REPOSITORY.get(null, teamId, TEAM_FIELDS);
            LOG.info("Loaded team {}:{}", (Object)team.getName(), (Object)team.getId());
            return team;
        }
    }

    static class UserLoaderWithId
    extends CacheLoader<UUID, SubjectContext> {
        UserLoaderWithId() {
        }

        public SubjectContext load(@CheckForNull UUID uid) throws IOException {
            User user = (User)USER_REPOSITORY.get(null, uid, USER_FIELDS);
            LOG.info("Loaded user {}:{}", (Object)user.getName(), (Object)user.getId());
            return new SubjectContext(user);
        }
    }

    static class UserLoader
    extends CacheLoader<String, SubjectContext> {
        UserLoader() {
        }

        public SubjectContext load(@CheckForNull String userName) throws IOException {
            User user = (User)USER_REPOSITORY.getByName(null, userName, USER_FIELDS);
            LOG.info("Loaded user {}:{}", (Object)user.getName(), (Object)user.getId());
            return new SubjectContext(user);
        }
    }
}

