/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.security.saml;

import com.onelogin.saml2.Auth;
import com.onelogin.saml2.settings.Saml2Settings;
import java.util.List;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openmetadata.service.security.saml.SamlSettingsHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(value={"/api/v1/saml/metadata"})
public class SamlMetadataServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(SamlMetadataServlet.class);

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
        Auth auth = new Auth(SamlSettingsHolder.getInstance().getSaml2Settings(), req, resp);
        Saml2Settings settings = auth.getSettings();
        String metadata = settings.getSPMetadata();
        List errors = Saml2Settings.validateMetadata((String)metadata);
        if (errors.isEmpty()) {
            resp.getOutputStream().println(metadata);
        } else {
            resp.setContentType("text/html; charset=UTF-8");
            for (String error : errors) {
                resp.getOutputStream().println("<p>" + error + "</p>");
            }
        }
    }
}

