/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.util;

import at.favre.lib.crypto.bcrypt.BCrypt;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.openmetadata.api.configuration.airflow.AuthConfiguration;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.api.configuration.pipelineServiceClient.PipelineServiceClientConfiguration;
import org.openmetadata.schema.auth.BasicAuthMechanism;
import org.openmetadata.schema.auth.JWTAuthMechanism;
import org.openmetadata.schema.auth.JWTTokenExpiry;
import org.openmetadata.schema.auth.SSOAuthMechanism;
import org.openmetadata.schema.entity.teams.AuthenticationMechanism;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.security.client.OpenMetadataJWTClientConfig;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.service.Entity;
import org.openmetadata.service.OpenMetadataApplicationConfig;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.jdbi3.UserRepository;
import org.openmetadata.service.resources.teams.RoleResource;
import org.openmetadata.service.security.jwt.JWTTokenGenerator;
import org.openmetadata.service.util.EmailUtil;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.PasswordUtil;
import org.openmetadata.service.util.RestUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UserUtil {
    private static final Logger LOG = LoggerFactory.getLogger(UserUtil.class);
    private static final String COLON_DELIMITER = ":";

    public static void handleBasicAuth(Set<String> adminUsers, String domain) {
        try {
            for (String adminUser : adminUsers) {
                if (adminUser.contains(COLON_DELIMITER)) {
                    String[] tokens = adminUser.split(COLON_DELIMITER);
                    UserUtil.addUserForBasicAuth(tokens[0], tokens[1], domain);
                    continue;
                }
                boolean isDefaultAdmin = adminUser.equals("admin");
                String token = PasswordUtil.generateRandomPassword();
                if (isDefaultAdmin) {
                    token = "admin";
                }
                UserUtil.addUserForBasicAuth(adminUser, token, domain);
            }
        }
        catch (IOException e) {
            LOG.error("Failed in Basic Auth Setup. Reason : {}", (Object)e.getMessage());
        }
    }

    public static void addUserForBasicAuth(String username, String pwd, String domain) throws IOException {
        UserRepository userRepository = (UserRepository)Entity.getEntityRepository("user");
        try {
            List<String> fields = List.of("profile", "roles", "teams", "authenticationMechanism", "isEmailVerified");
            User originalUser = (User)userRepository.getByName(null, username, new EntityUtil.Fields(fields));
            if (originalUser.getAuthenticationMechanism() == null) {
                UserUtil.updateBasicAuthUser(originalUser, pwd);
            }
        }
        catch (EntityNotFoundException e) {
            User user = UserUtil.user(username, domain, username).withIsAdmin(Boolean.valueOf(true)).withIsEmailVerified(Boolean.valueOf(true));
            UserUtil.updateBasicAuthUser(user, pwd);
        }
    }

    private static void updateBasicAuthUser(User user, String pwd) {
        UserUtil.updateUserWithHashedPwd(user, pwd);
        UserUtil.addOrUpdateUser(user);
        EmailUtil.sendInviteMailToAdmin(user, pwd);
    }

    public static void updateUserWithHashedPwd(User user, String pwd) {
        String hashedPwd = BCrypt.withDefaults().hashToString(12, pwd.toCharArray());
        user.setAuthenticationMechanism(new AuthenticationMechanism().withAuthType(AuthenticationMechanism.AuthType.BASIC).withConfig((Object)new BasicAuthMechanism().withPassword(hashedPwd)));
    }

    public static void addUsers(Set<String> users, String domain, Boolean isAdmin) {
        for (String userName : users) {
            User user = UserUtil.user(userName, domain, userName).withIsAdmin(isAdmin);
            UserUtil.addOrUpdateUser(user);
        }
    }

    public static User addOrUpdateUser(User user) {
        UserRepository userRepository = (UserRepository)Entity.getEntityRepository("user");
        try {
            RestUtil.PutResponse<User> addedUser = userRepository.createOrUpdate(null, user);
            LOG.debug("Added user entry: {}", (Object)addedUser.getEntity().getName());
            return addedUser.getEntity();
        }
        catch (Exception exception) {
            LOG.debug("Caught exception", (Throwable)exception);
            user.setAuthenticationMechanism(null);
            LOG.debug("User entry: {} already exists.", (Object)user.getName());
            return null;
        }
    }

    public static User user(String name, String domain, String updatedBy) {
        return new User().withId(UUID.randomUUID()).withName(name).withFullyQualifiedName(name).withEmail(name + "@" + domain).withUpdatedBy(updatedBy).withUpdatedAt(Long.valueOf(System.currentTimeMillis())).withIsBot(Boolean.valueOf(false));
    }

    public static User addOrUpdateBotUser(User user, OpenMetadataApplicationConfig openMetadataApplicationConfig) {
        AuthenticationMechanism authMechanism;
        User originalUser = UserUtil.retrieveWithAuthMechanism(user);
        PipelineServiceClientConfiguration pipelineServiceClientConfiguration = openMetadataApplicationConfig.getPipelineServiceClientConfiguration();
        AuthenticationMechanism authenticationMechanism = authMechanism = originalUser != null ? originalUser.getAuthenticationMechanism() : null;
        if (UserUtil.authConfigPresent(pipelineServiceClientConfiguration) && authMechanism == null) {
            AuthConfiguration authConfig = pipelineServiceClientConfiguration.getAuthConfig();
            String currentAuthProvider = openMetadataApplicationConfig.getAuthenticationConfiguration().getProvider();
            if ("openmetadata".equals(pipelineServiceClientConfiguration.getAuthProvider()) && !"basic".equals(currentAuthProvider)) {
                OpenMetadataJWTClientConfig jwtClientConfig = authConfig.getOpenmetadata();
                authMechanism = UserUtil.buildAuthMechanism(AuthenticationMechanism.AuthType.JWT, UserUtil.buildJWTAuthMechanism(jwtClientConfig, user));
            } else if (!"basic".equals(currentAuthProvider)) {
                switch (currentAuthProvider) {
                    case "no-auth": {
                        break;
                    }
                    case "azure": {
                        authMechanism = UserUtil.buildAuthMechanism(AuthenticationMechanism.AuthType.SSO, UserUtil.buildAuthMechanismConfig(SSOAuthMechanism.SsoServiceType.AZURE, authConfig.getAzure()));
                        break;
                    }
                    case "google": {
                        authMechanism = UserUtil.buildAuthMechanism(AuthenticationMechanism.AuthType.SSO, UserUtil.buildAuthMechanismConfig(SSOAuthMechanism.SsoServiceType.GOOGLE, authConfig.getGoogle()));
                        break;
                    }
                    case "okta": {
                        authMechanism = UserUtil.buildAuthMechanism(AuthenticationMechanism.AuthType.SSO, UserUtil.buildAuthMechanismConfig(SSOAuthMechanism.SsoServiceType.OKTA, authConfig.getOkta()));
                        break;
                    }
                    case "auth0": {
                        authMechanism = UserUtil.buildAuthMechanism(AuthenticationMechanism.AuthType.SSO, UserUtil.buildAuthMechanismConfig(SSOAuthMechanism.SsoServiceType.AUTH_0, authConfig.getAuth0()));
                        break;
                    }
                    case "custom-oidc": {
                        authMechanism = UserUtil.buildAuthMechanism(AuthenticationMechanism.AuthType.SSO, UserUtil.buildAuthMechanismConfig(SSOAuthMechanism.SsoServiceType.CUSTOM_OIDC, authConfig.getCustomOidc()));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(String.format("Unexpected auth provider [%s] for bot [%s]", currentAuthProvider, user.getName()));
                    }
                }
            } else {
                authMechanism = UserUtil.buildAuthMechanism(AuthenticationMechanism.AuthType.JWT, UserUtil.buildJWTAuthMechanism(null, user));
            }
        } else if (authMechanism == null) {
            authMechanism = UserUtil.buildAuthMechanism(AuthenticationMechanism.AuthType.JWT, UserUtil.buildJWTAuthMechanism(null, user));
        }
        user.setAuthenticationMechanism(authMechanism);
        user.setDescription(user.getDescription());
        user.setDisplayName(user.getDisplayName());
        return UserUtil.addOrUpdateUser(user);
    }

    private static boolean authConfigPresent(PipelineServiceClientConfiguration pipelineServiceClientConfiguration) {
        return pipelineServiceClientConfiguration != null && pipelineServiceClientConfiguration.getAuthConfig() != null;
    }

    private static JWTAuthMechanism buildJWTAuthMechanism(OpenMetadataJWTClientConfig jwtClientConfig, User user) {
        return Objects.isNull(jwtClientConfig) || CommonUtil.nullOrEmpty((String)jwtClientConfig.getJwtToken()) ? JWTTokenGenerator.getInstance().generateJWTToken(user, JWTTokenExpiry.Unlimited) : new JWTAuthMechanism().withJWTToken(jwtClientConfig.getJwtToken()).withJWTTokenExpiry(JWTTokenExpiry.Unlimited);
    }

    private static SSOAuthMechanism buildAuthMechanismConfig(SSOAuthMechanism.SsoServiceType ssoServiceType, Object config) {
        return new SSOAuthMechanism().withSsoServiceType(ssoServiceType).withAuthConfig(config);
    }

    private static AuthenticationMechanism buildAuthMechanism(AuthenticationMechanism.AuthType authType, Object config) {
        return new AuthenticationMechanism().withAuthType(authType).withConfig(config);
    }

    private static User retrieveWithAuthMechanism(User user) {
        UserRepository userRepository = (UserRepository)Entity.getEntityRepository("user");
        try {
            return (User)userRepository.getByName(null, user.getName(), new EntityUtil.Fields(List.of("authenticationMechanism")));
        }
        catch (IOException | EntityNotFoundException e) {
            LOG.debug("Bot entity: {} does not exists.", (Object)user);
            return null;
        }
    }

    public static List<EntityReference> getRoleForBot(String botName) {
        String botRole;
        switch (botName) {
            case "ingestion-bot": {
                botRole = "IngestionBotRole";
                break;
            }
            case "quality-bot": {
                botRole = "QualityBotRole";
                break;
            }
            case "profiler-bot": {
                botRole = "ProfilerBotRole";
                break;
            }
            default: {
                throw new IllegalArgumentException("No role found for the bot " + botName);
            }
        }
        return CommonUtil.listOf((Object[])new EntityReference[]{RoleResource.getRole(botRole)});
    }
}

