/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.csv;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.ws.rs.core.Response;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.csv.CsvUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.schema.type.csv.CsvDocumentation;
import org.openmetadata.schema.type.csv.CsvErrorType;
import org.openmetadata.schema.type.csv.CsvFile;
import org.openmetadata.schema.type.csv.CsvHeader;
import org.openmetadata.schema.type.csv.CsvImportResult;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.RestUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EntityCsv<T extends EntityInterface> {
    private static final Logger LOG = LoggerFactory.getLogger(EntityCsv.class);
    public static final String IMPORT_STATUS_HEADER = "status";
    public static final String IMPORT_STATUS_DETAILS = "details";
    public static final String IMPORT_STATUS_SUCCESS = "success";
    public static final String IMPORT_STATUS_FAILED = "failure";
    public static final String ENTITY_CREATED = "Entity created";
    public static final String ENTITY_UPDATED = "Entity updated";
    private final String entityType;
    private final List<CsvHeader> csvHeaders;
    private final CsvImportResult importResult = new CsvImportResult();
    protected boolean processRecord;
    protected final Map<String, T> dryRunCreatedEntities = new HashMap<String, T>();
    private final String importedBy;

    protected EntityCsv(String entityType, List<CsvHeader> csvHeaders, String importedBy) {
        this.entityType = entityType;
        this.csvHeaders = csvHeaders;
        this.importedBy = importedBy;
    }

    public final CsvImportResult importCsv(String csv, boolean dryRun) throws IOException {
        this.importResult.withDryRun(Boolean.valueOf(dryRun));
        StringWriter writer = new StringWriter();
        CSVPrinter resultsPrinter = this.getResultsCsv(this.csvHeaders, writer);
        if (resultsPrinter == null) {
            return this.importResult;
        }
        Iterator<CSVRecord> records = this.parse(csv);
        if (records == null) {
            return this.importResult;
        }
        List<String> expectedHeaders = CsvUtil.getHeaders(this.csvHeaders);
        if (!this.validateHeaders(expectedHeaders, records.next())) {
            return this.importResult;
        }
        this.importResult.withNumberOfRowsPassed(Integer.valueOf(this.importResult.getNumberOfRowsPassed() + 1));
        while (records.hasNext()) {
            CSVRecord record = records.next();
            this.processRecord(resultsPrinter, expectedHeaders, record);
        }
        this.setFinalStatus();
        this.importResult.withImportResultsCsv(writer.toString());
        return this.importResult;
    }

    protected abstract T toEntity(CSVPrinter var1, CSVRecord var2) throws IOException;

    public final String exportCsv(List<T> entities) throws IOException {
        CsvFile csvFile = new CsvFile().withHeaders(this.csvHeaders);
        ArrayList<List<String>> records = new ArrayList<List<String>>();
        for (EntityInterface entity : entities) {
            records.add(this.toRecord(entity));
        }
        csvFile.withRecords(records);
        return CsvUtil.formatCsv(csvFile);
    }

    public static CsvDocumentation getCsvDocumentation(String entityType) {
        LOG.info("Initializing CSV documentation for entity {}", (Object)entityType);
        String path = String.format(".*json/data/%s/%sCsvDocumentation.json$", entityType, entityType);
        try {
            List<String> jsonDataFiles = EntityUtil.getJsonDataResources(path);
            String json = CommonUtil.getResourceAsStream((ClassLoader)EntityRepository.class.getClassLoader(), (String)jsonDataFiles.get(0));
            return JsonUtils.readValue(json, CsvDocumentation.class);
        }
        catch (IOException e) {
            LOG.error("FATAL - Failed to load CSV documentation for entity {} from the path {}", (Object)entityType, (Object)path);
            return null;
        }
    }

    protected abstract List<String> toRecord(T var1);

    public EntityReference getOwner(CSVPrinter printer, CSVRecord record, int fieldNumber) throws IOException {
        String owner = record.get(fieldNumber);
        if (CommonUtil.nullOrEmpty((String)owner)) {
            return null;
        }
        List<String> list = CsvUtil.fieldToStrings(owner);
        if (list.size() != 2) {
            this.importFailure(printer, EntityCsv.invalidOwner(fieldNumber), record);
        }
        return this.getEntityReference(printer, record, fieldNumber, list.get(0), list.get(1));
    }

    protected final Boolean getBoolean(CSVPrinter printer, CSVRecord record, int fieldNumber) throws IOException {
        String field = record.get(fieldNumber);
        if (CommonUtil.nullOrEmpty((String)field)) {
            return null;
        }
        if (field.equals(Boolean.TRUE.toString())) {
            return true;
        }
        if (field.equals(Boolean.FALSE.toString())) {
            return false;
        }
        this.importFailure(printer, EntityCsv.invalidBoolean(fieldNumber, field), record);
        this.processRecord = false;
        return false;
    }

    protected final EntityReference getEntityReference(CSVPrinter printer, CSVRecord record, int fieldNumber, String entityType) throws IOException {
        String fqn = record.get(fieldNumber);
        return this.getEntityReference(printer, record, fieldNumber, entityType, fqn);
    }

    protected EntityInterface getEntityByName(String entityType, String fqn) {
        EntityInterface entity;
        EntityInterface entityInterface = entity = entityType.equals(this.entityType) ? (EntityInterface)this.dryRunCreatedEntities.get(fqn) : null;
        if (entity == null) {
            EntityRepository<? extends EntityInterface> entityRepository = Entity.getEntityRepository(entityType);
            entity = entityRepository.findByNameOrNull(fqn, "", Include.NON_DELETED);
        }
        return entity;
    }

    protected final EntityReference getEntityReference(CSVPrinter printer, CSVRecord record, int fieldNumber, String entityType, String fqn) throws IOException {
        if (CommonUtil.nullOrEmpty((String)fqn)) {
            return null;
        }
        EntityInterface entity = this.getEntityByName(entityType, fqn);
        if (entity == null) {
            this.importFailure(printer, EntityCsv.entityNotFound(fieldNumber, fqn), record);
            this.processRecord = false;
            return null;
        }
        return entity.getEntityReference();
    }

    protected final List<EntityReference> getEntityReferences(CSVPrinter printer, CSVRecord record, int fieldNumber, String entityType) throws IOException {
        String fqns = record.get(fieldNumber);
        if (CommonUtil.nullOrEmpty((String)fqns)) {
            return null;
        }
        List fqnList = CommonUtil.listOrEmpty(CsvUtil.fieldToStrings(fqns));
        ArrayList<EntityReference> refs = new ArrayList<EntityReference>();
        for (String fqn : fqnList) {
            EntityReference ref = this.getEntityReference(printer, record, fieldNumber, entityType, fqn);
            if (!this.processRecord) {
                return null;
            }
            if (ref == null) continue;
            refs.add(ref);
        }
        return refs.isEmpty() ? null : refs;
    }

    protected final List<TagLabel> getTagLabels(CSVPrinter printer, CSVRecord record, int fieldNumber) throws IOException {
        List<EntityReference> refs = this.getEntityReferences(printer, record, fieldNumber, "tag");
        if (!this.processRecord || CommonUtil.nullOrEmpty(refs)) {
            return null;
        }
        ArrayList<TagLabel> tagLabels = new ArrayList<TagLabel>();
        for (EntityReference ref : refs) {
            tagLabels.add(new TagLabel().withSource(TagLabel.TagSource.CLASSIFICATION).withTagFQN(ref.getFullyQualifiedName()));
        }
        return tagLabels;
    }

    public static String[] getResultHeaders(List<CsvHeader> csvHeaders) {
        List importResultsCsvHeader = CommonUtil.listOf((Object[])new String[]{IMPORT_STATUS_HEADER, IMPORT_STATUS_DETAILS});
        importResultsCsvHeader.addAll(CsvUtil.getHeaders(csvHeaders));
        return importResultsCsvHeader.toArray(new String[0]);
    }

    private CSVPrinter getResultsCsv(List<CsvHeader> csvHeaders, StringWriter writer) {
        CSVFormat format = CSVFormat.Builder.create((CSVFormat)CSVFormat.DEFAULT).setHeader(EntityCsv.getResultHeaders(csvHeaders)).build();
        try {
            return new CSVPrinter((Appendable)writer, format);
        }
        catch (IOException e) {
            this.documentFailure(this.failed(e.getMessage(), CsvErrorType.UNKNOWN));
            return null;
        }
    }

    private Iterator<CSVRecord> parse(String csv) {
        StringReader in = new StringReader(csv);
        try {
            return CSVFormat.DEFAULT.parse((Reader)in).iterator();
        }
        catch (IOException e) {
            this.documentFailure(this.failed(e.getMessage(), CsvErrorType.PARSER_FAILURE));
            return null;
        }
    }

    private boolean validateHeaders(List<String> expectedHeaders, CSVRecord record) {
        this.importResult.withNumberOfRowsProcessed(Integer.valueOf((int)record.getRecordNumber()));
        if (expectedHeaders.equals(record.toList())) {
            return true;
        }
        this.importResult.withNumberOfRowsFailed(Integer.valueOf(1));
        this.documentFailure(EntityCsv.invalidHeader(CsvUtil.recordToString(expectedHeaders), CsvUtil.recordToString(record)));
        return false;
    }

    private void processRecord(CSVPrinter resultsPrinter, List<String> expectedHeader, CSVRecord record) throws IOException {
        this.processRecord = true;
        if (this.csvHeaders.size() != record.size()) {
            this.importFailure(resultsPrinter, EntityCsv.invalidFieldCount(expectedHeader.size(), record.size()), record);
            return;
        }
        ArrayList<String> errors = new ArrayList<String>();
        for (int i = 0; i < this.csvHeaders.size(); ++i) {
            String field = record.get(i);
            boolean fieldRequired = Boolean.TRUE.equals(this.csvHeaders.get(i).getRequired());
            if (!fieldRequired || !CommonUtil.nullOrEmpty((String)field)) continue;
            errors.add(EntityCsv.fieldRequired(i));
        }
        if (!errors.isEmpty()) {
            this.importFailure(resultsPrinter, String.join((CharSequence)";", errors), record);
            return;
        }
        T entity = this.toEntity(resultsPrinter, record);
        if (entity != null) {
            this.createEntity(resultsPrinter, record, entity);
        }
    }

    private void createEntity(CSVPrinter resultsPrinter, CSVRecord record, T entity) throws IOException {
        Response.Status responseStatus;
        entity.setId(UUID.randomUUID());
        entity.setUpdatedBy(this.importedBy);
        entity.setUpdatedAt(Long.valueOf(System.currentTimeMillis()));
        EntityRepository<? extends EntityInterface> repository = Entity.getEntityRepository(this.entityType);
        if (!this.importResult.getDryRun().booleanValue()) {
            try {
                repository.prepareInternal((EntityInterface)entity);
                RestUtil.PutResponse<? extends EntityInterface> response = repository.createOrUpdate(null, (EntityInterface)entity);
                responseStatus = response.getStatus();
            }
            catch (Exception ex) {
                this.importFailure(resultsPrinter, ex.getMessage(), record);
                return;
            }
        } else {
            repository.setFullyQualifiedName((EntityInterface)entity);
            responseStatus = repository.findByNameOrNull(entity.getFullyQualifiedName(), "", Include.NON_DELETED) == null ? Response.Status.CREATED : Response.Status.OK;
            this.dryRunCreatedEntities.put(entity.getFullyQualifiedName(), entity);
        }
        if (Response.Status.CREATED.equals((Object)responseStatus)) {
            this.importSuccess(resultsPrinter, record, ENTITY_CREATED);
        } else {
            this.importSuccess(resultsPrinter, record, ENTITY_UPDATED);
        }
    }

    public String failed(String exception, CsvErrorType errorType) {
        return String.format("#%s: Failed to parse the CSV filed - reason %s", errorType, exception);
    }

    public static String invalidHeader(String expected, String actual) {
        return String.format("#%s: Headers [%s] doesn't match [%s]", CsvErrorType.INVALID_HEADER, actual, expected);
    }

    public static String invalidFieldCount(int expectedFieldCount, int actualFieldCount) {
        return String.format("#%s: Field count %d does not match the expected field count of %d", CsvErrorType.INVALID_FIELD_COUNT, actualFieldCount, expectedFieldCount);
    }

    public static String fieldRequired(int field) {
        return String.format("#%s: Field %d is required", CsvErrorType.FIELD_REQUIRED, field + 1);
    }

    public static String invalidField(int field, String error) {
        return String.format("#%s: Field %d error - %s", CsvErrorType.INVALID_FIELD, field + 1, error);
    }

    public static String entityNotFound(int field, String fqn) {
        String error = String.format("Entity %s not found", fqn);
        return String.format("#%s: Field %d error - %s", CsvErrorType.INVALID_FIELD, field + 1, error);
    }

    public static String invalidOwner(int field) {
        String error = "Owner should be of format user;userName or team;teamName";
        return String.format("#%s: Field %d error - %s", CsvErrorType.INVALID_FIELD, field + 1, error);
    }

    public static String invalidBoolean(int field, String fieldValue) {
        String error = String.format("Field %s should be either 'true' of 'false'", fieldValue);
        return String.format("#%s: Field %d error - %s", CsvErrorType.INVALID_FIELD, field + 1, error);
    }

    private void documentFailure(String error) {
        this.importResult.withStatus(CsvImportResult.Status.ABORTED);
        this.importResult.withAbortReason(error);
    }

    private void importSuccess(CSVPrinter printer, CSVRecord inputRecord, String successDetails) throws IOException {
        List record = CommonUtil.listOf((Object[])new String[]{IMPORT_STATUS_SUCCESS, successDetails});
        record.addAll(inputRecord.toList());
        printer.printRecord((Iterable)record);
        this.importResult.withNumberOfRowsProcessed(Integer.valueOf((int)inputRecord.getRecordNumber()));
        this.importResult.withNumberOfRowsPassed(Integer.valueOf(this.importResult.getNumberOfRowsPassed() + 1));
    }

    protected void importFailure(CSVPrinter printer, String failedReason, CSVRecord inputRecord) throws IOException {
        List record = CommonUtil.listOf((Object[])new String[]{IMPORT_STATUS_FAILED, failedReason});
        record.addAll(inputRecord.toList());
        printer.printRecord((Iterable)record);
        this.importResult.withNumberOfRowsProcessed(Integer.valueOf((int)inputRecord.getRecordNumber()));
        this.importResult.withNumberOfRowsFailed(Integer.valueOf(this.importResult.getNumberOfRowsFailed() + 1));
        this.processRecord = false;
    }

    private void setFinalStatus() {
        CsvImportResult.Status status = this.importResult.getNumberOfRowsPassed().equals(this.importResult.getNumberOfRowsProcessed()) ? CsvImportResult.Status.SUCCESS : (this.importResult.getNumberOfRowsPassed() > 1 ? CsvImportResult.Status.PARTIAL_SUCCESS : CsvImportResult.Status.FAILURE);
        this.importResult.setStatus(status);
    }
}

