/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.elasticsearch;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.openmetadata.schema.type.Column;
import org.openmetadata.service.elasticsearch.ElasticSearchIndex;
import org.openmetadata.service.elasticsearch.FlattenColumn;
import org.openmetadata.service.util.FullyQualifiedName;

public interface ColumnIndex
extends ElasticSearchIndex {
    default public void parseColumns(List<Column> columns, List<FlattenColumn> flattenColumns, String parentColumn) {
        Optional<String> optParentColumn = Optional.ofNullable(parentColumn).filter(Predicate.not(String::isEmpty));
        List tags = new ArrayList();
        for (Column col : columns) {
            String columnName = col.getName();
            if (optParentColumn.isPresent()) {
                columnName = FullyQualifiedName.add(optParentColumn.get(), columnName);
            }
            if (col.getTags() != null) {
                tags = col.getTags();
            }
            FlattenColumn flattenColumn = FlattenColumn.builder().name(columnName).description(col.getDescription()).build();
            if (!tags.isEmpty()) {
                flattenColumn.tags = tags;
            }
            flattenColumns.add(flattenColumn);
            if (col.getChildren() == null) continue;
            this.parseColumns(col.getChildren(), flattenColumns, col.getName());
        }
    }
}

