/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.events.subscription.emailAlert;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.HashSet;
import java.util.Set;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.SubscriptionAction;
import org.openmetadata.schema.alert.type.EmailAlertConfig;
import org.openmetadata.schema.api.events.CreateEventSubscription;
import org.openmetadata.schema.entity.events.EventSubscription;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.service.events.errors.EventPublisherException;
import org.openmetadata.service.events.subscription.SubscriptionPublisher;
import org.openmetadata.service.events.subscription.emailAlert.EmailMessage;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.resources.events.EventResource;
import org.openmetadata.service.util.ChangeEventParser;
import org.openmetadata.service.util.EmailUtil;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.SubscriptionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailPublisher
extends SubscriptionPublisher {
    private static final Logger LOG = LoggerFactory.getLogger(EmailPublisher.class);
    private final EmailAlertConfig emailAlertConfig;
    private final CollectionDAO daoCollection;

    public EmailPublisher(EventSubscription eventSub, CollectionDAO dao) {
        super(eventSub, dao);
        if (eventSub.getSubscriptionType() != CreateEventSubscription.SubscriptionType.EMAIL) {
            throw new IllegalArgumentException("Email Alert Invoked with Illegal Type and Settings.");
        }
        this.emailAlertConfig = JsonUtils.convertValue(eventSub.getSubscriptionConfig(), EmailAlertConfig.class);
        this.daoCollection = dao;
    }

    @Override
    public void onStartDelegate() {
        LOG.info("Email Publisher Started");
    }

    @Override
    public void onShutdownDelegate() {
        LOG.info("Email Publisher Stopped");
    }

    @Override
    public void sendAlert(EventResource.EventList list) throws InterruptedException, JsonProcessingException {
        for (ChangeEvent event : list.getData()) {
            try {
                Set<String> receivers = this.buildReceiversList(event);
                EmailMessage emailMessage = ChangeEventParser.buildEmailMessage(event);
                for (String email : receivers) {
                    EmailUtil.sendChangeEventMail(email, emailMessage);
                }
                this.setSuccessStatus(System.currentTimeMillis());
            }
            catch (Exception e) {
                this.setErrorStatus(System.currentTimeMillis(), 500, e.getMessage());
                String message = CatalogExceptionMessage.eventPublisherFailedToPublish(CreateEventSubscription.SubscriptionType.EMAIL, event, e.getMessage());
                LOG.error(message);
                throw new EventPublisherException(message);
            }
        }
    }

    private Set<String> buildReceiversList(ChangeEvent changeEvent) {
        Set<String> receiverList = this.emailAlertConfig.getReceivers() == null ? new HashSet() : this.emailAlertConfig.getReceivers();
        EntityInterface entityInterface = (EntityInterface)changeEvent.getEntity();
        receiverList.addAll(SubscriptionUtil.buildReceiversListFromActions((SubscriptionAction)this.emailAlertConfig, CreateEventSubscription.SubscriptionType.EMAIL, this.daoCollection, entityInterface.getId(), changeEvent.getEntityType()));
        return receiverList;
    }
}

