/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.csv.CsvUtil;
import org.openmetadata.csv.EntityCsv;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.api.data.TermReference;
import org.openmetadata.schema.entity.data.Glossary;
import org.openmetadata.schema.entity.data.GlossaryTerm;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.ProviderType;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.schema.type.csv.CsvDocumentation;
import org.openmetadata.schema.type.csv.CsvHeader;
import org.openmetadata.schema.type.csv.CsvImportResult;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.jdbi3.GlossaryTermRepository;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlossaryRepository
extends EntityRepository<Glossary> {
    private static final Logger LOG = LoggerFactory.getLogger(GlossaryRepository.class);
    private static final String UPDATE_FIELDS = "owner,tags,reviewers";
    private static final String PATCH_FIELDS = "owner,tags,reviewers";

    public GlossaryRepository(CollectionDAO dao) {
        super("v1/glossaries/", "glossary", Glossary.class, dao.glossaryDAO(), dao, "owner,tags,reviewers", "owner,tags,reviewers", null);
    }

    @Override
    public Glossary setFields(Glossary glossary, EntityUtil.Fields fields) throws IOException {
        glossary.setTermCount(fields.contains("termCount") ? this.getTermCount(glossary) : null);
        glossary.setReviewers(fields.contains("reviewers") ? this.getReviewers(glossary) : null);
        return glossary.withUsageCount(fields.contains("usageCount") ? this.getUsageCount(glossary) : null);
    }

    @Override
    public void prepare(Glossary glossary) throws IOException {
        this.validateUsers(glossary.getReviewers());
    }

    @Override
    public void storeEntity(Glossary glossary, boolean update) throws IOException {
        List reviewers = glossary.getReviewers();
        glossary.withReviewers(null);
        this.store(glossary, update);
        glossary.withReviewers(reviewers);
    }

    @Override
    public void storeRelationships(Glossary glossary) {
        this.storeOwner(glossary, glossary.getOwner());
        this.applyTags(glossary);
        for (EntityReference reviewer : CommonUtil.listOrEmpty((List)glossary.getReviewers())) {
            this.addRelationship(reviewer.getId(), glossary.getId(), "user", "glossary", Relationship.REVIEWS);
        }
    }

    private Integer getUsageCount(Glossary glossary) {
        return this.daoCollection.tagUsageDAO().getTagCount(TagLabel.TagSource.GLOSSARY.ordinal(), glossary.getName());
    }

    private Integer getTermCount(Glossary glossary) {
        ListFilter filter = new ListFilter(Include.NON_DELETED).addQueryParam("parent", FullyQualifiedName.build(glossary.getName()));
        return this.daoCollection.glossaryTermDAO().listCount(filter);
    }

    @Override
    public EntityRepository.EntityUpdater getUpdater(Glossary original, Glossary updated, EntityRepository.Operation operation) {
        return new GlossaryUpdater(original, updated, operation);
    }

    @Override
    public String exportToCsv(String name, String user) throws IOException {
        Glossary glossary = (Glossary)this.getByName(null, name, EntityUtil.Fields.EMPTY_FIELDS);
        GlossaryTermRepository repository = (GlossaryTermRepository)Entity.getEntityRepository("glossaryTerm");
        ListFilter filter = new ListFilter(Include.NON_DELETED).addQueryParam("parent", name);
        List terms = repository.listAll(repository.getFields("owner,reviewers,tags,relatedTerms"), filter);
        terms.sort(Comparator.comparing(EntityInterface::getFullyQualifiedName));
        return new GlossaryCsv(glossary, user).exportCsv(terms);
    }

    @Override
    public CsvImportResult importFromCsv(String name, String csv, boolean dryRun, String user) throws IOException {
        Glossary glossary = (Glossary)this.getByName(null, name, EntityUtil.Fields.EMPTY_FIELDS);
        GlossaryCsv glossaryCsv = new GlossaryCsv(glossary, user);
        return glossaryCsv.importCsv(csv, dryRun);
    }

    private List<EntityReference> getReviewers(Glossary entity) throws IOException {
        List<CollectionDAO.EntityRelationshipRecord> ids = this.findFrom(entity.getId(), "glossary", Relationship.REVIEWS, "user");
        return EntityUtil.populateEntityReferences(ids, "user");
    }

    public class GlossaryUpdater
    extends EntityRepository.EntityUpdater {
        public GlossaryUpdater(Glossary original, Glossary updated, EntityRepository.Operation operation) {
            super((EntityRepository)GlossaryRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        public void entitySpecificUpdate() throws IOException {
            this.updateReviewers((Glossary)this.original, (Glossary)this.updated);
            this.updateName((Glossary)this.original, (Glossary)this.updated);
        }

        private void updateReviewers(Glossary origGlossary, Glossary updatedGlossary) throws JsonProcessingException {
            List origUsers = CommonUtil.listOrEmpty((List)origGlossary.getReviewers());
            List updatedUsers = CommonUtil.listOrEmpty((List)updatedGlossary.getReviewers());
            this.updateFromRelationships("reviewers", "user", origUsers, updatedUsers, Relationship.REVIEWS, "glossary", origGlossary.getId());
        }

        public void updateName(Glossary original, Glossary updated) throws IOException {
            if (!original.getName().equals(updated.getName())) {
                if (ProviderType.SYSTEM.equals((Object)original.getProvider())) {
                    throw new IllegalArgumentException(CatalogExceptionMessage.systemEntityRenameNotAllowed(original.getName(), GlossaryRepository.this.entityType));
                }
                LOG.info("Glossary name changed from {} to {}", (Object)original.getName(), (Object)updated.getName());
                GlossaryRepository.this.daoCollection.glossaryTermDAO().updateFqn(original.getName(), updated.getName());
                GlossaryRepository.this.daoCollection.tagUsageDAO().updateTagPrefix(TagLabel.TagSource.GLOSSARY.ordinal(), original.getName(), updated.getName());
                this.recordChange("name", original.getName(), updated.getName());
            }
        }
    }

    public static class GlossaryCsv
    extends EntityCsv<GlossaryTerm> {
        public static final CsvDocumentation DOCUMENTATION = GlossaryCsv.getCsvDocumentation("glossary");
        public static final List<CsvHeader> HEADERS = DOCUMENTATION.getHeaders();
        private final Glossary glossary;

        GlossaryCsv(Glossary glossary, String user) {
            super("glossaryTerm", DOCUMENTATION.getHeaders(), user);
            this.glossary = glossary;
        }

        @Override
        protected GlossaryTerm toEntity(CSVPrinter printer, CSVRecord record) throws IOException {
            GlossaryTerm glossaryTerm = new GlossaryTerm().withGlossary(this.glossary.getEntityReference());
            glossaryTerm.withParent(this.getEntityReference(printer, record, 0, "glossaryTerm"));
            if (!this.processRecord) {
                return null;
            }
            glossaryTerm.withName(record.get(1)).withDisplayName(record.get(2)).withDescription(record.get(3));
            glossaryTerm.withSynonyms(CsvUtil.fieldToStrings(record.get(4)));
            glossaryTerm.withRelatedTerms(this.getEntityReferences(printer, record, 5, "glossaryTerm"));
            if (!this.processRecord) {
                return null;
            }
            glossaryTerm.withReferences(this.getTermReferences(printer, record));
            if (!this.processRecord) {
                return null;
            }
            glossaryTerm.withTags(this.getTagLabels(printer, record, 7));
            if (!this.processRecord) {
                return null;
            }
            glossaryTerm.withReviewers(this.getEntityReferences(printer, record, 8, "user"));
            if (!this.processRecord) {
                return null;
            }
            glossaryTerm.withOwner(this.getOwner(printer, record, 9));
            glossaryTerm.withStatus(this.getTermStatus(printer, record));
            return glossaryTerm;
        }

        private List<TermReference> getTermReferences(CSVPrinter printer, CSVRecord record) throws IOException {
            String termRefs = record.get(6);
            if (CommonUtil.nullOrEmpty((String)termRefs)) {
                return null;
            }
            List<String> termRefList = CsvUtil.fieldToStrings(termRefs);
            if (termRefList.size() % 2 != 0) {
                this.importFailure(printer, GlossaryCsv.invalidField(6, "Term references should termName;endpoint"), record);
                this.processRecord = false;
                return null;
            }
            ArrayList<TermReference> list = new ArrayList<TermReference>();
            int i = 0;
            while (i < termRefList.size()) {
                list.add(new TermReference().withName(termRefList.get(i++)).withEndpoint(URI.create(termRefList.get(i++))));
            }
            return list;
        }

        private GlossaryTerm.Status getTermStatus(CSVPrinter printer, CSVRecord record) throws IOException {
            String termStatus = record.get(10);
            try {
                return CommonUtil.nullOrEmpty((String)termStatus) ? GlossaryTerm.Status.DRAFT : GlossaryTerm.Status.fromValue((String)termStatus);
            }
            catch (Exception ex) {
                this.importFailure(printer, GlossaryCsv.invalidField(10, String.format("Glossary term status %s is invalid", termStatus)), record);
                this.processRecord = false;
                return null;
            }
        }

        @Override
        protected List<String> toRecord(GlossaryTerm entity) {
            ArrayList<String> record = new ArrayList<String>();
            CsvUtil.addEntityReference(record, entity.getParent());
            CsvUtil.addField(record, entity.getName());
            CsvUtil.addField(record, entity.getDisplayName());
            CsvUtil.addField(record, entity.getDescription());
            CsvUtil.addFieldList(record, entity.getSynonyms());
            CsvUtil.addEntityReferences(record, entity.getRelatedTerms());
            CsvUtil.addField(record, this.termReferencesToRecord(entity.getReferences()));
            CsvUtil.addTagLabels(record, entity.getTags());
            CsvUtil.addEntityReferences(record, entity.getReviewers());
            CsvUtil.addOwner(record, entity.getOwner());
            CsvUtil.addField(record, entity.getStatus().value());
            return record;
        }

        private String termReferencesToRecord(List<TermReference> list) {
            return CommonUtil.nullOrEmpty(list) ? null : list.stream().map(termReference -> termReference.getName() + ";" + termReference.getEndpoint()).collect(Collectors.joining(";"));
        }
    }
}

