/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.io.IOException;
import org.openmetadata.schema.entity.data.Metrics;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;

public class MetricsRepository
extends EntityRepository<Metrics> {
    private static final String METRICS_UPDATE_FIELDS = "owner";

    public MetricsRepository(CollectionDAO dao) {
        super("/v1/metrics/", "metrics", Metrics.class, dao.metricsDAO(), dao, "", METRICS_UPDATE_FIELDS, null);
    }

    @Override
    public void setFullyQualifiedName(Metrics metrics) {
        metrics.setFullyQualifiedName(FullyQualifiedName.add(metrics.getService().getName(), metrics.getName()));
    }

    @Override
    public Metrics setFields(Metrics metrics, EntityUtil.Fields fields) throws IOException {
        metrics.setService(this.getContainer(metrics.getId()));
        return metrics.withUsageSummary(fields.contains("usageSummary") ? EntityUtil.getLatestUsage(this.daoCollection.usageDAO(), metrics.getId()) : null);
    }

    @Override
    public void prepare(Metrics metrics) throws IOException {
        metrics.setService(this.getService(metrics.getService()));
    }

    @Override
    public void storeEntity(Metrics metrics, boolean update) throws IOException {
        EntityReference service = metrics.getService();
        metrics.withService(null);
        this.store(metrics, update);
        metrics.withService(service);
    }

    @Override
    public void storeRelationships(Metrics metrics) {
        EntityReference service = metrics.getService();
        this.addRelationship(service.getId(), metrics.getId(), service.getType(), "metrics", Relationship.CONTAINS);
        this.storeOwner(metrics, metrics.getOwner());
        this.applyTags(metrics);
    }

    private EntityReference getService(EntityReference service) throws IOException {
        if (service.getType().equalsIgnoreCase("dashboardService")) {
            return this.daoCollection.dbServiceDAO().findEntityReferenceById(service.getId());
        }
        throw new IllegalArgumentException(CatalogExceptionMessage.invalidServiceEntity(service.getType(), "metrics", "dashboardService"));
    }
}

