/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.Query;
import org.openmetadata.schema.type.ChangeDescription;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.EventType;
import org.openmetadata.schema.type.FieldChange;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.QueryUtil;
import org.openmetadata.service.util.RestUtil;

public class QueryRepository
extends EntityRepository<Query> {
    private static final String QUERY_PATCH_FIELDS = "owner,tags,users,followers,query";
    private static final String QUERY_UPDATE_FIELDS = "owner,tags,users,votes,followers";

    public QueryRepository(CollectionDAO dao) {
        super("v1/queries/", "query", Query.class, dao.queryDAO(), dao, QUERY_PATCH_FIELDS, QUERY_UPDATE_FIELDS, null);
    }

    @Override
    public Query setFields(Query entity, EntityUtil.Fields fields) throws IOException {
        entity.setFollowers(fields.contains("followers") ? this.getFollowers(entity) : null);
        entity.setVotes(fields.contains("votes") ? this.getVotes(entity) : null);
        entity.setQueryUsedIn(fields.contains("queryUsedIn") ? this.getQueryUsage(entity) : null);
        entity.setUsers(fields.contains("users") ? this.getQueryUsers(entity) : null);
        return entity;
    }

    public List<EntityReference> getQueryUsage(Query queryEntity) throws IOException {
        if (queryEntity == null) {
            return Collections.emptyList();
        }
        List<CollectionDAO.EntityRelationshipRecord> records = this.findFrom(queryEntity.getId(), "query", Relationship.MENTIONED_IN, null);
        return EntityUtil.getEntityReferences(records);
    }

    public List<EntityReference> getQueryUsers(Query queryEntity) throws IOException {
        if (queryEntity == null) {
            return Collections.emptyList();
        }
        List<CollectionDAO.EntityRelationshipRecord> records = this.findFrom(queryEntity.getId(), "query", Relationship.USES, "user");
        return EntityUtil.populateEntityReferences(records, "user");
    }

    @Override
    public void prepare(Query entity) {
        if (CommonUtil.nullOrEmpty((String)entity.getName())) {
            String checkSum = QueryUtil.getCheckSum(entity.getQuery());
            entity.setChecksum(checkSum);
            entity.setName(checkSum);
        }
        entity.setUsers(EntityUtil.populateEntityReferences(entity.getUsers()));
    }

    @Override
    public void storeEntity(Query queryEntity, boolean update) throws IOException {
        EntityReference owner = queryEntity.getOwner();
        List queryUsage = queryEntity.getQueryUsedIn();
        List queryUsers = queryEntity.getUsers();
        queryEntity.withQueryUsedIn(null).withOwner(null).withFollowers(null).withUsers(null);
        this.store(queryEntity, update);
        queryEntity.withQueryUsedIn(queryUsage).withOwner(owner).withUsers(queryUsers);
    }

    @Override
    public void storeRelationships(Query queryEntity) {
        if (queryEntity.getUsers() != null) {
            for (EntityReference entityRef : queryEntity.getUsers()) {
                this.addRelationship(entityRef.getId(), queryEntity.getId(), "user", "query", Relationship.USES);
            }
        }
        if (queryEntity.getQueryUsedIn() != null) {
            for (EntityReference entityRef : queryEntity.getQueryUsedIn()) {
                this.addRelationship(entityRef.getId(), queryEntity.getId(), entityRef.getType(), "query", Relationship.MENTIONED_IN);
            }
        }
        this.storeOwner(queryEntity, queryEntity.getOwner());
        this.applyTags(queryEntity);
    }

    @Override
    public EntityRepository.EntityUpdater getUpdater(Query original, Query updated, EntityRepository.Operation operation) {
        return new QueryUpdater(original, updated, operation);
    }

    public RestUtil.PutResponse<?> addQueryUsage(UriInfo uriInfo, String updatedBy, UUID queryId, List<EntityReference> entityIds) throws IOException {
        Query query = (Query)Entity.getEntity("query", queryId, "queryUsedIn", Include.NON_DELETED);
        List oldValue = query.getQueryUsedIn();
        entityIds.forEach(entityRef -> this.addRelationship(entityRef.getId(), queryId, entityRef.getType(), "query", Relationship.MENTIONED_IN));
        this.setFieldsInternal(query, new EntityUtil.Fields((List<String>)this.allowedFields, "queryUsedIn"));
        Entity.withHref(uriInfo, query.getQueryUsedIn());
        ChangeEvent changeEvent = this.getQueryChangeEvent(updatedBy, "queryUsedIn", oldValue, query.getQueryUsedIn(), this.withHref(uriInfo, query));
        return new RestUtil.PutResponse(Response.Status.CREATED, changeEvent, "entityFieldsChanged");
    }

    public RestUtil.PutResponse<?> removeQueryUsedIn(UriInfo uriInfo, String updatedBy, UUID queryId, List<EntityReference> entityIds) throws IOException {
        Query query = (Query)Entity.getEntity("query", queryId, "queryUsedIn", Include.NON_DELETED);
        List oldValue = query.getQueryUsedIn();
        for (EntityReference ref : entityIds) {
            this.deleteRelationship(ref.getId(), ref.getType(), queryId, "query", Relationship.MENTIONED_IN);
        }
        this.setFieldsInternal(query, new EntityUtil.Fields((List<String>)this.allowedFields, "queryUsedIn"));
        Entity.withHref(uriInfo, query.getQueryUsedIn());
        ChangeEvent changeEvent = this.getQueryChangeEvent(updatedBy, "queryUsedIn", oldValue, query.getQueryUsedIn(), this.withHref(uriInfo, query));
        return new RestUtil.PutResponse(Response.Status.CREATED, changeEvent, "entityFieldsChanged");
    }

    private ChangeEvent getQueryChangeEvent(String updatedBy, String fieldUpdated, Object oldValue, Object newValue, Query updatedQuery) {
        FieldChange fieldChange = new FieldChange().withName(fieldUpdated).withNewValue(newValue).withOldValue(oldValue);
        ChangeDescription change = new ChangeDescription().withPreviousVersion(updatedQuery.getVersion());
        change.getFieldsUpdated().add(fieldChange);
        return new ChangeEvent().withEntity((Object)updatedQuery).withChangeDescription(change).withEventType(EventType.ENTITY_UPDATED).withEntityType(this.entityType).withEntityId(updatedQuery.getId()).withEntityFullyQualifiedName(updatedQuery.getFullyQualifiedName()).withUserName(updatedBy).withTimestamp(Long.valueOf(System.currentTimeMillis())).withCurrentVersion(updatedQuery.getVersion()).withPreviousVersion(updatedQuery.getVersion());
    }

    public class QueryUpdater
    extends EntityRepository.EntityUpdater {
        public QueryUpdater(Query original, Query updated, EntityRepository.Operation operation) {
            super((EntityRepository)QueryRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        public void entitySpecificUpdate() throws IOException {
            this.updateFromRelationships("users", "user", ((Query)this.original).getUsers(), ((Query)this.updated).getUsers(), Relationship.USES, "query", ((Query)this.original).getId());
            if (this.operation.isPatch() && !((Query)this.original).getQuery().equals(((Query)this.updated).getQuery())) {
                this.recordChange("query", ((Query)this.original).getQuery(), ((Query)this.updated).getQuery());
                String checkSum = QueryUtil.getCheckSum(((Query)this.updated).getQuery());
                this.recordChange("name", ((Query)this.original).getName(), checkSum);
                this.recordChange("checkSum", ((Query)this.original).getChecksum(), checkSum);
            }
        }
    }
}

