/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.util.List;
import javax.json.JsonPatch;
import javax.json.JsonValue;
import javax.ws.rs.core.Response;
import org.openmetadata.schema.email.SmtpSettings;
import org.openmetadata.schema.settings.Settings;
import org.openmetadata.schema.settings.SettingsType;
import org.openmetadata.schema.util.EntitiesCount;
import org.openmetadata.schema.util.ServicesCount;
import org.openmetadata.service.fernet.Fernet;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.resources.settings.SettingsCache;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.RestUtil;
import org.openmetadata.service.util.ResultList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemRepository {
    private static final Logger LOG = LoggerFactory.getLogger(SystemRepository.class);
    private static final String FAILED_TO_UPDATE_SETTINGS = "Failed to Update Settings";
    public static final String INTERNAL_SERVER_ERROR_WITH_REASON = "Internal Server Error. Reason :";
    private final CollectionDAO.SystemDAO dao;

    public SystemRepository(CollectionDAO.SystemDAO dao) {
        this.dao = dao;
    }

    public EntitiesCount getAllEntitiesCount(ListFilter filter) {
        return this.dao.getAggregatedEntitiesCount(filter.getCondition());
    }

    public ServicesCount getAllServicesCount(ListFilter filter) {
        return this.dao.getAggregatedServicesCount(filter.getCondition());
    }

    public ResultList<Settings> listAllConfigs() {
        List<Settings> settingsList = null;
        try {
            settingsList = this.dao.getAllConfig();
        }
        catch (Exception ex) {
            LOG.error("Error while trying fetch all Settings " + ex.getMessage());
        }
        int count = 0;
        if (settingsList != null) {
            count = settingsList.size();
        }
        return new ResultList<Settings>(settingsList, null, null, count);
    }

    public Settings getConfigWithKey(String key) {
        try {
            Settings fetchedSettings = this.dao.getConfigWithKey(key);
            if (fetchedSettings == null) {
                return null;
            }
            if (fetchedSettings.getConfigType() == SettingsType.EMAIL_CONFIGURATION) {
                SmtpSettings emailConfig = (SmtpSettings)fetchedSettings.getConfigValue();
                emailConfig.setPassword("***********");
                fetchedSettings.setConfigValue((Object)emailConfig);
            }
            return fetchedSettings;
        }
        catch (Exception ex) {
            LOG.error("Error while trying fetch Settings ", (Throwable)ex);
            return null;
        }
    }

    public Settings getEmailConfigInternal() {
        try {
            Settings setting = this.dao.getConfigWithKey(SettingsType.EMAIL_CONFIGURATION.value());
            SmtpSettings emailConfig = SystemRepository.decryptSetting((SmtpSettings)setting.getConfigValue());
            setting.setConfigValue((Object)emailConfig);
            return setting;
        }
        catch (Exception ex) {
            LOG.error("Error while trying fetch EMAIL Settings " + ex.getMessage());
            return null;
        }
    }

    public Response createOrUpdate(Settings setting) {
        Settings oldValue = this.getConfigWithKey(setting.getConfigType().toString());
        try {
            this.updateSetting(setting);
        }
        catch (Exception ex) {
            LOG.error(FAILED_TO_UPDATE_SETTINGS + ex.getMessage());
            return Response.status((int)500, (String)(INTERNAL_SERVER_ERROR_WITH_REASON + ex.getMessage())).build();
        }
        if (oldValue == null) {
            return new RestUtil.PutResponse<Settings>(Response.Status.CREATED, setting, "entityCreated").toResponse();
        }
        return new RestUtil.PutResponse<Settings>(Response.Status.OK, setting, "entityUpdated").toResponse();
    }

    public Response createNewSetting(Settings setting) {
        try {
            this.updateSetting(setting);
        }
        catch (Exception ex) {
            LOG.error(FAILED_TO_UPDATE_SETTINGS + ex.getMessage());
            return Response.status((int)500, (String)(INTERNAL_SERVER_ERROR_WITH_REASON + ex.getMessage())).build();
        }
        return new RestUtil.PutResponse<Settings>(Response.Status.CREATED, setting, "entityCreated").toResponse();
    }

    public Response patchSetting(String settingName, JsonPatch patch) {
        Settings original = this.getConfigWithKey(settingName);
        JsonValue updated = JsonUtils.applyPatch(original.getConfigValue(), patch);
        original.setConfigValue((Object)updated);
        try {
            this.updateSetting(original);
        }
        catch (Exception ex) {
            LOG.error(FAILED_TO_UPDATE_SETTINGS + ex.getMessage());
            return Response.status((int)500, (String)(INTERNAL_SERVER_ERROR_WITH_REASON + ex.getMessage())).build();
        }
        return new RestUtil.PutResponse<Settings>(Response.Status.OK, original, "entityUpdated").toResponse();
    }

    public void updateSetting(Settings setting) {
        try {
            if (setting.getConfigType() == SettingsType.EMAIL_CONFIGURATION) {
                SmtpSettings emailConfig = JsonUtils.convertValue(setting.getConfigValue(), SmtpSettings.class);
                setting.setConfigValue((Object)SystemRepository.encryptSetting(emailConfig));
                SettingsCache.getInstance().invalidateSettings(SettingsType.EMAIL_CONFIGURATION.value());
            }
            this.dao.insertSettings(setting.getConfigType().toString(), JsonUtils.pojoToJson(setting.getConfigValue()));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static SmtpSettings encryptSetting(SmtpSettings decryptedSetting) {
        if (Fernet.getInstance().isKeyDefined() && !Fernet.isTokenized(decryptedSetting.getPassword())) {
            String encryptedPwd = Fernet.getInstance().encrypt(decryptedSetting.getPassword());
            return decryptedSetting.withPassword(encryptedPwd);
        }
        return decryptedSetting;
    }

    public static SmtpSettings decryptSetting(SmtpSettings encryptedSetting) {
        if (Fernet.getInstance().isKeyDefined() && Fernet.isTokenized(encryptedSetting.getPassword())) {
            String decryptedPassword = Fernet.getInstance().decrypt(encryptedSetting.getPassword());
            return encryptedSetting.withPassword(decryptedPassword);
        }
        return encryptedSetting;
    }
}

