/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.classification.Tag;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.ProviderType;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagRepository
extends EntityRepository<Tag> {
    private static final Logger LOG = LoggerFactory.getLogger(TagRepository.class);

    public TagRepository(CollectionDAO dao) {
        super("/v1/tags/", "tag", Tag.class, dao.tagDAO(), dao, "", "", null);
    }

    @Override
    public void prepare(Tag entity) throws IOException {
        EntityReference parentTerm = Entity.getEntityReference(entity.getParent(), Include.NON_DELETED);
        entity.setParent(parentTerm);
        EntityReference Classification2 = Entity.getEntityReference(entity.getClassification(), Include.NON_DELETED);
        entity.setClassification(Classification2);
    }

    @Override
    public void storeEntity(Tag tag, boolean update) throws IOException {
        EntityReference Classification2 = tag.getClassification();
        EntityReference parent = tag.getParent();
        tag.withClassification(null).withParent(null);
        this.store(tag, update);
        tag.withClassification(Classification2).withParent(parent);
    }

    @Override
    public void restorePatchAttributes(Tag original, Tag updated) {
        updated.setChildren(original.getChildren());
    }

    @Override
    public void storeRelationships(Tag entity) {
        this.addClassificationRelationship(entity);
        this.addParentRelationship(entity);
    }

    @Override
    public void setFullyQualifiedName(Tag tag) {
        if (tag.getParent() == null) {
            tag.setFullyQualifiedName(FullyQualifiedName.build(tag.getClassification().getName(), tag.getName()));
        } else {
            tag.setFullyQualifiedName(FullyQualifiedName.add(tag.getParent().getFullyQualifiedName(), tag.getName()));
        }
    }

    @Override
    public EntityRepository.EntityUpdater getUpdater(Tag original, Tag updated, EntityRepository.Operation operation) {
        return new TagUpdater(original, updated, operation);
    }

    @Override
    protected void postDelete(Tag entity) {
        this.daoCollection.tagUsageDAO().deleteTagLabels(TagLabel.TagSource.CLASSIFICATION.ordinal(), entity.getFullyQualifiedName());
    }

    @Override
    public Tag setFields(Tag tag, EntityUtil.Fields fields) throws IOException {
        tag.withClassification(this.getClassification(tag)).withParent(this.getParent(tag));
        tag.setChildren(fields.contains("children") ? this.getChildren(tag) : null);
        return tag.withUsageCount(fields.contains("usageCount") ? this.getUsageCount(tag) : null);
    }

    private Integer getUsageCount(Tag tag) {
        return this.daoCollection.tagUsageDAO().getTagCount(TagLabel.TagSource.CLASSIFICATION.ordinal(), tag.getFullyQualifiedName());
    }

    private List<EntityReference> getChildren(Tag entity) throws IOException {
        List<CollectionDAO.EntityRelationshipRecord> ids = this.findTo(entity.getId(), "tag", Relationship.CONTAINS, "tag");
        return EntityUtil.populateEntityReferences(ids, "tag");
    }

    private EntityReference getParent(Tag tag) throws IOException {
        return this.getFromEntityRef(tag.getId(), Relationship.CONTAINS, "tag", false);
    }

    private EntityReference getClassification(Tag tag) throws IOException {
        return this.getFromEntityRef(tag.getId(), Relationship.CONTAINS, "classification", true);
    }

    private void addClassificationRelationship(Tag term) {
        this.addRelationship(term.getClassification().getId(), term.getId(), "classification", "tag", Relationship.CONTAINS);
    }

    private void deleteClassificationRelationship(Tag term) {
        this.deleteRelationship(term.getClassification().getId(), "classification", term.getId(), "tag", Relationship.CONTAINS);
    }

    private void updateClassificationRelationship(Tag orig, Tag updated) {
        this.deleteClassificationRelationship(orig);
        this.addClassificationRelationship(updated);
    }

    private void addParentRelationship(Tag term) {
        if (term.getParent() != null) {
            this.addRelationship(term.getParent().getId(), term.getId(), "tag", "tag", Relationship.CONTAINS);
        }
    }

    private void deleteParentRelationship(Tag term) {
        if (term.getParent() != null) {
            this.deleteRelationship(term.getParent().getId(), "tag", term.getId(), "tag", Relationship.CONTAINS);
        }
    }

    private void updateParentRelationship(Tag orig, Tag updated) {
        this.deleteParentRelationship(orig);
        this.addParentRelationship(updated);
    }

    public class TagUpdater
    extends EntityRepository.EntityUpdater {
        public TagUpdater(Tag original, Tag updated, EntityRepository.Operation operation) {
            super((EntityRepository)TagRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        public void entitySpecificUpdate() throws IOException {
            this.recordChange("mutuallyExclusive", ((Tag)this.original).getMutuallyExclusive(), ((Tag)this.updated).getMutuallyExclusive());
            this.updateName((Tag)this.original, (Tag)this.updated);
            this.updateParent((Tag)this.original, (Tag)this.updated);
        }

        public void updateName(Tag original, Tag updated) throws IOException {
            if (!original.getName().equals(updated.getName())) {
                if (ProviderType.SYSTEM.equals((Object)original.getProvider())) {
                    throw new IllegalArgumentException(CatalogExceptionMessage.systemEntityRenameNotAllowed(original.getName(), TagRepository.this.entityType));
                }
                LOG.info("Tag name changed from {} to {}", (Object)original.getName(), (Object)updated.getName());
                TagRepository.this.daoCollection.tagDAO().updateFqn(original.getFullyQualifiedName(), updated.getFullyQualifiedName());
                TagRepository.this.daoCollection.tagUsageDAO().rename(TagLabel.TagSource.CLASSIFICATION.ordinal(), original.getFullyQualifiedName(), updated.getFullyQualifiedName());
                this.recordChange("name", original.getName(), updated.getName());
            }
            TagRepository.this.getChildren(updated);
        }

        private void updateParent(Tag original, Tag updated) throws JsonProcessingException {
            UUID newParentId;
            UUID oldParentId = EntityUtil.getId(original.getParent());
            boolean parentChanged = !Objects.equals(oldParentId, newParentId = EntityUtil.getId(updated.getParent()));
            UUID oldCategoryId = EntityUtil.getId(original.getClassification());
            UUID newCategoryId = EntityUtil.getId(updated.getClassification());
            boolean ClassificationChanged = !Objects.equals(oldCategoryId, newCategoryId);
            TagRepository.this.daoCollection.tagDAO().updateFqn(original.getFullyQualifiedName(), updated.getFullyQualifiedName());
            TagRepository.this.daoCollection.tagUsageDAO().rename(TagLabel.TagSource.CLASSIFICATION.ordinal(), original.getFullyQualifiedName(), updated.getFullyQualifiedName());
            if (ClassificationChanged) {
                TagRepository.this.updateClassificationRelationship(original, updated);
                this.recordChange("Classification", original.getClassification(), updated.getClassification(), true, EntityUtil.entityReferenceMatch);
            }
            if (parentChanged) {
                TagRepository.this.updateParentRelationship(original, updated);
                this.recordChange("parent", original.getParent(), updated.getParent(), true, EntityUtil.entityReferenceMatch);
            }
        }
    }
}

