/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.migration;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.StatementException;
import org.openmetadata.service.jdbi3.MigrationDAO;
import org.openmetadata.service.migration.MigrationConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Migration {
    private static final Logger LOG = LoggerFactory.getLogger(Migration.class);

    private Migration() {
    }

    public static Optional<String> lastMigrated(Jdbi jdbi) {
        try {
            return (Optional)jdbi.withExtension(MigrationDAO.class, MigrationDAO::getMaxVersion);
        }
        catch (StatementException e) {
            throw new IllegalArgumentException("Exception encountered when trying to obtain last migrated Flyway version. Make sure you have run `./bootstrap/bootstrap_storage.sh migrate-all` at least once.", e);
        }
    }

    public static String lastMigrationFile(MigrationConfiguration conf) throws IOException {
        List<String> migrationFiles = Migration.getMigrationVersions(conf);
        return Collections.max(migrationFiles);
    }

    private static List<String> getMigrationVersions(MigrationConfiguration conf) throws IOException {
        try (Stream<String> names = Files.walk(Paths.get(conf.getPath(), new String[0]), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::toFile).map(File::getName).map(Migration::cleanName);){
            List<String> list = names.collect(Collectors.toList());
            return list;
        }
    }

    private static String cleanName(String name) {
        return Arrays.asList(name.split("_")).get(0).replace("v", "");
    }
}

