/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.dashboards;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.util.UUID;
import javax.json.JsonPatch;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.api.data.CreateDashboard;
import org.openmetadata.schema.api.data.RestoreEntity;
import org.openmetadata.schema.entity.data.Dashboard;
import org.openmetadata.schema.type.EntityHistory;
import org.openmetadata.schema.type.Include;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.DashboardRepository;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.resources.EntityResource;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.util.ResultList;

@Path(value="/v1/dashboards")
@Tag(name="Dashboards", description="Dashboards are computed from data and visually present data, metrics, and KPIs. They are typically updated in real-time and allow interactive data exploration.")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Collection(name="dashboards")
public class DashboardResource
extends EntityResource<Dashboard, DashboardRepository> {
    public static final String COLLECTION_PATH = "v1/dashboards/";
    protected static final String FIELDS = "owner,charts,followers,tags,usageSummary,extension,dataModels";

    @Override
    public Dashboard addHref(UriInfo uriInfo, Dashboard dashboard) {
        Entity.withHref(uriInfo, dashboard.getOwner());
        Entity.withHref(uriInfo, dashboard.getService());
        Entity.withHref(uriInfo, dashboard.getCharts());
        Entity.withHref(uriInfo, dashboard.getFollowers());
        Entity.withHref(uriInfo, dashboard.getDataModels());
        return dashboard;
    }

    public DashboardResource(CollectionDAO dao, Authorizer authorizer) {
        super(Dashboard.class, new DashboardRepository(dao), authorizer);
    }

    @GET
    @Valid
    @Operation(operationId="listDashboards", summary="List dashboards", description="Get a list of dashboards, optionally filtered by `service` it belongs to. Use `fields` parameter to get only necessary fields. Use cursor-based pagination to limit the number entries in the list using `limit` and `before` or `after` query params.", responses={@ApiResponse(responseCode="200", description="List of dashboards", content={@Content(mediaType="application/json", schema=@Schema(implementation=DashboardList.class))})})
    public ResultList<Dashboard> list(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner,charts,followers,tags,usageSummary,extension,dataModels")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Filter dashboards by service name", schema=@Schema(type="string", example="superset")) @QueryParam(value="service") String serviceParam, @Parameter(description="Limit the number dashboards returned. (1 to 1000000, default = 10)") @DefaultValue(value="10") @Min(value=0L) @Max(value=1000000L) @QueryParam(value="limit") @Min(value=0L) @Max(value=1000000L) int limitParam, @Parameter(description="Returns list of dashboards before this cursor", schema=@Schema(type="string")) @QueryParam(value="before") String before, @Parameter(description="Returns list of dashboards after this cursor", schema=@Schema(type="string")) @QueryParam(value="after") String after, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) throws IOException {
        ListFilter filter = new ListFilter(include).addQueryParam("service", serviceParam);
        return super.listInternal(uriInfo, securityContext, fieldsParam, filter, limitParam, before, after);
    }

    @GET
    @Path(value="/{id}/versions")
    @Operation(operationId="listAllDashboardVersion", summary="List dashboard versions", description="Get a list of all the versions of a dashboard identified by `Id`", responses={@ApiResponse(responseCode="200", description="List of dashboard versions", content={@Content(mediaType="application/json", schema=@Schema(implementation=EntityHistory.class))})})
    public EntityHistory listVersions(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the dashboard", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) throws IOException {
        return super.listVersionsInternal(securityContext, id);
    }

    @GET
    @Path(value="/{id}")
    @Operation(operationId="getDashboardByID", summary="Get a dashboard by Id", description="Get a dashboard by `Id`.", responses={@ApiResponse(responseCode="200", description="The dashboard", content={@Content(mediaType="application/json", schema=@Schema(implementation=Dashboard.class))}), @ApiResponse(responseCode="404", description="Dashboard for instance {id} is not found")})
    public Dashboard get(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the dashboard", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner,charts,followers,tags,usageSummary,extension,dataModels")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) throws IOException {
        return (Dashboard)this.getInternal(uriInfo, securityContext, id, fieldsParam, include);
    }

    @GET
    @Path(value="/name/{fqn}")
    @Operation(operationId="getDashboardByFQN", summary="Get a dashboard by fully qualified name", description="Get a dashboard by fully qualified name.", responses={@ApiResponse(responseCode="200", description="The dashboard", content={@Content(mediaType="application/json", schema=@Schema(implementation=Dashboard.class))}), @ApiResponse(responseCode="404", description="Dashboard for instance {fqn} is not found")})
    public Dashboard getByName(@Context UriInfo uriInfo, @Parameter(description="Fully qualified name of the dashboard", schema=@Schema(type="string")) @PathParam(value="fqn") String fqn, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner,charts,followers,tags,usageSummary,extension,dataModels")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) throws IOException {
        return (Dashboard)this.getByNameInternal(uriInfo, securityContext, fqn, fieldsParam, include);
    }

    @GET
    @Path(value="/{id}/versions/{version}")
    @Operation(operationId="getSpecificDashboardVersion", summary="Get a version of the dashboard", description="Get a version of the dashboard by given `id`", responses={@ApiResponse(responseCode="200", description="dashboard", content={@Content(mediaType="application/json", schema=@Schema(implementation=Dashboard.class))}), @ApiResponse(responseCode="404", description="Dashboard for instance {id} and version {version} is not found")})
    public Dashboard getVersion(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the dashboard", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="Dashboard version number in the form `major`.`minor`", schema=@Schema(type="string", example="0.1 or 1.1")) @PathParam(value="version") String version) throws IOException {
        return (Dashboard)super.getVersionInternal(securityContext, id, version);
    }

    @Override
    @POST
    @Operation(operationId="createDashboard", summary="Create a dashboard", description="Create a new dashboard.", responses={@ApiResponse(responseCode="200", description="The dashboard", content={@Content(mediaType="application/json", schema=@Schema(implementation=Dashboard.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response create(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateDashboard create) throws IOException {
        Dashboard dashboard = this.getDashboard(create, securityContext.getUserPrincipal().getName());
        return this.create(uriInfo, securityContext, dashboard);
    }

    @PATCH
    @Path(value="/{id}")
    @Operation(operationId="patchDashboard", summary="Update a dashboard", description="Update an existing dashboard using JsonPatch.", externalDocs=@ExternalDocumentation(description="JsonPatch RFC", url="https://tools.ietf.org/html/rfc6902"))
    @Consumes(value={"application/json-patch+json"})
    public Response updateDescription(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the dashboard", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @RequestBody(description="JsonPatch with array of operations", content={@Content(mediaType="application/json-patch+json", examples={@ExampleObject(value="[{op:remove, path:/a},{op:add, path: /b, value: val}]")})}) JsonPatch patch) throws IOException {
        return this.patchInternal(uriInfo, securityContext, id, patch);
    }

    @Override
    @PUT
    @Operation(operationId="createOrUpdateDashboard", summary="Create or update a dashboard", description="Create a new dashboard, if it does not exist or update an existing dashboard.", responses={@ApiResponse(responseCode="200", description="The dashboard", content={@Content(mediaType="application/json", schema=@Schema(implementation=Dashboard.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response createOrUpdate(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateDashboard create) throws IOException {
        Dashboard dashboard = this.getDashboard(create, securityContext.getUserPrincipal().getName());
        return this.createOrUpdate(uriInfo, securityContext, dashboard);
    }

    @PUT
    @Path(value="/{id}/followers")
    @Operation(operationId="addFollowerToDashboard", summary="Add a follower", description="Add a user identified by `userId` as follower of this dashboard", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Dashboard for instance {id} is not found")})
    public Response addFollower(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the dashboard", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="Id of the user to be added as follower", schema=@Schema(type="UUID")) UUID userId) throws IOException {
        return ((DashboardRepository)this.dao).addFollower(securityContext.getUserPrincipal().getName(), id, userId).toResponse();
    }

    @DELETE
    @Path(value="/{id}/followers/{userId}")
    @Operation(operationId="removeFollowerFromDashboard", summary="Remove a follower", description="Remove the user identified `userId` as a follower of the dashboard.")
    public Response deleteFollower(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the dashboard", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="Id of the user being removed as follower", schema=@Schema(type="UUID")) @PathParam(value="userId") UUID userId) throws IOException {
        return ((DashboardRepository)this.dao).deleteFollower(securityContext.getUserPrincipal().getName(), id, userId).toResponse();
    }

    @DELETE
    @Path(value="/{id}")
    @Operation(operationId="deleteDashboard", summary="Delete a dashboard by Id", description="Delete a dashboard by `Id`.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Dashboard for instance {id} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Id of the dashboard", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) throws IOException {
        return this.delete(uriInfo, securityContext, id, false, hardDelete);
    }

    @DELETE
    @Path(value="/name/{fqn}")
    @Operation(operationId="deleteDashboardByFQN", summary="Delete a dashboard by fully qualified name", description="Delete a dashboard by `fullyQualifiedName`.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Dashboard for instance {fqn} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Fully qualified name of the dashboard", schema=@Schema(type="string")) @PathParam(value="fqn") String fqn) throws IOException {
        return this.deleteByName(uriInfo, securityContext, fqn, false, hardDelete);
    }

    @PUT
    @Path(value="/restore")
    @Operation(operationId="restore", summary="Restore a soft deleted dashboard", description="Restore a soft deleted dashboard.", responses={@ApiResponse(responseCode="200", description="Successfully restored the Dashboard.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Dashboard.class))})})
    public Response restoreDashboard(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid RestoreEntity restore) throws IOException {
        return this.restoreEntity(uriInfo, securityContext, restore.getId());
    }

    private Dashboard getDashboard(CreateDashboard create, String user) throws IOException {
        return this.copy(new Dashboard(), (CreateEntity)create, user).withService(this.getEntityReference("dashboardService", create.getService())).withCharts(this.getEntityReferences("chart", create.getCharts())).withDataModels(this.getEntityReferences("dashboardDataModel", create.getDataModels())).withDashboardUrl(create.getDashboardUrl()).withTags(create.getTags());
    }

    public static class DashboardList
    extends ResultList<Dashboard> {
        DashboardList() {
        }
    }
}

