/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.lineage;

import io.dropwizard.jersey.errors.ErrorMessage;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import lombok.NonNull;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.api.lineage.AddLineage;
import org.openmetadata.schema.type.EntityLineage;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.MetadataOperation;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.LineageRepository;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.security.policyevaluator.OperationContext;
import org.openmetadata.service.security.policyevaluator.ResourceContextInterface;

@Path(value="/v1/lineage")
@Tag(name="Lineage", description="The `Lineage` for a given data asset, has information of the input datasets used and the ETL pipeline that created it.")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Collection(name="lineage")
public class LineageResource {
    private final LineageRepository dao;
    private final Authorizer authorizer;

    public LineageResource(@NonNull CollectionDAO dao, Authorizer authorizer) {
        if (dao == null) {
            throw new NullPointerException("dao is marked non-null but is null");
        }
        this.dao = new LineageRepository(dao);
        this.authorizer = authorizer;
    }

    @GET
    @Valid
    @Path(value="/{entity}/{id}")
    @Operation(operationId="getLineage", summary="Get lineage by Id", description="Get lineage details for an entity identified by `Id`.", responses={@ApiResponse(responseCode="200", description="Entity lineage", content={@Content(mediaType="application/json", schema=@Schema(implementation=EntityLineage.class))}), @ApiResponse(responseCode="404", description="Entity for instance {id} is not found")})
    public EntityLineage get(@Context UriInfo uriInfo, @Parameter(description="Entity type for which lineage is requested", required=true, schema=@Schema(type="string", example="table, report, metrics, or dashboard")) @PathParam(value="entity") String entity, @Parameter(description="Id of the entity", required=true, schema=@Schema(type="string")) @PathParam(value="id") String id, @Parameter(description="Upstream depth of lineage (default=1, min=0, max=3)") @DefaultValue(value="1") @Min(value=0L) @Max(value=3L) @QueryParam(value="upstreamDepth") @Min(value=0L) @Max(value=3L) int upstreamDepth, @Parameter(description="Upstream depth of lineage (default=1, min=0, max=3)") @DefaultValue(value="1") @Min(value=0L) @Max(value=3L) @QueryParam(value="downstreamDepth") @Min(value=0L) @Max(value=3L) int downStreamDepth) throws IOException {
        return this.addHref(uriInfo, this.dao.get(entity, id, upstreamDepth, downStreamDepth));
    }

    @GET
    @Valid
    @Path(value="/{entity}/name/{fqn}")
    @Operation(operationId="getLineageByFQN", summary="Get lineage by fully qualified name", description="Get lineage details for an entity identified by fully qualified name.", responses={@ApiResponse(responseCode="200", description="Entity lineage", content={@Content(mediaType="application/json", schema=@Schema(implementation=EntityLineage.class))}), @ApiResponse(responseCode="404", description="Entity for instance {fqn} is not found")})
    public EntityLineage getByName(@Context UriInfo uriInfo, @Parameter(description="Entity type for which lineage is requested", required=true, schema=@Schema(type="string", example="table, report, metrics, or dashboard")) @PathParam(value="entity") String entity, @Parameter(description="Fully qualified name of the entity that uniquely identifies an entity", required=true, schema=@Schema(type="string")) @PathParam(value="fqn") String fqn, @Parameter(description="Upstream depth of lineage (default=1, min=0, max=3)") @DefaultValue(value="1") @Min(value=0L) @Max(value=3L) @QueryParam(value="upstreamDepth") @Min(value=0L) @Max(value=3L) int upstreamDepth, @Parameter(description="Upstream depth of lineage (default=1, min=0, max=3)") @DefaultValue(value="1") @Min(value=0L) @Max(value=3L) @QueryParam(value="downstreamDepth") @Min(value=0L) @Max(value=3L) int downStreamDepth) throws IOException {
        return this.addHref(uriInfo, this.dao.getByName(entity, fqn, upstreamDepth, downStreamDepth));
    }

    @PUT
    @Operation(operationId="addLineageEdge", summary="Add a lineage edge", description="Add a lineage edge with from entity as upstream node and to entity as downstream node.", responses={@ApiResponse(responseCode="200"), @ApiResponse(responseCode="404", description="Entity for instance {id} is not found")})
    public Response addLineage(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid AddLineage addLineage) throws IOException {
        this.authorizer.authorize(securityContext, new OperationContext("lineage", MetadataOperation.EDIT_LINEAGE), new LineageResourceContext());
        this.dao.addLineage(addLineage);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @DELETE
    @Path(value="/{fromEntity}/{fromId}/{toEntity}/{toId}")
    @Operation(operationId="deleteLineageEdge", summary="Delete a lineage edge", description="Delete a lineage edge with from entity as upstream node and to entity as downstream node.", responses={@ApiResponse(responseCode="200"), @ApiResponse(responseCode="404", description="Entity for instance {fromId} is not found")})
    public Response deleteLineage(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Entity type of upstream entity of the edge", required=true, schema=@Schema(type="string", example="table, report, metrics, or dashboard")) @PathParam(value="fromEntity") String fromEntity, @Parameter(description="Entity id", required=true, schema=@Schema(type="string")) @PathParam(value="fromId") String fromId, @Parameter(description="Entity type for downstream entity of the edge", required=true, schema=@Schema(type="string", example="table, report, metrics, or dashboard")) @PathParam(value="toEntity") String toEntity, @Parameter(description="Entity id", required=true, schema=@Schema(type="string")) @PathParam(value="toId") String toId) throws IOException {
        this.authorizer.authorize(securityContext, new OperationContext("lineage", MetadataOperation.EDIT_LINEAGE), new LineageResourceContext());
        boolean deleted = this.dao.deleteLineage(fromEntity, fromId, toEntity, toId);
        if (!deleted) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorMessage(Response.Status.NOT_FOUND.getStatusCode(), "Lineage edge not found")).build();
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    private EntityLineage addHref(UriInfo uriInfo, EntityLineage lineage) {
        Entity.withHref(uriInfo, lineage.getEntity());
        Entity.withHref(uriInfo, lineage.getNodes());
        return lineage;
    }

    static class LineageResourceContext
    implements ResourceContextInterface {
        LineageResourceContext() {
        }

        @Override
        public String getResource() {
            return "lineage";
        }

        @Override
        public EntityReference getOwner() {
            return null;
        }

        @Override
        public List<TagLabel> getTags() {
            return null;
        }

        @Override
        public EntityInterface getEntity() {
            return null;
        }
    }
}

