/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.secrets;

import com.google.common.annotations.VisibleForTesting;
import java.util.Objects;
import org.openmetadata.schema.security.secrets.SecretsManagerConfiguration;
import org.openmetadata.schema.security.secrets.SecretsManagerProvider;
import org.openmetadata.service.secrets.AWSBasedSecretsManager;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClientBuilder;
import software.amazon.awssdk.services.secretsmanager.model.CreateSecretRequest;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueRequest;
import software.amazon.awssdk.services.secretsmanager.model.UpdateSecretRequest;

public class AWSSecretsManager
extends AWSBasedSecretsManager {
    private static AWSSecretsManager INSTANCE = null;
    private SecretsManagerClient secretsClient;

    private AWSSecretsManager(SecretsManagerConfiguration config, String clusterPrefix) {
        super(SecretsManagerProvider.MANAGED_AWS, config, clusterPrefix);
    }

    @Override
    void initClientWithoutCredentials() {
        this.secretsClient = SecretsManagerClient.create();
    }

    @Override
    void initClientWithCredentials(String region, AwsCredentialsProvider staticCredentialsProvider) {
        this.secretsClient = (SecretsManagerClient)((SecretsManagerClientBuilder)((SecretsManagerClientBuilder)SecretsManagerClient.builder().region(Region.of((String)region))).credentialsProvider(staticCredentialsProvider)).build();
    }

    @Override
    public void storeSecret(String secretName, String secretValue) {
        CreateSecretRequest createSecretRequest = (CreateSecretRequest)CreateSecretRequest.builder().name(secretName).description("This secret was created by OpenMetadata").secretString(Objects.isNull(secretValue) ? "null" : secretValue).build();
        this.secretsClient.createSecret(createSecretRequest);
    }

    @Override
    public void updateSecret(String secretName, String secretValue) {
        UpdateSecretRequest updateSecretRequest = (UpdateSecretRequest)UpdateSecretRequest.builder().secretId(secretName).description("This secret was created by OpenMetadata").secretString(Objects.isNull(secretValue) ? "null" : secretValue).build();
        this.secretsClient.updateSecret(updateSecretRequest);
    }

    @Override
    public String getSecret(String secretName) {
        GetSecretValueRequest getSecretValueRequest = (GetSecretValueRequest)GetSecretValueRequest.builder().secretId(secretName).build();
        return this.secretsClient.getSecretValue(getSecretValueRequest).secretString();
    }

    public static AWSSecretsManager getInstance(SecretsManagerConfiguration config, String clusterPrefix) {
        if (INSTANCE == null) {
            INSTANCE = new AWSSecretsManager(config, clusterPrefix);
        }
        return INSTANCE;
    }

    @VisibleForTesting
    protected void setSecretsClient(SecretsManagerClient secretsClient) {
        this.secretsClient = secretsClient;
    }
}

