/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.util;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;
import javax.json.stream.JsonParsingException;
import org.bitbucket.cowwoc.diffmatchpatch.DiffMatchPatch;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.dataInsight.type.KpiResult;
import org.openmetadata.schema.dataInsight.type.KpiTarget;
import org.openmetadata.schema.entity.data.Query;
import org.openmetadata.schema.entity.services.ingestionPipelines.PipelineStatus;
import org.openmetadata.schema.tests.TestCase;
import org.openmetadata.schema.tests.type.TestCaseResult;
import org.openmetadata.schema.type.ChangeDescription;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.FieldChange;
import org.openmetadata.service.ChangeEventConfig;
import org.openmetadata.service.events.subscription.emailAlert.EmailMessage;
import org.openmetadata.service.events.subscription.gchat.GChatMessage;
import org.openmetadata.service.events.subscription.msteams.TeamsMessage;
import org.openmetadata.service.events.subscription.slack.SlackAttachment;
import org.openmetadata.service.events.subscription.slack.SlackMessage;
import org.openmetadata.service.resources.feeds.MessageParser;
import org.openmetadata.service.util.FullyQualifiedName;
import org.openmetadata.service.util.JsonUtils;

public final class ChangeEventParser {
    public static final String FEED_ADD_MARKER = "<!add>";
    public static final String FEED_REMOVE_MARKER = "<!remove>";
    public static final String FEED_BOLD = "**%s**";
    public static final String SLACK_BOLD = "*%s*";
    public static final String FEED_SPAN_ADD = "<span class=\"diff-added\">";
    public static final String FEED_SPAN_REMOVE = "<span class=\"diff-removed\">";
    public static final String FEED_SPAN_CLOSE = "</span>";
    public static final String FEED_LINE_BREAK = " <br/> ";
    public static final String SLACK_LINE_BREAK = "\n";

    private ChangeEventParser() {
    }

    public static String getBold(PublishTo publishTo) {
        switch (publishTo) {
            case FEED: 
            case TEAMS: {
                return FEED_BOLD;
            }
            case SLACK: {
                return SLACK_BOLD;
            }
            case GCHAT: 
            case EMAIL: {
                return "<b>%s</b>";
            }
        }
        return "INVALID";
    }

    public static String getLineBreak(PublishTo publishTo) {
        switch (publishTo) {
            case FEED: 
            case TEAMS: 
            case GCHAT: 
            case EMAIL: {
                return FEED_LINE_BREAK;
            }
            case SLACK: {
                return SLACK_LINE_BREAK;
            }
        }
        return "INVALID";
    }

    public static String getAddMarker(PublishTo publishTo) {
        switch (publishTo) {
            case FEED: {
                return FEED_SPAN_ADD;
            }
            case TEAMS: {
                return "**";
            }
            case SLACK: {
                return "*";
            }
            case GCHAT: 
            case EMAIL: {
                return "<b>";
            }
        }
        return "INVALID";
    }

    public static String getAddMarkerClose(PublishTo publishTo) {
        switch (publishTo) {
            case FEED: {
                return FEED_SPAN_CLOSE;
            }
            case TEAMS: {
                return "** ";
            }
            case SLACK: {
                return "*";
            }
            case GCHAT: 
            case EMAIL: {
                return "</b>";
            }
        }
        return "INVALID";
    }

    public static String getRemoveMarker(PublishTo publishTo) {
        switch (publishTo) {
            case FEED: {
                return FEED_SPAN_REMOVE;
            }
            case TEAMS: {
                return "~~";
            }
            case SLACK: {
                return "~";
            }
            case GCHAT: 
            case EMAIL: {
                return "<s>";
            }
        }
        return "INVALID";
    }

    public static String getRemoveMarkerClose(PublishTo publishTo) {
        switch (publishTo) {
            case FEED: {
                return FEED_SPAN_CLOSE;
            }
            case TEAMS: {
                return "~~ ";
            }
            case SLACK: {
                return "~";
            }
            case GCHAT: 
            case EMAIL: {
                return "</s>";
            }
        }
        return "INVALID";
    }

    public static String getEntityUrl(PublishTo publishTo, ChangeEvent event) {
        String entityType;
        String fqn;
        EntityInterface entity = (EntityInterface)event.getEntity();
        if (entity instanceof TestCase) {
            fqn = ((TestCase)entity).getTestSuite().getFullyQualifiedName();
            entityType = "test-suites";
        } else {
            fqn = event.getEntityFullyQualifiedName();
            entityType = event.getEntityType();
        }
        if (publishTo == PublishTo.SLACK || publishTo == PublishTo.GCHAT) {
            return String.format("<%s/%s/%s|%s>", ChangeEventConfig.getInstance().getOmUri(), entityType, fqn.trim().replaceAll(" ", "%20"), fqn.trim());
        }
        if (publishTo == PublishTo.TEAMS) {
            return String.format("[%s](/%s/%s)", fqn.trim(), ChangeEventConfig.getInstance().getOmUri(), entityType);
        }
        if (publishTo == PublishTo.EMAIL) {
            return String.format("<a href = '%s/%s/%s'>%s</a>", ChangeEventConfig.getInstance().getOmUri(), entityType, fqn.trim(), fqn.trim());
        }
        return "";
    }

    public static SlackMessage buildSlackMessage(ChangeEvent event) {
        SlackMessage slackMessage = new SlackMessage();
        slackMessage.setUsername(event.getUserName());
        if (event.getEntity() != null) {
            String headerText;
            String headerTxt;
            String eventType = event.getEntity() instanceof TestCase ? "testSuite" : event.getEntityType();
            if (eventType.equals("query")) {
                headerTxt = "%s posted on " + eventType;
                headerText = String.format(headerTxt, event.getUserName());
            } else {
                headerTxt = "%s posted on " + eventType + " %s";
                headerText = String.format(headerTxt, event.getUserName(), ChangeEventParser.getEntityUrl(PublishTo.SLACK, event));
            }
            slackMessage.setText(headerText);
        }
        Map<MessageParser.EntityLink, String> messages = ChangeEventParser.getFormattedMessages(PublishTo.SLACK, event.getChangeDescription(), (EntityInterface)event.getEntity());
        ArrayList<SlackAttachment> attachmentList = new ArrayList<SlackAttachment>();
        for (Map.Entry<MessageParser.EntityLink, String> entry : messages.entrySet()) {
            SlackAttachment attachment = new SlackAttachment();
            ArrayList<String> mark = new ArrayList<String>();
            mark.add("text");
            attachment.setMarkdownIn(mark);
            attachment.setText(entry.getValue());
            attachmentList.add(attachment);
        }
        slackMessage.setAttachments(attachmentList.toArray(new SlackAttachment[0]));
        return slackMessage;
    }

    public static EmailMessage buildEmailMessage(ChangeEvent event) {
        EmailMessage emailMessage = new EmailMessage();
        emailMessage.setUserName(event.getUserName());
        if (event.getEntity() != null) {
            emailMessage.setUpdatedBy(event.getUserName());
            if (event.getEntityType().equals("query")) {
                emailMessage.setEntityUrl("query");
            } else {
                emailMessage.setEntityUrl(ChangeEventParser.getEntityUrl(PublishTo.EMAIL, event));
            }
        }
        Map<MessageParser.EntityLink, String> messages = ChangeEventParser.getFormattedMessages(PublishTo.EMAIL, event.getChangeDescription(), (EntityInterface)event.getEntity());
        ArrayList<String> changeMessage = new ArrayList<String>();
        for (Map.Entry<MessageParser.EntityLink, String> entry : messages.entrySet()) {
            changeMessage.add(entry.getValue());
        }
        emailMessage.setChangeMessage(changeMessage);
        return emailMessage;
    }

    public static TeamsMessage buildTeamsMessage(ChangeEvent event) {
        TeamsMessage teamsMessage = new TeamsMessage();
        teamsMessage.setSummary("Change Event From OMD");
        TeamsMessage.Section teamsSections = new TeamsMessage.Section();
        if (event.getEntity() != null) {
            String headerTxt = "%s posted on " + event.getEntityType() + " %s";
            String headerText = String.format(headerTxt, event.getUserName(), ChangeEventParser.getEntityUrl(PublishTo.TEAMS, event));
            teamsSections.setActivityTitle(headerText);
        }
        Map<MessageParser.EntityLink, String> messages = ChangeEventParser.getFormattedMessages(PublishTo.TEAMS, event.getChangeDescription(), (EntityInterface)event.getEntity());
        ArrayList<TeamsMessage.Section> attachmentList = new ArrayList<TeamsMessage.Section>();
        for (Map.Entry<MessageParser.EntityLink, String> entry : messages.entrySet()) {
            TeamsMessage.Section section = new TeamsMessage.Section();
            section.setActivityTitle(teamsSections.getActivityTitle());
            section.setActivityText(entry.getValue());
            attachmentList.add(section);
        }
        teamsMessage.setSections(attachmentList);
        return teamsMessage;
    }

    public static GChatMessage buildGChatMessage(ChangeEvent event) {
        GChatMessage gChatMessage = new GChatMessage();
        GChatMessage.CardsV2 cardsV2 = new GChatMessage.CardsV2();
        GChatMessage.Card card = new GChatMessage.Card();
        GChatMessage.Section section = new GChatMessage.Section();
        if (event.getEntity() != null) {
            String headerTemplate = "%s posted on %s %s";
            String headerText = String.format(headerTemplate, event.getUserName(), event.getEntityType(), ChangeEventParser.getEntityUrl(PublishTo.GCHAT, event));
            gChatMessage.setText(headerText);
            GChatMessage.CardHeader cardHeader = new GChatMessage.CardHeader();
            String cardHeaderText = String.format(headerTemplate, event.getUserName(), event.getEntityType(), ((EntityInterface)event.getEntity()).getName());
            cardHeader.setTitle(cardHeaderText);
            card.setHeader(cardHeader);
        }
        Map<MessageParser.EntityLink, String> messages = ChangeEventParser.getFormattedMessages(PublishTo.GCHAT, event.getChangeDescription(), (EntityInterface)event.getEntity());
        ArrayList<GChatMessage.Widget> widgets = new ArrayList<GChatMessage.Widget>();
        for (Map.Entry<MessageParser.EntityLink, String> entry : messages.entrySet()) {
            GChatMessage.Widget widget = new GChatMessage.Widget();
            widget.setTextParagraph(new GChatMessage.TextParagraph(entry.getValue()));
            widgets.add(widget);
        }
        section.setWidgets(widgets);
        card.setSections(List.of(section));
        cardsV2.setCard(card);
        gChatMessage.setCardsV2(List.of(cardsV2));
        return gChatMessage;
    }

    public static Map<MessageParser.EntityLink, String> getFormattedMessages(PublishTo publishTo, ChangeDescription changeDescription, EntityInterface entity) {
        List fieldsUpdated = changeDescription.getFieldsUpdated();
        Map<MessageParser.EntityLink, String> messages = ChangeEventParser.getFormattedMessagesForAllFieldChange(publishTo, entity, fieldsUpdated, ChangeType.UPDATE);
        List fieldsAdded = changeDescription.getFieldsAdded();
        List fieldsDeleted = changeDescription.getFieldsDeleted();
        messages.putAll(ChangeEventParser.mergeAdditionsDeletion(publishTo, entity, fieldsAdded, fieldsDeleted));
        return messages;
    }

    private static Map<MessageParser.EntityLink, String> getFormattedMessagesForAllFieldChange(PublishTo publishTo, EntityInterface entity, List<FieldChange> fields, ChangeType changeType) {
        HashMap<MessageParser.EntityLink, String> messages = new HashMap<MessageParser.EntityLink, String>();
        for (FieldChange field : fields) {
            String message;
            String fieldName = field.getName();
            MessageParser.EntityLink link = ChangeEventParser.getEntityLink(fieldName, entity);
            String entityType = link.getEntityType();
            String newFieldValue = ChangeEventParser.getFieldValue(field.getNewValue());
            String oldFieldValue = ChangeEventParser.getFieldValue(field.getOldValue());
            if (entityType.equals("query") && fieldName.equals("queryUsedIn")) {
                message = ChangeEventParser.handleQueryUsage(newFieldValue, oldFieldValue, entity, publishTo, changeType, link);
                messages.put(link, message);
                continue;
            }
            if (entityType.equals("testCase") && link.getFieldName().equals("testCaseResult")) {
                message = ChangeEventParser.handleTestCaseResult(publishTo, entity, newFieldValue);
                messages.put(link, message);
                continue;
            }
            if (entityType.equals("kpi") && link.getFieldName().equals("kpiResult")) {
                message = ChangeEventParser.handleKpiResult(publishTo, entity, newFieldValue);
                messages.put(link, message);
                continue;
            }
            if (entityType.equals("ingestionPipeline") && link.getFieldName().equals("pipelineStatus")) {
                message = ChangeEventParser.handleIngestionPipelineResult(publishTo, entity, newFieldValue);
                messages.put(link, message);
                continue;
            }
            if (fieldName.equals("failureDetails")) continue;
            message = ChangeEventParser.createMessageForField(publishTo, link, changeType, fieldName, oldFieldValue, newFieldValue);
            messages.put(link, message);
        }
        return messages;
    }

    public static String getFieldValue(Object fieldValue) {
        if (CommonUtil.nullOrEmpty((Object)fieldValue)) {
            return "";
        }
        try {
            JsonValue json = JsonUtils.readJson(fieldValue.toString());
            if (json.getValueType() == JsonValue.ValueType.ARRAY) {
                JsonArray jsonArray = json.asJsonArray();
                ArrayList<String> labels = new ArrayList<String>();
                for (JsonValue item : jsonArray) {
                    if (item.getValueType() == JsonValue.ValueType.OBJECT) {
                        Set keys = item.asJsonObject().keySet();
                        if (keys.contains("tagFQN")) {
                            labels.add(item.asJsonObject().getString("tagFQN"));
                            continue;
                        }
                        if (keys.contains("displayName")) {
                            labels.add(item.asJsonObject().getString("displayName"));
                            continue;
                        }
                        if (keys.contains("name")) {
                            labels.add(item.asJsonObject().getString("name"));
                            continue;
                        }
                        if (!keys.contains("constraintType")) continue;
                        labels.add(item.asJsonObject().getString("constraintType"));
                        continue;
                    }
                    if (item.getValueType() != JsonValue.ValueType.STRING) continue;
                    String label = item.toString().replaceAll("^\"|\"$", "");
                    labels.add(label.strip());
                }
                return String.join((CharSequence)", ", labels);
            }
            if (json.getValueType() == JsonValue.ValueType.OBJECT) {
                JsonObject jsonObject = json.asJsonObject();
                Set keys = jsonObject.asJsonObject().keySet();
                if (keys.contains("displayName")) {
                    return jsonObject.asJsonObject().getString("displayName");
                }
                if (keys.contains("name")) {
                    return jsonObject.asJsonObject().getString("name");
                }
            }
        }
        catch (JsonParsingException jsonParsingException) {
            // empty catch block
        }
        return fieldValue.toString();
    }

    private static String handleQueryUsage(Object newValue, Object oldValue, EntityInterface entity, PublishTo publishTo, ChangeType changeType, MessageParser.EntityLink link) {
        String newVal = ChangeEventParser.getFieldValueForQuery(newValue, entity, publishTo);
        String oldVal = ChangeEventParser.getFieldValueForQuery(oldValue, entity, publishTo);
        return ChangeEventParser.createMessageForField(publishTo, link, changeType, "queryUsage", oldVal, newVal);
    }

    private static String getFieldValueForQuery(Object fieldValue, EntityInterface entity, PublishTo publishTo) {
        Query query = (Query)entity;
        StringBuilder field = new StringBuilder();
        List queryUsedIn = (List)fieldValue;
        field.append("for ").append("'").append(query.getQuery()).append("'").append(", ").append(ChangeEventParser.getLineBreak(publishTo));
        field.append("Query Used in :- ");
        int i = 1;
        for (EntityReference queryUsage : queryUsedIn) {
            field.append(ChangeEventParser.getQueryUsageUrl(publishTo, queryUsage.getFullyQualifiedName(), queryUsage.getType()));
            if (i < queryUsedIn.size()) {
                field.append(", ");
            }
            ++i;
        }
        return field.toString();
    }

    private static String getQueryUsageUrl(PublishTo publishTo, String fqn, String entityType) {
        if (publishTo == PublishTo.SLACK || publishTo == PublishTo.GCHAT) {
            return String.format("<%s/%s/%s|%s>", ChangeEventConfig.getInstance().getOmUri(), entityType, fqn.trim().replaceAll(" ", "%20"), fqn.trim());
        }
        if (publishTo == PublishTo.TEAMS) {
            return String.format("[%s](/%s/%s)", fqn, ChangeEventConfig.getInstance().getOmUri(), entityType);
        }
        if (publishTo == PublishTo.EMAIL) {
            return String.format("<a href = '%s/%s/%s'>%s</a>", ChangeEventConfig.getInstance().getOmUri(), entityType, fqn.trim(), fqn.trim());
        }
        return String.format("[%s](/%s/%s)", fqn, entityType, fqn.trim());
    }

    private static Map<MessageParser.EntityLink, String> mergeAdditionsDeletion(PublishTo publishTo, EntityInterface entity, List<FieldChange> addedFields, List<FieldChange> deletedFields) {
        Map<MessageParser.EntityLink, String> messages = new HashMap<MessageParser.EntityLink, String>();
        if (addedFields.isEmpty() || deletedFields.isEmpty()) {
            if (!addedFields.isEmpty()) {
                messages = ChangeEventParser.getFormattedMessagesForAllFieldChange(publishTo, entity, addedFields, ChangeType.ADD);
            } else if (!deletedFields.isEmpty()) {
                messages = ChangeEventParser.getFormattedMessagesForAllFieldChange(publishTo, entity, deletedFields, ChangeType.DELETE);
            }
            return messages;
        }
        for (FieldChange field : deletedFields) {
            Optional<FieldChange> addedField = addedFields.stream().filter(f -> f.getName().equals(field.getName())).findAny();
            if (addedField.isPresent()) {
                String fieldName = field.getName();
                MessageParser.EntityLink link = ChangeEventParser.getEntityLink(fieldName, entity);
                String message = ChangeEventParser.createMessageForField(publishTo, link, ChangeType.UPDATE, fieldName, field.getOldValue(), addedField.get().getNewValue());
                messages.put(link, message);
                addedFields = addedFields.stream().filter(f -> !f.equals(addedField.get())).collect(Collectors.toList());
                continue;
            }
            messages.putAll(ChangeEventParser.getFormattedMessagesForAllFieldChange(publishTo, entity, Collections.singletonList(field), ChangeType.DELETE));
        }
        if (!addedFields.isEmpty()) {
            messages.putAll(ChangeEventParser.getFormattedMessagesForAllFieldChange(publishTo, entity, addedFields, ChangeType.ADD));
        }
        return messages;
    }

    public static MessageParser.EntityLink getEntityLink(String fieldName, EntityInterface entity) {
        EntityReference entityReference = entity.getEntityReference();
        String entityType = entityReference.getType();
        String entityFQN = entityReference.getFullyQualifiedName();
        String arrayFieldName = null;
        String arrayFieldValue = null;
        if (fieldName.contains(".")) {
            String[] fieldNameParts = FullyQualifiedName.split(fieldName);
            fieldName = fieldNameParts[0];
            if (fieldNameParts.length == 3) {
                arrayFieldName = fieldNameParts[1];
                arrayFieldValue = fieldNameParts[2];
            } else if (fieldNameParts.length == 2) {
                arrayFieldName = fieldNameParts[1];
            }
        }
        return new MessageParser.EntityLink(entityType, entityFQN, fieldName, arrayFieldName, arrayFieldValue);
    }

    private static String createMessageForField(PublishTo publishTo, MessageParser.EntityLink link, ChangeType changeType, String fieldName, Object oldFieldValue, Object newFieldValue) {
        String arrayFieldName = link.getArrayFieldName();
        String arrayFieldValue = link.getArrayFieldValue();
        String message = null;
        String updatedField = fieldName;
        if (arrayFieldValue != null) {
            updatedField = String.format("%s.%s", arrayFieldName, arrayFieldValue);
        } else if (arrayFieldName != null) {
            updatedField = String.format("%s.%s", fieldName, arrayFieldName);
        }
        switch (changeType) {
            case ADD: {
                String fieldValue = ChangeEventParser.getFieldValue(newFieldValue);
                if ("followers".equals(updatedField)) {
                    message = String.format("Followed " + ChangeEventParser.getBold(publishTo) + " `%s`", link.getEntityType(), link.getEntityFQN());
                    break;
                }
                if (fieldValue == null || fieldValue.isEmpty()) break;
                message = String.format("Added " + ChangeEventParser.getBold(publishTo) + ": " + ChangeEventParser.getBold(publishTo), updatedField, fieldValue.trim());
                break;
            }
            case UPDATE: {
                message = ChangeEventParser.getUpdateMessage(publishTo, updatedField, oldFieldValue, newFieldValue);
                break;
            }
            case DELETE: {
                if ("followers".equals(updatedField)) {
                    message = String.format("Unfollowed %s `%s`", link.getEntityType(), link.getEntityFQN());
                    break;
                }
                message = String.format("Deleted " + ChangeEventParser.getBold(publishTo) + ": `%s`", updatedField, ChangeEventParser.getFieldValue(oldFieldValue).trim());
                break;
            }
        }
        return message;
    }

    private static String getPlainTextUpdateMessage(PublishTo publishTo, String updatedField, String oldValue, String newValue) {
        String diff = ChangeEventParser.getPlaintextDiff(publishTo, oldValue, newValue);
        if (CommonUtil.nullOrEmpty((String)diff)) {
            return "";
        }
        String field = String.format("Updated %s: %s", ChangeEventParser.getBold(publishTo), diff);
        return String.format(field, updatedField);
    }

    private static String getObjectUpdateMessage(PublishTo publishTo, String updatedField, JsonObject oldJson, JsonObject newJson) {
        ArrayList<String> labels = new ArrayList<String>();
        Set keys = newJson.keySet();
        for (String key : keys) {
            if (((JsonValue)newJson.get((Object)key)).equals(oldJson.get((Object)key))) continue;
            labels.add(String.format("%s: %s", key, ChangeEventParser.getPlaintextDiff(publishTo, ((JsonValue)oldJson.get((Object)key)).toString(), ((JsonValue)newJson.get((Object)key)).toString())));
        }
        String updates = String.join((CharSequence)ChangeEventParser.getLineBreak(publishTo), labels);
        if (newJson.containsKey((Object)"name")) {
            updatedField = String.format("%s.%s", updatedField, newJson.getString("name"));
        }
        String format = String.format("Updated %s:%s%s", ChangeEventParser.getBold(publishTo), ChangeEventParser.getLineBreak(publishTo), updates);
        return String.format(format, updatedField);
    }

    private static String getUpdateMessage(PublishTo publishTo, String updatedField, Object oldValue, Object newValue) {
        if (newValue == null) {
            return "";
        }
        if (CommonUtil.nullOrEmpty((Object)oldValue)) {
            String format = String.format("Updated %s to %s", ChangeEventParser.getBold(publishTo), ChangeEventParser.getFieldValue(newValue));
            return String.format(format, updatedField);
        }
        if (updatedField.contains("tags") || updatedField.contains("owner")) {
            return ChangeEventParser.getPlainTextUpdateMessage(publishTo, updatedField, ChangeEventParser.getFieldValue(oldValue), ChangeEventParser.getFieldValue(newValue));
        }
        if (!newValue.toString().isEmpty()) {
            try {
                JsonValue newJson = JsonUtils.readJson(newValue.toString());
                JsonValue oldJson = JsonUtils.readJson(oldValue.toString());
                if (newJson.getValueType() == JsonValue.ValueType.ARRAY) {
                    JsonArray newJsonArray = newJson.asJsonArray();
                    JsonArray oldJsonArray = oldJson.asJsonArray();
                    if (newJsonArray.size() == 1 && oldJsonArray.size() == 1) {
                        JsonValue newItem = (JsonValue)newJsonArray.get(0);
                        JsonValue oldItem = (JsonValue)oldJsonArray.get(0);
                        if (newItem.getValueType() == JsonValue.ValueType.OBJECT) {
                            JsonObject newJsonItem = newItem.asJsonObject();
                            JsonObject oldJsonItem = oldItem.asJsonObject();
                            return ChangeEventParser.getObjectUpdateMessage(publishTo, updatedField, oldJsonItem, newJsonItem);
                        }
                        return ChangeEventParser.getPlainTextUpdateMessage(publishTo, updatedField, newItem.toString(), oldItem.toString());
                    }
                    return ChangeEventParser.getPlainTextUpdateMessage(publishTo, updatedField, ChangeEventParser.getFieldValue(oldValue), ChangeEventParser.getFieldValue(newValue));
                }
                if (newJson.getValueType() == JsonValue.ValueType.OBJECT) {
                    JsonObject newJsonObject = newJson.asJsonObject();
                    JsonObject oldJsonObject = oldJson.asJsonObject();
                    return ChangeEventParser.getObjectUpdateMessage(publishTo, updatedField, oldJsonObject, newJsonObject);
                }
            }
            catch (JsonParsingException jsonParsingException) {
                // empty catch block
            }
        }
        return ChangeEventParser.getPlainTextUpdateMessage(publishTo, updatedField, oldValue.toString(), newValue.toString());
    }

    public static String handleTestCaseResult(PublishTo publishTo, EntityInterface entity, Object newValue) {
        String testCaseName = entity.getName();
        TestCaseResult result = (TestCaseResult)newValue;
        TestCase testCaseEntity = (TestCase)entity;
        if (result != null) {
            String format = String.format("Test Case status for %s against table/column %s is %s in test suite %s", ChangeEventParser.getBold(publishTo), MessageParser.EntityLink.parse(testCaseEntity.getEntityLink()).getEntityFQN(), ChangeEventParser.getBold(publishTo), testCaseEntity.getTestSuite().getName());
            return String.format(format, testCaseName, result.getTestCaseStatus());
        }
        String format = String.format("Test Case %s is updated in %s/%s", ChangeEventParser.getBold(publishTo), MessageParser.EntityLink.parse(testCaseEntity.getEntityLink()).getEntityFQN(), testCaseEntity.getTestSuite().getName());
        return String.format(format, testCaseName);
    }

    public static String handleIngestionPipelineResult(PublishTo publishTo, EntityInterface entity, Object newValue) {
        String ingestionPipelineName = entity.getName();
        PipelineStatus status = (PipelineStatus)newValue;
        if (status != null) {
            String date = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss").format(new Date(status.getEndDate()));
            String format = String.format("Ingestion Pipeline %s %s at %s", ChangeEventParser.getBold(publishTo), ChangeEventParser.getBold(publishTo), date);
            return String.format(format, ingestionPipelineName, status.getPipelineState());
        }
        String format = String.format("Ingestion Pipeline %s is updated", ChangeEventParser.getBold(publishTo));
        return String.format(format, ingestionPipelineName);
    }

    public static String handleKpiResult(PublishTo publishTo, EntityInterface entity, Object newValue) {
        String kpiName = entity.getName();
        KpiResult result = (KpiResult)newValue;
        if (result != null) {
            String format = String.format("Added Results for %s. Target Name : %s , Current Value: %s, Target Met: %s", ChangeEventParser.getBold(publishTo), ChangeEventParser.getBold(publishTo), ChangeEventParser.getBold(publishTo), ChangeEventParser.getBold(publishTo));
            KpiTarget target = (KpiTarget)result.getTargetResult().get(0);
            return String.format(format, kpiName, target.getName(), target.getValue(), target.getTargetMet());
        }
        String format = String.format("KpiResult %s is updated.", ChangeEventParser.getBold(publishTo));
        return String.format(format, kpiName);
    }

    public static String getPlaintextDiff(PublishTo publishTo, String oldValue, String newValue) {
        String addMarker = FEED_ADD_MARKER;
        String removeMarker = FEED_REMOVE_MARKER;
        DiffMatchPatch dmp = new DiffMatchPatch();
        LinkedList diffs = dmp.diffMain(oldValue, newValue);
        dmp.diffCleanupSemantic(diffs);
        StringBuilder outputStr = new StringBuilder();
        for (DiffMatchPatch.Diff d : diffs) {
            if (DiffMatchPatch.Operation.EQUAL.equals((Object)d.operation)) {
                outputStr.append(d.text.trim()).append(" ");
                continue;
            }
            if (DiffMatchPatch.Operation.INSERT.equals((Object)d.operation)) {
                outputStr.append(addMarker).append(d.text.trim()).append(addMarker).append(" ");
                continue;
            }
            outputStr.append(removeMarker).append(d.text.trim()).append(removeMarker).append(" ");
        }
        String diff = outputStr.toString().trim();
        String spanAdd = ChangeEventParser.getAddMarker(publishTo);
        String spanAddClose = ChangeEventParser.getAddMarkerClose(publishTo);
        String spanRemove = ChangeEventParser.getRemoveMarker(publishTo);
        String spanRemoveClose = ChangeEventParser.getRemoveMarkerClose(publishTo);
        diff = ChangeEventParser.replaceMarkers(diff, addMarker, spanAdd, spanAddClose);
        diff = ChangeEventParser.replaceMarkers(diff, removeMarker, spanRemove, spanRemoveClose);
        return diff;
    }

    private static String replaceMarkers(String diff, String marker, String openTag, String closeTag) {
        int index = 0;
        while (diff.contains(marker)) {
            String replacement = index % 2 == 0 ? openTag : closeTag;
            diff = diff.replaceFirst(marker, replacement);
            ++index;
        }
        return diff;
    }

    public static Set<String> getUpdatedField(ChangeEvent event) {
        HashSet<String> fields = new HashSet<String>();
        ChangeDescription description = event.getChangeDescription();
        if (description != null) {
            ArrayList fieldChanges = new ArrayList();
            fieldChanges.addAll(description.getFieldsAdded());
            fieldChanges.addAll(description.getFieldsUpdated());
            fieldChanges.addAll(description.getFieldsDeleted());
            fieldChanges.forEach(field -> {
                String fieldName = field.getName();
                if (fieldName.contains(".")) {
                    String[] tokens = fieldName.split("\\.");
                    fields.add(tokens[tokens.length - 1]);
                } else {
                    fields.add(fieldName);
                }
            });
        }
        return fields;
    }

    public static enum PublishTo {
        FEED,
        SLACK,
        TEAMS,
        GCHAT,
        EMAIL;

    }

    public static enum ChangeType {
        UPDATE,
        ADD,
        DELETE;

    }
}

