/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.clients.pipeline;

import java.lang.reflect.InvocationTargetException;
import org.openmetadata.schema.api.configuration.pipelineServiceClient.PipelineServiceClientConfiguration;
import org.openmetadata.sdk.PipelineServiceClient;
import org.openmetadata.sdk.exception.PipelineServiceClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PipelineServiceClientFactory {
    private static final Logger LOG = LoggerFactory.getLogger(PipelineServiceClientFactory.class);
    private static PipelineServiceClient pipelineServiceClient;

    private PipelineServiceClientFactory() {
    }

    public static PipelineServiceClient createPipelineServiceClient(PipelineServiceClientConfiguration config) {
        if (pipelineServiceClient != null) {
            return pipelineServiceClient;
        }
        String pipelineServiceClientClass = config.getClassName();
        LOG.info("Registering PipelineServiceClient: {}", (Object)pipelineServiceClientClass);
        try {
            pipelineServiceClient = Class.forName(pipelineServiceClientClass).asSubclass(PipelineServiceClient.class).getConstructor(PipelineServiceClientConfiguration.class).newInstance(config);
            return pipelineServiceClient;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new PipelineServiceClientException(String.format("Error trying to load PipelineServiceClient %s: %s", pipelineServiceClientClass, e.getMessage()));
        }
    }

    public static PipelineServiceClient getPipelineServiceClient() {
        return pipelineServiceClient;
    }
}

