/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.dataInsight;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.openmetadata.schema.dataInsight.type.PercentageOfEntitiesWithDescriptionByType;
import org.openmetadata.service.dataInsight.DataInsightAggregatorInterface;

public abstract class EntitiesDescriptionAggregator<A, B, M, S>
implements DataInsightAggregatorInterface {
    private final A aggregations;

    public EntitiesDescriptionAggregator(A aggregations) {
        this.aggregations = aggregations;
    }

    @Override
    public List<Object> aggregate() throws ParseException {
        M timestampBuckets = this.getTimestampBuckets(this.aggregations);
        ArrayList<Object> data = new ArrayList<Object>();
        for (B timestampBucket : this.getBuckets(timestampBuckets)) {
            String dateTimeString = this.getKeyAsString(timestampBucket);
            Long timestamp = this.convertDatTimeStringToTimestamp(dateTimeString);
            M entityTypeBuckets = this.getEntityBuckets(timestampBucket);
            for (B entityTypeBucket : this.getBuckets(entityTypeBuckets)) {
                String entityType = this.getKeyAsString(entityTypeBucket);
                S sumCompletedDescriptions = this.getAggregations(entityTypeBucket, "completedDescriptionFraction");
                S sumEntityCount = this.getAggregations(entityTypeBucket, "entityCount");
                data.add(new PercentageOfEntitiesWithDescriptionByType().withTimestamp(timestamp).withEntityType(entityType).withEntityCount(this.getValue(sumEntityCount)).withCompletedDescription(this.getValue(sumCompletedDescriptions)).withCompletedDescriptionFraction(Double.valueOf(this.getValue(sumCompletedDescriptions) / this.getValue(sumEntityCount))));
            }
        }
        return data;
    }

    protected abstract String getKeyAsString(B var1);

    protected abstract List<? extends B> getBuckets(M var1);

    protected abstract M getEntityBuckets(B var1);

    protected abstract M getTimestampBuckets(A var1);

    protected abstract S getAggregations(B var1, String var2);

    protected abstract Double getValue(S var1);
}

