/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.dataInsight;

import java.util.ArrayList;
import java.util.List;
import org.openmetadata.schema.dataInsight.type.MostActiveUsers;
import org.openmetadata.service.dataInsight.DataInsightAggregatorInterface;

public abstract class MostActiveUsersAggregator<A, B, M, S, X>
implements DataInsightAggregatorInterface {
    private final A aggregations;

    public MostActiveUsersAggregator(A aggregations) {
        this.aggregations = aggregations;
    }

    @Override
    public List<Object> aggregate() {
        M userNameBuckets = this.getUserNameBuckets(this.aggregations);
        ArrayList<Object> data = new ArrayList<Object>();
        for (B userNameBucket : this.getBuckets(userNameBuckets)) {
            String userName = this.getKeyAsString(userNameBucket);
            S sumSession = this.getSumAggregations(userNameBucket, "sessions");
            S sumPageViews = this.getSumAggregations(userNameBucket, "pageViews");
            S sumSessionDuration = this.getSumAggregations(userNameBucket, "sessionDuration");
            X lastSession = this.getMaxAggregations(userNameBucket, "lastSession");
            M teamBucket = this.getTeamBuckets(userNameBucket);
            String team = null;
            if (!this.getBuckets(teamBucket).isEmpty()) {
                team = this.getKeyAsString(this.getBuckets(teamBucket).get(0));
            }
            data.add(new MostActiveUsers().withUserName(userName).withLastSession(this.getMaxValue(lastSession)).withPageViews(this.getSumValue(sumPageViews)).withSessionDuration(this.getSumValue(sumSessionDuration)).withSessions(this.getSumValue(sumSession)).withTeam(team).withAvgSessionDuration(Double.valueOf(this.getSumValue(sumSessionDuration) / this.getSumValue(sumSession))));
        }
        return data;
    }

    protected abstract Double getSumValue(S var1);

    protected abstract Long getMaxValue(X var1);

    protected abstract String getKeyAsString(B var1);

    protected abstract S getSumAggregations(B var1, String var2);

    protected abstract X getMaxAggregations(B var1, String var2);

    protected abstract List<? extends B> getBuckets(M var1);

    protected abstract M getUserNameBuckets(A var1);

    protected abstract M getTeamBuckets(B var1);
}

