/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.events.subscription;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.ws.rs.BadRequestException;
import org.openmetadata.schema.api.events.CreateEventSubscription;
import org.openmetadata.schema.entity.events.EventFilterRule;
import org.openmetadata.schema.entity.events.EventSubscription;
import org.openmetadata.schema.entity.events.FilteringRules;
import org.openmetadata.schema.entity.events.SubscriptionStatus;
import org.openmetadata.schema.entity.services.ingestionPipelines.PipelineStatusType;
import org.openmetadata.schema.tests.type.TestCaseStatus;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.schema.type.EventType;
import org.openmetadata.schema.type.Function;
import org.openmetadata.schema.type.ParamAdditionalContext;
import org.openmetadata.schema.type.SubscriptionFilterOperation;
import org.openmetadata.service.Entity;
import org.openmetadata.service.events.subscription.ActivityFeedAlertCache;
import org.openmetadata.service.events.subscription.AlertsRuleEvaluator;
import org.openmetadata.service.events.subscription.SubscriptionPublisher;
import org.openmetadata.service.events.subscription.email.EmailPublisher;
import org.openmetadata.service.events.subscription.gchat.GChatPublisher;
import org.openmetadata.service.events.subscription.generic.GenericPublisher;
import org.openmetadata.service.events.subscription.msteams.MSTeamsPublisher;
import org.openmetadata.service.events.subscription.slack.SlackEventPublisher;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.resources.CollectionRegistry;
import org.openmetadata.service.search.models.IndexMapping;
import org.openmetadata.service.security.policyevaluator.CompiledRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public final class AlertUtil {
    private static final Logger LOG = LoggerFactory.getLogger(AlertUtil.class);

    private AlertUtil() {
    }

    public static SubscriptionPublisher getNotificationsPublisher(EventSubscription subscription, CollectionDAO daoCollection) {
        AlertUtil.validateSubscriptionConfig(subscription);
        return switch (subscription.getSubscriptionType()) {
            case CreateEventSubscription.SubscriptionType.SLACK_WEBHOOK -> new SlackEventPublisher(subscription, daoCollection);
            case CreateEventSubscription.SubscriptionType.MS_TEAMS_WEBHOOK -> new MSTeamsPublisher(subscription, daoCollection);
            case CreateEventSubscription.SubscriptionType.G_CHAT_WEBHOOK -> new GChatPublisher(subscription, daoCollection);
            case CreateEventSubscription.SubscriptionType.GENERIC_WEBHOOK -> new GenericPublisher(subscription, daoCollection);
            case CreateEventSubscription.SubscriptionType.EMAIL -> new EmailPublisher(subscription, daoCollection);
            case CreateEventSubscription.SubscriptionType.ACTIVITY_FEED -> throw new IllegalArgumentException("Cannot create Activity Feed as Publisher.");
            default -> throw new IllegalArgumentException("Invalid Alert Action Specified.");
        };
    }

    public static void validateSubscriptionConfig(EventSubscription eventSubscription) {
        if (eventSubscription.getAlertType() != CreateEventSubscription.AlertType.CHANGE_EVENT) {
            throw new IllegalArgumentException("Invalid Alert Type");
        }
        if (CreateEventSubscription.SubscriptionType.ACTIVITY_FEED.equals((Object)eventSubscription.getSubscriptionType())) {
            return;
        }
        if (eventSubscription.getSubscriptionConfig() == null) {
            throw new BadRequestException("subscriptionConfig cannot be null.");
        }
    }

    public static <T> T validateExpression(String condition, Class<T> clz) {
        if (condition == null) {
            return null;
        }
        Expression expression = CompiledRule.parseExpression(condition);
        AlertsRuleEvaluator ruleEvaluator = new AlertsRuleEvaluator(null);
        try {
            return (T)expression.getValue((Object)ruleEvaluator, clz);
        }
        catch (Exception exception) {
            String message = exception.getMessage().replaceAll("on type .*$", "").replaceAll("on object .*$", "");
            throw new IllegalArgumentException(CatalogExceptionMessage.failedToEvaluate(message));
        }
    }

    public static Map<String, Function> getAlertFilterFunctions() {
        HashMap<String, Function> alertFunctions = new HashMap<String, Function>();
        for (Function func : CollectionRegistry.getInstance().getFunctions(AlertsRuleEvaluator.class)) {
            SubscriptionFilterOperation type = SubscriptionFilterOperation.valueOf((String)func.getName());
            ParamAdditionalContext paramAdditionalContext = new ParamAdditionalContext();
            switch (type) {
                case matchAnySource: {
                    func.setParamAdditionalContext(paramAdditionalContext.withData(new HashSet<String>(Entity.getEntityList())));
                    break;
                }
                case matchUpdatedBy: 
                case matchAnyOwnerName: {
                    func.setParamAdditionalContext(paramAdditionalContext.withData(AlertUtil.getEntitiesIndex(List.of("user", "team"))));
                    break;
                }
                case matchAnyEntityFqn: 
                case matchAnyEntityId: {
                    func.setParamAdditionalContext(paramAdditionalContext.withData(AlertUtil.getEntitiesIndex(Entity.getEntityList())));
                    break;
                }
                case matchAnyEventType: {
                    List<String> eventTypes = Stream.of(EventType.values()).map(EventType::value).toList();
                    func.setParamAdditionalContext(paramAdditionalContext.withData(new HashSet<String>(eventTypes)));
                    break;
                }
                case matchIngestionPipelineState: {
                    List<String> ingestionPipelineState = Stream.of(PipelineStatusType.values()).map(PipelineStatusType::value).toList();
                    func.setParamAdditionalContext(paramAdditionalContext.withData(new HashSet<String>(ingestionPipelineState)));
                    break;
                }
                case matchTestResult: {
                    List<String> testResultStatus = Stream.of(TestCaseStatus.values()).map(TestCaseStatus::value).toList();
                    func.setParamAdditionalContext(paramAdditionalContext.withData(new HashSet<String>(testResultStatus)));
                    break;
                }
                default: {
                    LOG.error("Invalid Function name : {}", (Object)type);
                }
            }
            alertFunctions.put(func.getName(), func);
        }
        return alertFunctions;
    }

    public static Set<String> getEntitiesIndex(List<String> entities) {
        HashSet<String> indexesToSearch = new HashSet<String>();
        for (String entityType : entities) {
            try {
                IndexMapping indexMapping = Entity.getSearchRepository().getIndexMapping(entityType);
                indexesToSearch.add(indexMapping.getIndexName());
            }
            catch (RuntimeException ex) {
                LOG.error("Failing to get Index for EntityType");
            }
        }
        return indexesToSearch;
    }

    public static boolean evaluateAlertConditions(ChangeEvent changeEvent, List<EventFilterRule> alertFilterRules) {
        if (!alertFilterRules.isEmpty()) {
            String completeCondition = AlertUtil.buildCompleteCondition(alertFilterRules);
            AlertsRuleEvaluator ruleEvaluator = new AlertsRuleEvaluator(changeEvent);
            StandardEvaluationContext evaluationContext = new StandardEvaluationContext((Object)ruleEvaluator);
            Expression expression = CompiledRule.parseExpression(completeCondition);
            boolean result = Boolean.TRUE.equals(expression.getValue((EvaluationContext)evaluationContext, Boolean.class));
            LOG.debug("Alert evaluated as Result : {}", (Object)result);
            return result;
        }
        return true;
    }

    public static String buildCompleteCondition(List<EventFilterRule> alertFilterRules) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < alertFilterRules.size(); ++i) {
            EventFilterRule rule = alertFilterRules.get(i);
            builder.append("(");
            if (rule.getEffect() == EventFilterRule.Effect.INCLUDE) {
                builder.append(rule.getCondition());
            } else {
                builder.append("!");
                builder.append(rule.getCondition());
            }
            builder.append(")");
            if (i == alertFilterRules.size() - 1) continue;
            builder.append(" && ");
        }
        return builder.toString();
    }

    public static boolean shouldTriggerAlert(String entityType, FilteringRules config) {
        if (config == null) {
            return true;
        }
        if (config.getResources().size() == 1 && ((String)config.getResources().get(0)).equals("all")) {
            return true;
        }
        return config.getResources().contains(entityType);
    }

    public static boolean shouldProcessActivityFeedRequest(ChangeEvent event) {
        FilteringRules filteringRules = ActivityFeedAlertCache.getActivityFeedAlert().getFilteringRules();
        return AlertUtil.shouldTriggerAlert(event.getEntityType(), filteringRules) && AlertUtil.evaluateAlertConditions(event, filteringRules.getRules());
    }

    public static SubscriptionStatus buildSubscriptionStatus(SubscriptionStatus.Status status, Long lastSuccessful, Long lastFailure, Integer statusCode, String reason, Long nextAttempt, Long timeStamp) {
        return new SubscriptionStatus().withStatus(status).withLastSuccessfulAt(lastSuccessful).withLastFailedAt(lastFailure).withLastFailedStatusCode(statusCode).withLastFailedReason(reason).withNextAttempt(nextAttempt).withTimestamp(timeStamp);
    }
}

