/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.events.subscription.gchat;

import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Invocation;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.SubscriptionAction;
import org.openmetadata.schema.api.events.CreateEventSubscription;
import org.openmetadata.schema.entity.events.EventSubscription;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.schema.type.Webhook;
import org.openmetadata.service.events.errors.EventPublisherException;
import org.openmetadata.service.events.subscription.SubscriptionPublisher;
import org.openmetadata.service.events.subscription.gchat.GChatMessage;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.formatter.decorators.GChatMessageDecorator;
import org.openmetadata.service.formatter.decorators.MessageDecorator;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.resources.events.EventResource;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.SubscriptionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GChatPublisher
extends SubscriptionPublisher {
    private static final Logger LOG = LoggerFactory.getLogger(GChatPublisher.class);
    private final MessageDecorator<GChatMessage> gChatMessageMessageDecorator = new GChatMessageDecorator();
    private final Webhook webhook;
    private Invocation.Builder target;
    private final Client client;
    private final CollectionDAO daoCollection;

    public GChatPublisher(EventSubscription eventSub, CollectionDAO dao) {
        super(eventSub);
        if (eventSub.getSubscriptionType() == CreateEventSubscription.SubscriptionType.G_CHAT_WEBHOOK) {
            String gChatWebhookURL;
            this.daoCollection = dao;
            this.webhook = JsonUtils.convertValue(eventSub.getSubscriptionConfig(), Webhook.class);
            this.client = SubscriptionUtil.getClient(eventSub.getTimeout(), eventSub.getReadTimeout());
            if (this.webhook.getEndpoint() != null && !CommonUtil.nullOrEmpty((String)(gChatWebhookURL = this.webhook.getEndpoint().toString()))) {
                this.target = this.client.target(gChatWebhookURL).request();
            }
        } else {
            throw new IllegalArgumentException("GChat Alert Invoked with Illegal Type and Settings.");
        }
    }

    @Override
    protected void onStartDelegate() {
        LOG.info("GChat Webhook publisher started");
    }

    @Override
    protected void onShutdownDelegate() {
        if (null != this.client) {
            this.client.close();
        }
    }

    @Override
    protected void sendAlert(EventResource.EventList list) {
        for (ChangeEvent event : list.getData()) {
            try {
                GChatMessage gchatMessage = this.gChatMessageMessageDecorator.buildMessage(event);
                List<Invocation.Builder> targets = SubscriptionUtil.getTargetsForWebhook((SubscriptionAction)this.webhook, CreateEventSubscription.SubscriptionType.G_CHAT_WEBHOOK, this.client, this.daoCollection, event);
                if (this.target != null) {
                    targets.add(this.target);
                }
                for (Invocation.Builder actionTarget : targets) {
                    SubscriptionUtil.postWebhookMessage(this, actionTarget, gchatMessage);
                }
            }
            catch (Exception e) {
                String message = CatalogExceptionMessage.eventPublisherFailedToPublish(CreateEventSubscription.SubscriptionType.G_CHAT_WEBHOOK, event, e.getMessage());
                LOG.error(message);
                throw new EventPublisherException(message);
            }
        }
    }
}

