/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.events.subscription.generic;

import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Invocation;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.SubscriptionAction;
import org.openmetadata.schema.api.events.CreateEventSubscription;
import org.openmetadata.schema.entity.events.EventSubscription;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.schema.type.Webhook;
import org.openmetadata.service.events.errors.EventPublisherException;
import org.openmetadata.service.events.subscription.SubscriptionPublisher;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.resources.events.EventResource;
import org.openmetadata.service.security.SecurityUtil;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.SubscriptionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericPublisher
extends SubscriptionPublisher {
    private static final Logger LOG = LoggerFactory.getLogger(GenericPublisher.class);
    private final Client client;
    private final Webhook webhook;
    private final CollectionDAO daoCollection;

    public GenericPublisher(EventSubscription eventSub, CollectionDAO dao) {
        super(eventSub);
        if (eventSub.getSubscriptionType() != CreateEventSubscription.SubscriptionType.GENERIC_WEBHOOK) {
            throw new IllegalArgumentException("GenericWebhook Alert Invoked with Illegal Type and Settings.");
        }
        this.daoCollection = dao;
        this.webhook = JsonUtils.convertValue(eventSub.getSubscriptionConfig(), Webhook.class);
        this.client = SubscriptionUtil.getClient(eventSub.getTimeout(), eventSub.getReadTimeout());
    }

    @Override
    public void onStartDelegate() {
        LOG.info("Generic Webhook Publisher Started");
    }

    @Override
    public void onShutdownDelegate() {
        if (this.client != null) {
            this.client.close();
        }
    }

    private Invocation.Builder getTarget() {
        Map<String, String> authHeaders = SecurityUtil.authHeaders("admin@open-metadata.org");
        return SecurityUtil.addHeaders(this.client.target(this.webhook.getEndpoint()), authHeaders);
    }

    @Override
    public void sendAlert(EventResource.EventList list) throws EventPublisherException {
        long attemptTime = System.currentTimeMillis();
        try {
            String json = JsonUtils.pojoToJson(list);
            if (this.webhook.getEndpoint() != null) {
                if (this.webhook.getSecretKey() != null && !this.webhook.getSecretKey().isEmpty()) {
                    String hmac = "sha256=" + CommonUtil.calculateHMAC((String)this.webhook.getSecretKey(), (String)json);
                    SubscriptionUtil.postWebhookMessage(this, this.getTarget().header("X-OM-Signature", (Object)hmac), json);
                } else {
                    SubscriptionUtil.postWebhookMessage(this, this.getTarget(), json);
                }
            }
            for (ChangeEvent event : list.getData()) {
                String eventJson = JsonUtils.pojoToJson(event);
                List<Invocation.Builder> targets = SubscriptionUtil.getTargetsForWebhook((SubscriptionAction)this.webhook, CreateEventSubscription.SubscriptionType.GENERIC_WEBHOOK, this.client, this.daoCollection, event);
                for (Invocation.Builder actionTarget : targets) {
                    SubscriptionUtil.postWebhookMessage(this, actionTarget, eventJson);
                }
            }
        }
        catch (Exception ex) {
            Throwable cause = ex.getCause();
            if (cause != null && cause.getClass() == UnknownHostException.class) {
                LOG.warn("Invalid webhook {} endpoint {}", (Object)this.eventSubscription.getName(), (Object)this.webhook.getEndpoint());
                this.setErrorStatus(attemptTime, 400, "UnknownHostException");
            }
            LOG.debug("Exception occurred while publishing webhook", (Throwable)ex);
        }
    }
}

