/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.Chart;
import org.openmetadata.schema.entity.services.DashboardService;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChartRepository
extends EntityRepository<Chart> {
    private static final Logger LOG = LoggerFactory.getLogger(ChartRepository.class);

    public ChartRepository() {
        super("v1/charts/", "chart", Chart.class, Entity.getCollectionDAO().chartDAO(), "", "");
        this.supportsSearch = true;
    }

    @Override
    public void setFullyQualifiedName(Chart chart) {
        chart.setFullyQualifiedName(FullyQualifiedName.add(chart.getService().getFullyQualifiedName(), chart.getName()));
    }

    @Override
    public void prepare(Chart chart, boolean update) {
        DashboardService dashboardService = (DashboardService)Entity.getEntity(chart.getService(), "", Include.ALL);
        chart.setService(dashboardService.getEntityReference());
        chart.setServiceType(dashboardService.getServiceType());
    }

    @Override
    public void storeEntity(Chart chart, boolean update) {
        EntityReference service = chart.getService();
        chart.withService(null);
        this.store(chart, update);
        chart.withService(service);
    }

    @Override
    public void storeRelationships(Chart chart) {
        EntityReference service = chart.getService();
        this.addRelationship(service.getId(), chart.getId(), service.getType(), "chart", Relationship.CONTAINS);
    }

    @Override
    public Chart setInheritedFields(Chart chart, EntityUtil.Fields fields) {
        DashboardService dashboardService = (DashboardService)Entity.getEntity(chart.getService(), "domain", Include.ALL);
        return this.inheritDomain(chart, fields, (EntityInterface)dashboardService);
    }

    @Override
    public Chart setFields(Chart chart, EntityUtil.Fields fields) {
        return chart.withService(this.getContainer(chart.getId()));
    }

    @Override
    public Chart clearFields(Chart chart, EntityUtil.Fields fields) {
        return chart;
    }

    @Override
    public void restorePatchAttributes(Chart original, Chart updated) {
        updated.withFullyQualifiedName(original.getFullyQualifiedName()).withName(original.getName()).withService(original.getService()).withId(original.getId());
    }

    @Override
    public EntityRepository.EntityUpdater getUpdater(Chart original, Chart updated, EntityRepository.Operation operation) {
        return new ChartUpdater(original, updated, operation);
    }

    @Override
    public EntityInterface getParentEntity(Chart entity, String fields) {
        return (EntityInterface)Entity.getEntity(entity.getService(), fields, Include.NON_DELETED);
    }

    public class ChartUpdater
    extends EntityRepository.ColumnEntityUpdater {
        public ChartUpdater(Chart chart, Chart updated, EntityRepository.Operation operation) {
            super((EntityRepository)ChartRepository.this, (EntityInterface)chart, (EntityInterface)updated, operation);
        }

        @Override
        @Transaction
        public void entitySpecificUpdate() {
            this.recordChange("chartType", ((Chart)this.original).getChartType(), ((Chart)this.updated).getChartType());
            this.recordChange("sourceUrl", ((Chart)this.original).getSourceUrl(), ((Chart)this.updated).getSourceUrl());
        }
    }
}

