/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.util.List;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.Database;
import org.openmetadata.schema.entity.services.DatabaseService;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseRepository
extends EntityRepository<Database> {
    private static final Logger LOG = LoggerFactory.getLogger(DatabaseRepository.class);

    public DatabaseRepository() {
        super("v1/databases/", "database", Database.class, Entity.getCollectionDAO().databaseDAO(), "", "");
        this.supportsSearch = true;
    }

    @Override
    public void setFullyQualifiedName(Database database) {
        database.setFullyQualifiedName(FullyQualifiedName.build(database.getService().getName(), database.getName()));
    }

    @Override
    public void prepare(Database database, boolean update) {
        this.populateService(database);
    }

    @Override
    public void storeEntity(Database database, boolean update) {
        EntityReference service = database.getService();
        database.withService(null);
        this.store(database, update);
        database.withService(service);
    }

    @Override
    public void storeRelationships(Database database) {
        EntityReference service = database.getService();
        this.addRelationship(service.getId(), database.getId(), service.getType(), "database", Relationship.CONTAINS);
    }

    @Override
    public Database setInheritedFields(Database database, EntityUtil.Fields fields) {
        DatabaseService service = (DatabaseService)Entity.getEntity("databaseService", database.getService().getId(), "domain", Include.ALL);
        return this.inheritDomain(database, fields, (EntityInterface)service);
    }

    private List<EntityReference> getSchemas(Database database) {
        return database == null ? null : this.findTo(database.getId(), "database", Relationship.CONTAINS, "databaseSchema");
    }

    @Override
    public EntityInterface getParentEntity(Database entity, String fields) {
        return (EntityInterface)Entity.getEntity(entity.getService(), fields, Include.NON_DELETED);
    }

    @Override
    public Database setFields(Database database, EntityUtil.Fields fields) {
        database.setService(this.getContainer(database.getId()));
        database.setDatabaseSchemas(fields.contains("databaseSchemas") ? this.getSchemas(database) : database.getDatabaseSchemas());
        if (database.getUsageSummary() == null) {
            database.setUsageSummary(fields.contains("usageSummary") ? EntityUtil.getLatestUsage(this.daoCollection.usageDAO(), database.getId()) : null);
        }
        return database;
    }

    @Override
    public Database clearFields(Database database, EntityUtil.Fields fields) {
        database.setDatabaseSchemas(fields.contains("databaseSchemas") ? database.getDatabaseSchemas() : null);
        return database.withUsageSummary(fields.contains("usageSummary") ? database.getUsageSummary() : null);
    }

    @Override
    public void restorePatchAttributes(Database original, Database updated) {
        updated.withFullyQualifiedName(original.getFullyQualifiedName()).withName(original.getName()).withService(original.getService()).withId(original.getId());
    }

    @Override
    public EntityRepository.EntityUpdater getUpdater(Database original, Database updated, EntityRepository.Operation operation) {
        return new DatabaseUpdater(original, updated, operation);
    }

    private void populateService(Database database) {
        DatabaseService service = (DatabaseService)Entity.getEntity(database.getService(), "", Include.NON_DELETED);
        database.setService(service.getEntityReference());
        database.setServiceType(service.getServiceType());
    }

    public class DatabaseUpdater
    extends EntityRepository.EntityUpdater {
        public DatabaseUpdater(Database original, Database updated, EntityRepository.Operation operation) {
            super((EntityRepository)DatabaseRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        @Transaction
        public void entitySpecificUpdate() {
            this.recordChange("retentionPeriod", ((Database)this.original).getRetentionPeriod(), ((Database)this.updated).getRetentionPeriod());
            this.recordChange("sourceUrl", ((Database)this.original).getSourceUrl(), ((Database)this.updated).getSourceUrl());
        }
    }
}

