/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entities.docStore.Document;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.util.EntityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentRepository
extends EntityRepository<Document> {
    private static final Logger LOG = LoggerFactory.getLogger(DocumentRepository.class);
    static final String DOCUMENT_UPDATE_FIELDS = "data";
    static final String DOCUMENT_PATCH_FIELDS = "data";

    public DocumentRepository() {
        super("/v1/docStore", "document", Document.class, Entity.getCollectionDAO().docStoreDAO(), "data", "data");
        this.supportsSearch = false;
    }

    @Override
    public void setFullyQualifiedName(Document doc) {
        doc.setFullyQualifiedName(doc.getFullyQualifiedName());
    }

    @Override
    public void restorePatchAttributes(Document original, Document updated) {
        updated.withName(original.getName()).withId(original.getId());
    }

    @Override
    public Document setFields(Document document, EntityUtil.Fields fields) {
        return document;
    }

    @Override
    public Document clearFields(Document document, EntityUtil.Fields fields) {
        return document;
    }

    @Override
    public void prepare(Document document, boolean update) {
    }

    @Override
    public void storeEntity(Document document, boolean update) {
        this.store(document, update);
    }

    @Override
    public void storeRelationships(Document entity) {
    }

    public DocumentUpdater getUpdater(Document original, Document updated, EntityRepository.Operation operation) {
        return new DocumentUpdater(original, updated, operation);
    }

    public class DocumentUpdater
    extends EntityRepository.EntityUpdater {
        public DocumentUpdater(Document original, Document updated, EntityRepository.Operation operation) {
            super((EntityRepository)DocumentRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        @Transaction
        public void entitySpecificUpdate() {
            this.recordChange("data", ((Document)this.original).getData(), ((Document)this.updated).getData(), true);
        }
    }
}

