/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.DatabaseSchema;
import org.openmetadata.schema.entity.data.StoredProcedure;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;

public class StoredProcedureRepository
extends EntityRepository<StoredProcedure> {
    static final String PATCH_FIELDS = "storedProcedureCode,sourceUrl";
    static final String UPDATE_FIELDS = "storedProcedureCode,sourceUrl";

    public StoredProcedureRepository() {
        super("v1/storedProcedures/", "storedProcedure", StoredProcedure.class, Entity.getCollectionDAO().storedProcedureDAO(), "storedProcedureCode,sourceUrl", "storedProcedureCode,sourceUrl");
        this.supportsSearch = true;
    }

    @Override
    public void setFullyQualifiedName(StoredProcedure storedProcedure) {
        storedProcedure.setFullyQualifiedName(FullyQualifiedName.add(storedProcedure.getDatabaseSchema().getFullyQualifiedName(), storedProcedure.getName()));
    }

    @Override
    public void prepare(StoredProcedure storedProcedure, boolean update) {
        DatabaseSchema schema = (DatabaseSchema)Entity.getEntity(storedProcedure.getDatabaseSchema(), "", Include.ALL);
        storedProcedure.withDatabaseSchema(schema.getEntityReference()).withDatabase(schema.getDatabase()).withService(schema.getService()).withServiceType(schema.getServiceType());
    }

    @Override
    public void storeEntity(StoredProcedure storedProcedure, boolean update) {
        EntityReference service = storedProcedure.getService();
        storedProcedure.withService(null);
        this.store(storedProcedure, update);
        storedProcedure.withService(service);
    }

    @Override
    public void storeRelationships(StoredProcedure storedProcedure) {
        this.addRelationship(storedProcedure.getDatabaseSchema().getId(), storedProcedure.getId(), "databaseSchema", "storedProcedure", Relationship.CONTAINS);
    }

    @Override
    public StoredProcedure setInheritedFields(StoredProcedure storedProcedure, EntityUtil.Fields fields) {
        DatabaseSchema schema = (DatabaseSchema)Entity.getEntity("databaseSchema", storedProcedure.getDatabaseSchema().getId(), "owner,domain", Include.ALL);
        this.inheritOwner(storedProcedure, fields, (EntityInterface)schema);
        this.inheritDomain(storedProcedure, fields, (EntityInterface)schema);
        return storedProcedure;
    }

    @Override
    public StoredProcedure setFields(StoredProcedure storedProcedure, EntityUtil.Fields fields) {
        this.setDefaultFields(storedProcedure);
        storedProcedure.setFollowers(fields.contains("followers") ? this.getFollowers(storedProcedure) : null);
        return storedProcedure;
    }

    @Override
    public StoredProcedure clearFields(StoredProcedure storedProcedure, EntityUtil.Fields fields) {
        return storedProcedure;
    }

    private void setDefaultFields(StoredProcedure storedProcedure) {
        EntityReference schemaRef = this.getContainer(storedProcedure.getId());
        DatabaseSchema schema = (DatabaseSchema)Entity.getEntity(schemaRef, "", Include.ALL);
        storedProcedure.withDatabaseSchema(schemaRef).withDatabase(schema.getDatabase()).withService(schema.getService());
    }

    public StoredProcedureUpdater getUpdater(StoredProcedure original, StoredProcedure updated, EntityRepository.Operation operation) {
        return new StoredProcedureUpdater(original, updated, operation);
    }

    @Override
    public EntityInterface getParentEntity(StoredProcedure entity, String fields) {
        return (EntityInterface)Entity.getEntity(entity.getDatabaseSchema(), fields, Include.NON_DELETED);
    }

    public void setService(StoredProcedure storedProcedure, EntityReference service) {
        if (service != null && storedProcedure != null) {
            this.addRelationship(service.getId(), storedProcedure.getId(), service.getType(), "storedProcedure", Relationship.CONTAINS);
            storedProcedure.setService(service);
        }
    }

    public class StoredProcedureUpdater
    extends EntityRepository.EntityUpdater {
        public StoredProcedureUpdater(StoredProcedure original, StoredProcedure updated, EntityRepository.Operation operation) {
            super((EntityRepository)StoredProcedureRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        @Transaction
        public void entitySpecificUpdate() {
            if (((StoredProcedure)this.updated).getStoredProcedureCode() != null) {
                this.recordChange("storedProcedureCode", ((StoredProcedure)this.original).getStoredProcedureCode(), ((StoredProcedure)this.updated).getStoredProcedureCode());
            }
            this.recordChange("sourceUrl", ((StoredProcedure)this.original).getSourceUrl(), ((StoredProcedure)this.updated).getSourceUrl());
        }
    }
}

